/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.event;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEventType;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.event.visitor.SchemaChangeEventVisitor;
import org.apache.flink.cdc.runtime.serializer.EnumSerializer;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.cdc.runtime.serializer.event.AddColumnEventSerializer;
import org.apache.flink.cdc.runtime.serializer.event.AlterColumnTypeEventSerializer;
import org.apache.flink.cdc.runtime.serializer.event.CreateTableEventSerializer;
import org.apache.flink.cdc.runtime.serializer.event.DropColumnEventSerializer;
import org.apache.flink.cdc.runtime.serializer.event.DropTableEventSerializer;
import org.apache.flink.cdc.runtime.serializer.event.RenameColumnEventSerializer;
import org.apache.flink.cdc.runtime.serializer.event.TruncateTableEventSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class SchemaChangeEventSerializer
extends TypeSerializerSingleton<SchemaChangeEvent> {
    private static final long serialVersionUID = 1L;
    public static final SchemaChangeEventSerializer INSTANCE = new SchemaChangeEventSerializer();
    private final EnumSerializer<SchemaChangeEventType> enumSerializer = new EnumSerializer<SchemaChangeEventType>(SchemaChangeEventType.class);

    public boolean isImmutableType() {
        return false;
    }

    public SchemaChangeEvent createInstance() {
        return new SchemaChangeEvent(){

            @Override
            public SchemaChangeEventType getType() {
                return null;
            }

            @Override
            public TableId tableId() {
                return TableId.tableId("unknown", "unknown", "unknown");
            }

            @Override
            public SchemaChangeEvent copy(TableId newTableId) {
                return null;
            }
        };
    }

    public SchemaChangeEvent copy(SchemaChangeEvent from) {
        return SchemaChangeEventVisitor.visit(from, AddColumnEventSerializer.INSTANCE::copy, AlterColumnTypeEventSerializer.INSTANCE::copy, CreateTableEventSerializer.INSTANCE::copy, DropColumnEventSerializer.INSTANCE::copy, DropTableEventSerializer.INSTANCE::copy, RenameColumnEventSerializer.INSTANCE::copy, TruncateTableEventSerializer.INSTANCE::copy);
    }

    public SchemaChangeEvent copy(SchemaChangeEvent from, SchemaChangeEvent reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(SchemaChangeEvent record, DataOutputView target) throws IOException {
        SchemaChangeEventVisitor.visit(record, addColumnEvent -> {
            this.enumSerializer.serialize(SchemaChangeEventType.ADD_COLUMN, target);
            AddColumnEventSerializer.INSTANCE.serialize(addColumnEvent, target);
            return null;
        }, alterColumnTypeEvent -> {
            this.enumSerializer.serialize(SchemaChangeEventType.ALTER_COLUMN_TYPE, target);
            AlterColumnTypeEventSerializer.INSTANCE.serialize(alterColumnTypeEvent, target);
            return null;
        }, createTableEvent -> {
            this.enumSerializer.serialize(SchemaChangeEventType.CREATE_TABLE, target);
            CreateTableEventSerializer.INSTANCE.serialize(createTableEvent, target);
            return null;
        }, dropColumnEvent -> {
            this.enumSerializer.serialize(SchemaChangeEventType.DROP_COLUMN, target);
            DropColumnEventSerializer.INSTANCE.serialize(dropColumnEvent, target);
            return null;
        }, dropTableEvent -> {
            this.enumSerializer.serialize(SchemaChangeEventType.DROP_TABLE, target);
            DropTableEventSerializer.INSTANCE.serialize(dropTableEvent, target);
            return null;
        }, renameColumnEvent -> {
            this.enumSerializer.serialize(SchemaChangeEventType.RENAME_COLUMN, target);
            RenameColumnEventSerializer.INSTANCE.serialize(renameColumnEvent, target);
            return null;
        }, truncateTableEvent -> {
            this.enumSerializer.serialize(SchemaChangeEventType.TRUNCATE_TABLE, target);
            TruncateTableEventSerializer.INSTANCE.serialize(truncateTableEvent, target);
            return null;
        });
    }

    public SchemaChangeEvent deserialize(DataInputView source) throws IOException {
        SchemaChangeEventType schemaChangeEventType = (SchemaChangeEventType)((Object)this.enumSerializer.deserialize(source));
        switch (schemaChangeEventType) {
            case ADD_COLUMN: {
                return AddColumnEventSerializer.INSTANCE.deserialize(source);
            }
            case DROP_COLUMN: {
                return DropColumnEventSerializer.INSTANCE.deserialize(source);
            }
            case CREATE_TABLE: {
                return CreateTableEventSerializer.INSTANCE.deserialize(source);
            }
            case RENAME_COLUMN: {
                return RenameColumnEventSerializer.INSTANCE.deserialize(source);
            }
            case ALTER_COLUMN_TYPE: {
                return AlterColumnTypeEventSerializer.INSTANCE.deserialize(source);
            }
            case DROP_TABLE: {
                return DropTableEventSerializer.INSTANCE.deserialize(source);
            }
            case TRUNCATE_TABLE: {
                return TruncateTableEventSerializer.INSTANCE.deserialize(source);
            }
        }
        throw new IllegalArgumentException("Unknown schema change event class: " + (Object)((Object)schemaChangeEventType));
    }

    public SchemaChangeEvent deserialize(SchemaChangeEvent reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<SchemaChangeEvent> snapshotConfiguration() {
        return new SchemaChangeEventSerializerSnapshot();
    }

    public static final class SchemaChangeEventSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<SchemaChangeEvent> {
        public SchemaChangeEventSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

