/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class ListSerializer<T>
extends TypeSerializer<List<T>> {
    private static final long serialVersionUID = 1119562170939152304L;
    private final TypeSerializer<T> elementSerializer;

    public ListSerializer(TypeSerializer<T> elementSerializer) {
        this.elementSerializer = Preconditions.checkNotNull(elementSerializer);
    }

    public TypeSerializer<T> getElementSerializer() {
        return this.elementSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<List<T>> duplicate() {
        TypeSerializer duplicateElement = this.elementSerializer.duplicate();
        return duplicateElement == this.elementSerializer ? this : new ListSerializer<T>(duplicateElement);
    }

    public List<T> createInstance() {
        return new ArrayList(0);
    }

    public List<T> copy(List<T> from) {
        ArrayList<Object> newList = new ArrayList<Object>(from.size());
        for (T element : from) {
            newList.add(this.elementSerializer.copy(element));
        }
        return newList;
    }

    public List<T> copy(List<T> from, List<T> reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(List<T> list, DataOutputView target) throws IOException {
        int size = list.size();
        target.writeInt(size);
        for (T element : list) {
            this.elementSerializer.serialize(element, target);
        }
    }

    public List<T> deserialize(DataInputView source) throws IOException {
        int size = source.readInt();
        ArrayList<Object> list = new ArrayList<Object>(size + 1);
        for (int i = 0; i < size; ++i) {
            list.add(this.elementSerializer.deserialize(source));
        }
        return list;
    }

    public List<T> deserialize(List<T> reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int num = source.readInt();
        target.writeInt(num);
        for (int i = 0; i < num; ++i) {
            this.elementSerializer.copy(source, target);
        }
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == ((Object)((Object)this)).getClass() && this.elementSerializer.equals(((ListSerializer)((Object)obj)).elementSerializer);
    }

    public int hashCode() {
        return this.elementSerializer.hashCode();
    }

    public TypeSerializerSnapshot<List<T>> snapshotConfiguration() {
        return new ListSerializerSnapshot(this);
    }

    public static final class ListSerializerSnapshot<T>
    extends CompositeTypeSerializerSnapshot<List<T>, ListSerializer<T>> {
        private static final int CURRENT_VERSION = 1;

        public ListSerializerSnapshot() {
            super(ListSerializer.class);
        }

        public ListSerializerSnapshot(ListSerializer<T> listSerializer) {
            super(listSerializer);
        }

        public int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        protected ListSerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            TypeSerializer<?> elementSerializer = nestedSerializers[0];
            return new ListSerializer(elementSerializer);
        }

        protected TypeSerializer<?>[] getNestedSerializers(ListSerializer<T> outerSerializer) {
            return new TypeSerializer[]{outerSerializer.getElementSerializer()};
        }
    }
}

