/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.cdc.common.utils.StringUtils;
import org.apache.flink.cdc.runtime.operators.transform.UserDefinedFunctionDescriptor;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Location;
import org.codehaus.janino.ExpressionEvaluator;
import org.codehaus.janino.Java;

public class JaninoCompiler {
    private static final List<SqlTypeName> SQL_TYPE_NAME_IGNORE = Arrays.asList(SqlTypeName.SYMBOL);
    private static final List<String> TIMEZONE_FREE_TEMPORAL_FUNCTIONS = Arrays.asList("CURRENT_TIMESTAMP", "NOW");
    private static final List<String> TIMEZONE_REQUIRED_TEMPORAL_FUNCTIONS = Arrays.asList("LOCALTIME", "LOCALTIMESTAMP", "CURRENT_TIME", "CURRENT_DATE", "UNIX_TIMESTAMP");
    private static final List<String> TIMEZONE_FREE_TEMPORAL_CONVERSION_FUNCTIONS = Collections.emptyList();
    private static final List<String> TIMEZONE_REQUIRED_TEMPORAL_CONVERSION_FUNCTIONS = Arrays.asList("TO_DATE", "TO_TIMESTAMP", "FROM_UNIXTIME", "TIMESTAMPADD", "TIMESTAMPDIFF", "TIMESTAMP_DIFF", "DATE_FORMAT");
    public static final String DEFAULT_EPOCH_TIME = "__epoch_time__";
    public static final String DEFAULT_TIME_ZONE = "__time_zone__";

    public static String loadSystemFunction(String expression) {
        return "import static org.apache.flink.cdc.runtime.functions.SystemFunctionUtils.*;" + expression;
    }

    public static ExpressionEvaluator compileExpression(String expression, List<String> argumentNames, List<Class<?>> argumentClasses, Class<?> returnClass) {
        ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator();
        expressionEvaluator.setParameters(argumentNames.toArray(new String[0]), argumentClasses.toArray(new Class[0]));
        expressionEvaluator.setExpressionType(returnClass);
        try {
            expressionEvaluator.cook(expression);
            return expressionEvaluator;
        }
        catch (CompileException e) {
            throw new InvalidProgramException("Expression cannot be compiled. This is a bug. Please file an issue.\nExpression: " + expression, (Throwable)e);
        }
    }

    public static String translateSqlNodeToJaninoExpression(SqlNode transform, List<UserDefinedFunctionDescriptor> udfDescriptors, Map<String, String> columnNameMap) {
        Java.Rvalue rvalue = JaninoCompiler.translateSqlNodeToJaninoRvalue(transform, udfDescriptors, columnNameMap);
        if (rvalue != null) {
            return rvalue.toString();
        }
        return "";
    }

    public static Java.Rvalue translateSqlNodeToJaninoRvalue(SqlNode transform, List<UserDefinedFunctionDescriptor> udfDescriptors, Map<String, String> columnNameMap) {
        if (transform instanceof SqlIdentifier) {
            return JaninoCompiler.translateSqlIdentifier((SqlIdentifier)transform, columnNameMap);
        }
        if (transform instanceof SqlBasicCall) {
            return JaninoCompiler.translateSqlBasicCall((SqlBasicCall)transform, udfDescriptors, columnNameMap);
        }
        if (transform instanceof SqlCase) {
            return JaninoCompiler.translateSqlCase((SqlCase)transform, udfDescriptors, columnNameMap);
        }
        if (transform instanceof SqlLiteral) {
            return JaninoCompiler.translateSqlSqlLiteral((SqlLiteral)transform);
        }
        return null;
    }

    private static Java.Rvalue translateSqlIdentifier(SqlIdentifier sqlIdentifier, Map<String, String> columnNameMap) {
        String columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
        if (TIMEZONE_FREE_TEMPORAL_FUNCTIONS.contains(columnName.toUpperCase())) {
            return JaninoCompiler.generateTimezoneFreeTemporalFunctionOperation(columnName);
        }
        if (TIMEZONE_REQUIRED_TEMPORAL_FUNCTIONS.contains(columnName.toUpperCase())) {
            return JaninoCompiler.generateTimezoneRequiredTemporalFunctionOperation(columnName);
        }
        if (TIMEZONE_FREE_TEMPORAL_CONVERSION_FUNCTIONS.contains(columnName.toUpperCase())) {
            return JaninoCompiler.generateTimezoneFreeTemporalConversionFunctionOperation(columnName);
        }
        if (TIMEZONE_REQUIRED_TEMPORAL_CONVERSION_FUNCTIONS.contains(columnName.toUpperCase())) {
            return JaninoCompiler.generateTimezoneRequiredTemporalConversionFunctionOperation(columnName);
        }
        return new Java.AmbiguousName(Location.NOWHERE, new String[]{columnNameMap.getOrDefault(columnName, columnName)});
    }

    private static Java.Rvalue translateSqlSqlLiteral(SqlLiteral sqlLiteral) {
        long longValue;
        if (sqlLiteral.getValue() == null) {
            return new Java.NullLiteral(Location.NOWHERE);
        }
        String value = sqlLiteral.getValue().toString();
        if (sqlLiteral instanceof SqlCharStringLiteral) {
            value = "\"" + value.substring(1, value.length() - 1) + "\"";
        } else if (sqlLiteral instanceof SqlNumericLiteral && ((SqlNumericLiteral)sqlLiteral).isInteger() && ((longValue = sqlLiteral.longValue(true)) > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE)) {
            value = value + "L";
        }
        if (SQL_TYPE_NAME_IGNORE.contains(sqlLiteral.getTypeName())) {
            value = "\"" + value + "\"";
        }
        return new Java.AmbiguousName(Location.NOWHERE, new String[]{value});
    }

    private static Java.Rvalue translateSqlBasicCall(SqlBasicCall sqlBasicCall, List<UserDefinedFunctionDescriptor> udfDescriptors, Map<String, String> columnNameMap) {
        List operandList = sqlBasicCall.getOperandList();
        ArrayList<Java.Rvalue> atoms = new ArrayList<Java.Rvalue>();
        for (SqlNode sqlNode : operandList) {
            JaninoCompiler.translateSqlNodeToAtoms(sqlNode, atoms, udfDescriptors, columnNameMap);
        }
        if (TIMEZONE_FREE_TEMPORAL_FUNCTIONS.contains(sqlBasicCall.getOperator().getName().toUpperCase())) {
            atoms.add((Java.Rvalue)new Java.AmbiguousName(Location.NOWHERE, new String[]{DEFAULT_EPOCH_TIME}));
        } else if (TIMEZONE_REQUIRED_TEMPORAL_FUNCTIONS.contains(sqlBasicCall.getOperator().getName().toUpperCase())) {
            atoms.add((Java.Rvalue)new Java.AmbiguousName(Location.NOWHERE, new String[]{DEFAULT_EPOCH_TIME}));
            atoms.add((Java.Rvalue)new Java.AmbiguousName(Location.NOWHERE, new String[]{DEFAULT_TIME_ZONE}));
        } else if (TIMEZONE_REQUIRED_TEMPORAL_CONVERSION_FUNCTIONS.contains(sqlBasicCall.getOperator().getName().toUpperCase())) {
            atoms.add((Java.Rvalue)new Java.AmbiguousName(Location.NOWHERE, new String[]{DEFAULT_TIME_ZONE}));
        }
        return JaninoCompiler.sqlBasicCallToJaninoRvalue(sqlBasicCall, atoms.toArray(new Java.Rvalue[0]), udfDescriptors);
    }

    private static Java.Rvalue translateSqlCase(SqlCase sqlCase, List<UserDefinedFunctionDescriptor> udfDescriptors, Map<String, String> columnNameMap) {
        Java.Rvalue elseAtoms;
        SqlNodeList whenOperands = sqlCase.getWhenOperands();
        SqlNodeList thenOperands = sqlCase.getThenOperands();
        SqlNode elseOperand = sqlCase.getElseOperand();
        ArrayList<Java.Rvalue> whenAtoms = new ArrayList<Java.Rvalue>();
        for (Object sqlNode : whenOperands) {
            JaninoCompiler.translateSqlNodeToAtoms((SqlNode)sqlNode, whenAtoms, udfDescriptors, columnNameMap);
        }
        ArrayList<Java.Rvalue> thenAtoms = new ArrayList<Java.Rvalue>();
        for (SqlNode sqlNode : thenOperands) {
            JaninoCompiler.translateSqlNodeToAtoms(sqlNode, thenAtoms, udfDescriptors, columnNameMap);
        }
        Java.Rvalue sqlCaseRvalueTemp = elseAtoms = JaninoCompiler.translateSqlNodeToJaninoRvalue(elseOperand, udfDescriptors, columnNameMap);
        for (int i = whenAtoms.size() - 1; i >= 0; --i) {
            sqlCaseRvalueTemp = new Java.ConditionalExpression(Location.NOWHERE, (Java.Rvalue)whenAtoms.get(i), (Java.Rvalue)thenAtoms.get(i), sqlCaseRvalueTemp);
        }
        return new Java.ParenthesizedExpression(Location.NOWHERE, sqlCaseRvalueTemp);
    }

    private static void translateSqlNodeToAtoms(SqlNode sqlNode, List<Java.Rvalue> atoms, List<UserDefinedFunctionDescriptor> udfDescriptors, Map<String, String> columnNameMap) {
        if (sqlNode instanceof SqlIdentifier) {
            atoms.add(JaninoCompiler.translateSqlIdentifier((SqlIdentifier)sqlNode, columnNameMap));
        } else if (sqlNode instanceof SqlLiteral) {
            atoms.add(JaninoCompiler.translateSqlSqlLiteral((SqlLiteral)sqlNode));
        } else if (sqlNode instanceof SqlBasicCall) {
            atoms.add(JaninoCompiler.translateSqlBasicCall((SqlBasicCall)sqlNode, udfDescriptors, columnNameMap));
        } else if (sqlNode instanceof SqlNodeList) {
            for (SqlNode node : (SqlNodeList)sqlNode) {
                JaninoCompiler.translateSqlNodeToAtoms(node, atoms, udfDescriptors, columnNameMap);
            }
        } else if (sqlNode instanceof SqlCase) {
            atoms.add(JaninoCompiler.translateSqlCase((SqlCase)sqlNode, udfDescriptors, columnNameMap));
        }
    }

    private static Java.Rvalue sqlBasicCallToJaninoRvalue(SqlBasicCall sqlBasicCall, Java.Rvalue[] atoms, List<UserDefinedFunctionDescriptor> udfDescriptors) {
        switch (sqlBasicCall.getKind()) {
            case AND: {
                return JaninoCompiler.generateBinaryOperation(sqlBasicCall, atoms, "&&");
            }
            case OR: {
                return JaninoCompiler.generateBinaryOperation(sqlBasicCall, atoms, "||");
            }
            case NOT: {
                return JaninoCompiler.generateUnaryOperation("!", atoms[0]);
            }
            case EQUALS: {
                return JaninoCompiler.generateEqualsOperation(sqlBasicCall, atoms);
            }
            case NOT_EQUALS: {
                return JaninoCompiler.generateUnaryOperation("!", JaninoCompiler.generateEqualsOperation(sqlBasicCall, atoms));
            }
            case IS_NULL: {
                return JaninoCompiler.generateUnaryOperation("null == ", atoms[0]);
            }
            case IS_NOT_NULL: {
                return JaninoCompiler.generateUnaryOperation("null != ", atoms[0]);
            }
            case IS_FALSE: 
            case IS_NOT_TRUE: {
                return JaninoCompiler.generateUnaryOperation("false == ", atoms[0]);
            }
            case IS_TRUE: 
            case IS_NOT_FALSE: {
                return JaninoCompiler.generateUnaryOperation("true == ", atoms[0]);
            }
            case BETWEEN: 
            case IN: 
            case NOT_IN: 
            case LIKE: 
            case CEIL: 
            case FLOOR: 
            case TRIM: 
            case OTHER_FUNCTION: {
                return JaninoCompiler.generateOtherFunctionOperation(sqlBasicCall, atoms, udfDescriptors);
            }
            case PLUS: {
                return JaninoCompiler.generateBinaryOperation(sqlBasicCall, atoms, "+");
            }
            case MINUS: {
                return JaninoCompiler.generateBinaryOperation(sqlBasicCall, atoms, "-");
            }
            case TIMES: {
                return JaninoCompiler.generateBinaryOperation(sqlBasicCall, atoms, "*");
            }
            case DIVIDE: {
                return JaninoCompiler.generateBinaryOperation(sqlBasicCall, atoms, "/");
            }
            case MOD: {
                return JaninoCompiler.generateBinaryOperation(sqlBasicCall, atoms, "%");
            }
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: {
                return JaninoCompiler.generateCompareOperation(sqlBasicCall, atoms);
            }
            case CAST: {
                return JaninoCompiler.generateCastOperation(sqlBasicCall, atoms);
            }
            case TIMESTAMP_DIFF: {
                return JaninoCompiler.generateTimestampDiffOperation(sqlBasicCall, atoms);
            }
            case TIMESTAMP_ADD: {
                return JaninoCompiler.generateTimestampAddOperation(sqlBasicCall, atoms);
            }
            case OTHER: {
                return JaninoCompiler.generateOtherOperation(sqlBasicCall, atoms);
            }
        }
        throw new ParseException("Unrecognized expression: " + sqlBasicCall.toString());
    }

    private static Java.Rvalue generateUnaryOperation(String operator, Java.Rvalue atom) {
        return new Java.UnaryOperation(Location.NOWHERE, operator, atom);
    }

    private static Java.Rvalue generateBinaryOperation(SqlBasicCall sqlBasicCall, Java.Rvalue[] atoms, String operator) {
        if (atoms.length != 2) {
            throw new ParseException("Unrecognized expression: " + sqlBasicCall.toString());
        }
        return new Java.BinaryOperation(Location.NOWHERE, atoms[0], operator, atoms[1]);
    }

    private static Java.Rvalue generateEqualsOperation(SqlBasicCall sqlBasicCall, Java.Rvalue[] atoms) {
        if (atoms.length != 2) {
            throw new ParseException("Unrecognized expression: " + sqlBasicCall.toString());
        }
        return new Java.MethodInvocation(Location.NOWHERE, null, StringUtils.convertToCamelCase("VALUE_EQUALS"), atoms);
    }

    private static Java.Rvalue generateCastOperation(SqlBasicCall sqlBasicCall, Java.Rvalue[] atoms) {
        if (atoms.length != 1) {
            throw new ParseException("Unrecognized expression: " + sqlBasicCall.toString());
        }
        List operandList = sqlBasicCall.getOperandList();
        SqlDataTypeSpec sqlDataTypeSpec = (SqlDataTypeSpec)operandList.get(1);
        return JaninoCompiler.generateTypeConvertMethod(sqlDataTypeSpec, atoms);
    }

    private static Java.Rvalue generateCompareOperation(SqlBasicCall sqlBasicCall, Java.Rvalue[] atoms) {
        String compareMethodName;
        if (atoms.length != 2) {
            throw new ParseException("Unrecognized expression: " + sqlBasicCall.toString());
        }
        switch (sqlBasicCall.getKind()) {
            case LESS_THAN: {
                compareMethodName = "LESS_THAN";
                break;
            }
            case GREATER_THAN: {
                compareMethodName = "GREATER_THAN";
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                compareMethodName = "LESS_THAN_OR_EQUAL";
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                compareMethodName = "GREATER_THAN_OR_EQUAL";
                break;
            }
            default: {
                throw new ParseException("Unsupported binary relation operator: " + sqlBasicCall.getKind().toString());
            }
        }
        return new Java.MethodInvocation(Location.NOWHERE, null, StringUtils.convertToCamelCase(compareMethodName), atoms);
    }

    private static Java.Rvalue generateTimestampDiffOperation(SqlBasicCall sqlBasicCall, Java.Rvalue[] atoms) {
        String timeIntervalUnit;
        if (atoms.length != 4) {
            throw new ParseException("Unrecognized expression: " + sqlBasicCall.toString());
        }
        switch (timeIntervalUnit = atoms[0].toString().toUpperCase()) {
            case "\"SECOND\"": 
            case "\"MINUTE\"": 
            case "\"HOUR\"": 
            case "\"DAY\"": 
            case "\"MONTH\"": 
            case "\"YEAR\"": {
                break;
            }
            default: {
                throw new ParseException("Unsupported time interval unit in timestamp diff function: " + timeIntervalUnit);
            }
        }
        ArrayList<Object> timestampDiffFunctionParam = new ArrayList<Object>();
        timestampDiffFunctionParam.add(new Java.AmbiguousName(Location.NOWHERE, new String[]{timeIntervalUnit}));
        timestampDiffFunctionParam.add(atoms[1]);
        timestampDiffFunctionParam.add(atoms[2]);
        timestampDiffFunctionParam.add(atoms[3]);
        return new Java.MethodInvocation(Location.NOWHERE, null, StringUtils.convertToCamelCase(sqlBasicCall.getOperator().getName()), timestampDiffFunctionParam.toArray(new Java.Rvalue[0]));
    }

    private static Java.Rvalue generateTimestampAddOperation(SqlBasicCall sqlBasicCall, Java.Rvalue[] atoms) {
        String timeIntervalUnit;
        if (atoms.length != 4) {
            throw new ParseException("Unrecognized expression: " + sqlBasicCall.toString());
        }
        switch (timeIntervalUnit = atoms[0].toString().toUpperCase()) {
            case "\"SECOND\"": 
            case "\"MINUTE\"": 
            case "\"HOUR\"": 
            case "\"DAY\"": 
            case "\"MONTH\"": 
            case "\"YEAR\"": {
                break;
            }
            default: {
                throw new ParseException("Unsupported time interval unit in timestamp add function: " + timeIntervalUnit);
            }
        }
        ArrayList<Object> timestampDiffFunctionParam = new ArrayList<Object>();
        timestampDiffFunctionParam.add(new Java.AmbiguousName(Location.NOWHERE, new String[]{timeIntervalUnit}));
        timestampDiffFunctionParam.add(atoms[1]);
        timestampDiffFunctionParam.add(atoms[2]);
        timestampDiffFunctionParam.add(atoms[3]);
        return new Java.MethodInvocation(Location.NOWHERE, null, StringUtils.convertToCamelCase(sqlBasicCall.getOperator().getName()), timestampDiffFunctionParam.toArray(new Java.Rvalue[0]));
    }

    private static Java.Rvalue generateCharLengthOperation(Java.Rvalue[] atoms) {
        return new Java.MethodInvocation(Location.NOWHERE, null, StringUtils.convertToCamelCase("CHAR_LENGTH"), atoms);
    }

    private static Java.Rvalue generateOtherOperation(SqlBasicCall sqlBasicCall, Java.Rvalue[] atoms) {
        if (sqlBasicCall.getOperator().getName().equals("||")) {
            return new Java.MethodInvocation(Location.NOWHERE, null, StringUtils.convertToCamelCase("CONCAT"), atoms);
        }
        throw new ParseException("Unrecognized expression: " + sqlBasicCall.toString());
    }

    private static Java.Rvalue generateOtherFunctionOperation(SqlBasicCall sqlBasicCall, Java.Rvalue[] atoms, List<UserDefinedFunctionDescriptor> udfDescriptors) {
        String operationName = sqlBasicCall.getOperator().getName().toUpperCase();
        if (operationName.equals("IF")) {
            if (atoms.length == 3) {
                return new Java.ConditionalExpression(Location.NOWHERE, atoms[0], atoms[1], atoms[2]);
            }
            throw new ParseException("Unrecognized expression: " + sqlBasicCall);
        }
        Optional<UserDefinedFunctionDescriptor> udfFunctionOptional = udfDescriptors.stream().filter(e -> e.getName().equalsIgnoreCase(operationName)).findFirst();
        return (Java.Rvalue)udfFunctionOptional.map(udfFunction -> new Java.MethodInvocation(Location.NOWHERE, null, JaninoCompiler.generateInvokeExpression(udfFunction), atoms)).orElseGet(() -> new Java.MethodInvocation(Location.NOWHERE, null, StringUtils.convertToCamelCase(sqlBasicCall.getOperator().getName()), atoms));
    }

    private static Java.Rvalue generateTimezoneFreeTemporalFunctionOperation(String operationName) {
        return new Java.MethodInvocation(Location.NOWHERE, null, StringUtils.convertToCamelCase(operationName), new Java.Rvalue[]{new Java.AmbiguousName(Location.NOWHERE, new String[]{DEFAULT_EPOCH_TIME})});
    }

    private static Java.Rvalue generateTimezoneRequiredTemporalFunctionOperation(String operationName) {
        ArrayList<Java.AmbiguousName> timestampFunctionParam = new ArrayList<Java.AmbiguousName>();
        timestampFunctionParam.add(new Java.AmbiguousName(Location.NOWHERE, new String[]{DEFAULT_EPOCH_TIME}));
        timestampFunctionParam.add(new Java.AmbiguousName(Location.NOWHERE, new String[]{DEFAULT_TIME_ZONE}));
        return new Java.MethodInvocation(Location.NOWHERE, null, StringUtils.convertToCamelCase(operationName), timestampFunctionParam.toArray(new Java.Rvalue[0]));
    }

    private static Java.Rvalue generateTimezoneFreeTemporalConversionFunctionOperation(String operationName) {
        return new Java.MethodInvocation(Location.NOWHERE, null, StringUtils.convertToCamelCase(operationName), new Java.Rvalue[0]);
    }

    private static Java.Rvalue generateTimezoneRequiredTemporalConversionFunctionOperation(String operationName) {
        return new Java.MethodInvocation(Location.NOWHERE, null, StringUtils.convertToCamelCase(operationName), new Java.Rvalue[]{new Java.AmbiguousName(Location.NOWHERE, new String[]{DEFAULT_TIME_ZONE})});
    }

    private static Java.Rvalue generateTypeConvertMethod(SqlDataTypeSpec sqlDataTypeSpec, Java.Rvalue[] atoms) {
        switch (sqlDataTypeSpec.getTypeName().getSimple().toUpperCase()) {
            case "BOOLEAN": {
                return new Java.MethodInvocation(Location.NOWHERE, null, "castToBoolean", atoms);
            }
            case "TINYINT": {
                return new Java.MethodInvocation(Location.NOWHERE, null, "castToByte", atoms);
            }
            case "SMALLINT": {
                return new Java.MethodInvocation(Location.NOWHERE, null, "castToShort", atoms);
            }
            case "INTEGER": {
                return new Java.MethodInvocation(Location.NOWHERE, null, "castToInteger", atoms);
            }
            case "BIGINT": {
                return new Java.MethodInvocation(Location.NOWHERE, null, "castToLong", atoms);
            }
            case "FLOAT": {
                return new Java.MethodInvocation(Location.NOWHERE, null, "castToFloat", atoms);
            }
            case "DOUBLE": {
                return new Java.MethodInvocation(Location.NOWHERE, null, "castToDouble", atoms);
            }
            case "DECIMAL": {
                int precision = 10;
                int scale = 0;
                if (sqlDataTypeSpec.getTypeNameSpec() instanceof SqlBasicTypeNameSpec) {
                    SqlBasicTypeNameSpec typeNameSpec = (SqlBasicTypeNameSpec)sqlDataTypeSpec.getTypeNameSpec();
                    if (typeNameSpec.getPrecision() > -1) {
                        precision = typeNameSpec.getPrecision();
                    }
                    if (typeNameSpec.getScale() > -1) {
                        scale = typeNameSpec.getScale();
                    }
                }
                ArrayList<Java.Rvalue> newAtoms = new ArrayList<Java.Rvalue>(Arrays.asList(atoms));
                newAtoms.add((Java.Rvalue)new Java.AmbiguousName(Location.NOWHERE, new String[]{String.valueOf(precision)}));
                newAtoms.add((Java.Rvalue)new Java.AmbiguousName(Location.NOWHERE, new String[]{String.valueOf(scale)}));
                return new Java.MethodInvocation(Location.NOWHERE, null, "castToDecimalData", newAtoms.toArray(new Java.Rvalue[0]));
            }
            case "CHAR": 
            case "VARCHAR": 
            case "STRING": {
                return new Java.MethodInvocation(Location.NOWHERE, null, "castToString", atoms);
            }
            case "TIMESTAMP": {
                ArrayList<Java.Rvalue> timestampAtoms = new ArrayList<Java.Rvalue>(Arrays.asList(atoms));
                timestampAtoms.add((Java.Rvalue)new Java.AmbiguousName(Location.NOWHERE, new String[]{DEFAULT_TIME_ZONE}));
                return new Java.MethodInvocation(Location.NOWHERE, null, "castToTimestamp", timestampAtoms.toArray(new Java.Rvalue[0]));
            }
        }
        throw new ParseException("Unsupported data type cast: " + sqlDataTypeSpec.toString());
    }

    private static String generateInvokeExpression(UserDefinedFunctionDescriptor udfFunction) {
        if (udfFunction.getReturnTypeHint() != null) {
            return String.format("(%s) __instanceOf%s.eval", DataTypeConverter.convertOriginalClass(udfFunction.getReturnTypeHint()).getCanonicalName(), udfFunction.getClassName());
        }
        return String.format("__instanceOf%s.eval", udfFunction.getClassName());
    }
}

