/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.schema.common;

import java.util.concurrent.ThreadFactory;
import org.apache.flink.util.FatalExitExceptionHandler;

public class CoordinatorExecutorThreadFactory
implements ThreadFactory {
    private final String coordinatorThreadName;
    private final ClassLoader cl;
    private final Thread.UncaughtExceptionHandler errorHandler;
    private Thread t;

    public CoordinatorExecutorThreadFactory(String coordinatorThreadName, ClassLoader contextClassLoader) {
        this(coordinatorThreadName, contextClassLoader, (Thread.UncaughtExceptionHandler)FatalExitExceptionHandler.INSTANCE);
    }

    public CoordinatorExecutorThreadFactory(String coordinatorThreadName, ClassLoader contextClassLoader, Thread.UncaughtExceptionHandler errorHandler) {
        this.coordinatorThreadName = coordinatorThreadName;
        this.cl = contextClassLoader;
        this.errorHandler = errorHandler;
    }

    @Override
    public synchronized Thread newThread(Runnable r) {
        if (this.t != null) {
            throw new Error("This indicates that a fatal error has happened and caused the coordinator executor thread to exit. Check the earlier logsto see the root cause of the problem.");
        }
        this.t = new Thread(r, this.coordinatorThreadName);
        this.t.setContextClassLoader(this.cl);
        this.t.setUncaughtExceptionHandler(this.errorHandler);
        return this.t;
    }
}

