/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.schema.coordinator;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Selectors;
import org.apache.flink.cdc.common.sink.MetadataApplier;
import org.apache.flink.cdc.runtime.operators.schema.coordinator.SchemaRegistry;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;

@Internal
public class SchemaRegistryProvider
implements OperatorCoordinator.Provider {
    private static final long serialVersionUID = 1L;
    private final OperatorID operatorID;
    private final String operatorName;
    private final MetadataApplier metadataApplier;
    private final List<Tuple2<String, TableId>> routingRules;

    public SchemaRegistryProvider(OperatorID operatorID, String operatorName, MetadataApplier metadataApplier, List<Tuple2<String, TableId>> routingRules) {
        this.operatorID = operatorID;
        this.operatorName = operatorName;
        this.metadataApplier = metadataApplier;
        this.routingRules = routingRules;
    }

    public OperatorID getOperatorId() {
        return this.operatorID;
    }

    public OperatorCoordinator create(OperatorCoordinator.Context context) throws Exception {
        List<Tuple2<Selectors, TableId>> routes = this.routingRules.stream().map(tuple2 -> {
            String tableInclusions = (String)tuple2.f0;
            TableId replaceBy = (TableId)tuple2.f1;
            Selectors selectors = new Selectors.SelectorsBuilder().includeTables(tableInclusions).build();
            return new Tuple2((Object)selectors, (Object)replaceBy);
        }).collect(Collectors.toList());
        return new SchemaRegistry(this.operatorName, context, this.metadataApplier, routes);
    }
}

