/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.region;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.AbstractGRPCClient;
import org.tikv.common.TiConfiguration;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.log.SlowLog;
import org.tikv.common.log.SlowLogSpan;
import org.tikv.common.region.RegionErrorReceiver;
import org.tikv.common.region.RegionManager;
import org.tikv.common.region.TiRegion;
import org.tikv.common.region.TiStore;
import org.tikv.common.region.TiStoreType;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.ChannelFactory;
import org.tikv.common.util.HistogramUtils;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.kvproto.Metapb;
import org.tikv.kvproto.TikvGrpc;
import org.tikv.kvproto.Tracepb;
import org.tikv.shade.com.google.common.base.Preconditions;
import org.tikv.shade.com.google.common.util.concurrent.ListenableFuture;
import org.tikv.shade.com.google.protobuf.ByteString;
import org.tikv.shade.io.grpc.ManagedChannel;
import org.tikv.shade.io.grpc.Metadata;
import org.tikv.shade.io.grpc.stub.AbstractFutureStub;
import org.tikv.shade.io.grpc.stub.MetadataUtils;
import org.tikv.shade.io.prometheus.client.Histogram;

public abstract class AbstractRegionStoreClient
extends AbstractGRPCClient<TikvGrpc.TikvBlockingStub, TikvGrpc.TikvFutureStub>
implements RegionErrorReceiver {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRegionStoreClient.class);
    public static final Histogram SEEK_LEADER_STORE_DURATION = (Histogram)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("client_java_seek_leader_store_duration")).help("seek leader store duration.")).register();
    public static final Histogram SEEK_PROXY_STORE_DURATION = (Histogram)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("client_java_seek_proxy_store_duration")).help("seek proxy store duration.")).register();
    protected final RegionManager regionManager;
    protected TiRegion region;
    protected TiStore store;

    protected AbstractRegionStoreClient(TiConfiguration conf, TiRegion region, TiStore store, ChannelFactory channelFactory, TikvGrpc.TikvBlockingStub blockingStub, TikvGrpc.TikvFutureStub asyncStub, RegionManager regionManager) {
        super(conf, channelFactory, blockingStub, asyncStub);
        Preconditions.checkNotNull(region, "Region is empty");
        Preconditions.checkNotNull(region.getLeader(), "Leader Peer is null");
        Preconditions.checkArgument(region.getLeader() != null, "Leader Peer is null");
        this.region = region;
        this.regionManager = regionManager;
        this.store = store;
        if (this.store.getProxyStore() != null) {
            this.timeout = conf.getForwardTimeout();
        }
    }

    @Override
    public TiRegion getRegion() {
        return this.region;
    }

    @Override
    protected TikvGrpc.TikvBlockingStub getBlockingStub() {
        return (TikvGrpc.TikvBlockingStub)((TikvGrpc.TikvBlockingStub)this.blockingStub).withDeadlineAfter(this.getTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected TikvGrpc.TikvFutureStub getAsyncStub() {
        return (TikvGrpc.TikvFutureStub)((TikvGrpc.TikvFutureStub)this.asyncStub).withDeadlineAfter(this.getTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws GrpcException {
    }

    @Override
    public boolean onNotLeader(TiRegion newRegion, BackOffer backOffer) {
        if (logger.isDebugEnabled()) {
            logger.debug(this.region + ", new leader = " + newRegion.getLeader().getStoreId());
        }
        if (!this.region.getRegionEpoch().equals(newRegion.getRegionEpoch())) {
            return false;
        }
        if (this.region.getLeader().getStoreId() == newRegion.getLeader().getStoreId()) {
            this.store = null;
        }
        this.region = newRegion;
        this.store = this.regionManager.getStoreById(this.region.getLeader().getStoreId(), backOffer);
        this.updateClientStub();
        return true;
    }

    @Override
    public boolean onStoreUnreachable(BackOffer backOffer) {
        if (!this.store.isValid()) {
            logger.warn(String.format("store [%d] has been invalid", this.store.getId()));
            this.store = this.regionManager.getStoreById(this.store.getId(), backOffer);
            this.updateClientStub();
            return true;
        }
        backOffer.checkTimeout();
        Boolean result = this.seekLeaderStore(backOffer);
        if (result != null) {
            return result;
        }
        if (this.conf.getEnableGrpcForward()) {
            backOffer.checkTimeout();
            return this.seekProxyStore(backOffer);
        }
        return false;
    }

    private Kvrpcpb.Context addTraceId(Kvrpcpb.Context context, SlowLog slowLog) {
        if (slowLog.getThresholdMS() < 0L) {
            return context;
        }
        long traceId = slowLog.getTraceId();
        return Kvrpcpb.Context.newBuilder(context).setTraceContext(Tracepb.TraceContext.newBuilder().setDurationThresholdMs((int)((double)slowLog.getThresholdMS() * this.conf.getRawKVServerSlowLogFactor())).addRemoteParentSpans(Tracepb.RemoteParentSpan.newBuilder().setTraceId(traceId))).build();
    }

    protected Kvrpcpb.Context makeContext(TiStoreType storeType, SlowLog slowLog) {
        Kvrpcpb.Context context = this.region.getReplicaContext(Collections.emptySet(), storeType);
        return this.addTraceId(context, slowLog);
    }

    protected Kvrpcpb.Context makeContext(Set<Long> resolvedLocks, TiStoreType storeType, SlowLog slowLog) {
        Kvrpcpb.Context context = this.region.getReplicaContext(resolvedLocks, storeType);
        return this.addTraceId(context, slowLog);
    }

    private void updateClientStub() {
        String addressStr = this.store.getStore().getAddress();
        long deadline = this.timeout;
        if (this.store.getProxyStore() != null) {
            addressStr = this.store.getProxyStore().getAddress();
            deadline = this.conf.getForwardTimeout();
        }
        ManagedChannel channel = this.channelFactory.getChannel(addressStr, this.regionManager.getPDClient().getHostMapping());
        this.blockingStub = TikvGrpc.newBlockingStub(channel).withDeadlineAfter(deadline, TimeUnit.MILLISECONDS);
        this.asyncStub = (AbstractFutureStub)TikvGrpc.newFutureStub(channel).withDeadlineAfter(deadline, TimeUnit.MILLISECONDS);
        if (this.store.getProxyStore() != null) {
            Metadata header = new Metadata();
            header.put(TiConfiguration.FORWARD_META_DATA_KEY, this.store.getStore().getAddress());
            this.blockingStub = MetadataUtils.attachHeaders(this.blockingStub, header);
            this.asyncStub = MetadataUtils.attachHeaders(this.asyncStub, header);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean seekLeaderStore(BackOffer backOffer) {
        Histogram.Timer switchLeaderDurationTimer = SEEK_LEADER_STORE_DURATION.startTimer();
        SlowLogSpan slowLogSpan = backOffer.getSlowLog().start("seekLeaderStore");
        try {
            List<Metapb.Peer> peers = this.region.getFollowerList();
            if (peers.isEmpty()) {
                logger.warn(String.format("no followers of region[%d] available, retry", this.region.getId()));
                this.regionManager.onRequestFail(this.region);
                Boolean bl = false;
                return bl;
            }
            logger.info(String.format("try switch leader: region[%d]", this.region.getId()));
            Metapb.Peer peer = this.switchLeaderStore(backOffer);
            if (peer != null) {
                TiStore currentLeaderStore = this.regionManager.getStoreById(peer.getStoreId(), backOffer);
                if (currentLeaderStore.isReachable()) {
                    logger.info(String.format("update leader using switchLeader logic from store[%d] to store[%d]", this.region.getLeader().getStoreId(), peer.getStoreId()));
                    TiRegion result = this.regionManager.updateLeader(this.region, peer.getStoreId());
                    if (result != null) {
                        this.region = result;
                        this.store = currentLeaderStore;
                        this.updateClientStub();
                    }
                    Boolean bl = false;
                    return bl;
                }
            } else {
                logger.warn(String.format("leader for region[%d] is not found, it is possible that network partition occurred", this.region.getId()));
            }
        }
        finally {
            switchLeaderDurationTimer.observeDuration();
            slowLogSpan.end();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean seekProxyStore(BackOffer backOffer) {
        SlowLogSpan slowLogSpan = backOffer.getSlowLog().start("seekProxyStore");
        Histogram.Timer grpcForwardDurationTimer = SEEK_PROXY_STORE_DURATION.startTimer();
        try {
            logger.info(String.format("try grpc forward: region[%d]", this.region.getId()));
            TiStore storeWithProxy = this.switchProxyStore(backOffer);
            if (storeWithProxy == null) {
                logger.warn(String.format("No store available, retry: region[%d]", this.region.getId()));
                boolean bl = false;
                return bl;
            }
            this.regionManager.updateStore(this.store, storeWithProxy);
            this.store = storeWithProxy;
            this.updateClientStub();
            boolean bl = true;
            return bl;
        }
        finally {
            grpcForwardDurationTimer.observeDuration();
            slowLogSpan.end();
        }
    }

    private Metapb.Peer switchLeaderStore(BackOffer backOffer) {
        LinkedList<SwitchLeaderTask> responses = new LinkedList<SwitchLeaderTask>();
        for (Metapb.Peer peer : this.region.getFollowerList()) {
            ByteString key = this.region.getStartKey();
            TiStore peerStore = this.regionManager.getStoreById(peer.getStoreId(), backOffer);
            ManagedChannel channel = this.channelFactory.getChannel(peerStore.getAddress(), this.regionManager.getPDClient().getHostMapping());
            TikvGrpc.TikvFutureStub stub = (TikvGrpc.TikvFutureStub)TikvGrpc.newFutureStub(channel).withDeadlineAfter(this.timeout, TimeUnit.MILLISECONDS);
            Kvrpcpb.RawGetRequest rawGetRequest = Kvrpcpb.RawGetRequest.newBuilder().setContext(this.region.getReplicaContext(peer)).setKey(key).build();
            ListenableFuture<Kvrpcpb.RawGetResponse> task = stub.rawGet(rawGetRequest);
            responses.add(new SwitchLeaderTask(task, peer));
        }
        while (true) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                throw new GrpcException(e);
            }
            LinkedList<SwitchLeaderTask> unfinished = new LinkedList<SwitchLeaderTask>();
            for (SwitchLeaderTask task : responses) {
                if (!task.task.isDone()) {
                    unfinished.add(task);
                    continue;
                }
                try {
                    Kvrpcpb.RawGetResponse resp = (Kvrpcpb.RawGetResponse)task.task.get();
                    if (resp == null || resp.hasRegionError()) continue;
                    logger.info(String.format("rawGet response indicates peer[%d] is leader", task.peer.getId()));
                    return task.peer;
                }
                catch (Exception exception) {
                }
            }
            if (unfinished.isEmpty()) {
                return null;
            }
            responses = unfinished;
        }
    }

    private TiStore switchProxyStore(BackOffer backOffer) {
        long forwardTimeout = this.conf.getForwardTimeout();
        LinkedList<ForwardCheckTask> responses = new LinkedList<ForwardCheckTask>();
        for (Metapb.Peer peer : this.region.getFollowerList()) {
            ByteString key = this.region.getStartKey();
            TiStore peerStore = this.regionManager.getStoreById(peer.getStoreId(), backOffer);
            ManagedChannel channel = this.channelFactory.getChannel(peerStore.getAddress(), this.regionManager.getPDClient().getHostMapping());
            TikvGrpc.TikvFutureStub stub = (TikvGrpc.TikvFutureStub)TikvGrpc.newFutureStub(channel).withDeadlineAfter(forwardTimeout, TimeUnit.MILLISECONDS);
            Metadata header = new Metadata();
            header.put(TiConfiguration.FORWARD_META_DATA_KEY, this.store.getStore().getAddress());
            Kvrpcpb.RawGetRequest rawGetRequest = Kvrpcpb.RawGetRequest.newBuilder().setContext(this.region.getReplicaContext(this.region.getLeader())).setKey(key).build();
            ListenableFuture<Kvrpcpb.RawGetResponse> task = MetadataUtils.attachHeaders(stub, header).rawGet(rawGetRequest);
            responses.add(new ForwardCheckTask(task, peerStore.getStore()));
        }
        while (true) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                throw new GrpcException(e);
            }
            LinkedList<ForwardCheckTask> unfinished = new LinkedList<ForwardCheckTask>();
            for (ForwardCheckTask task : responses) {
                if (!task.task.isDone()) {
                    unfinished.add(task);
                    continue;
                }
                try {
                    Kvrpcpb.RawGetResponse resp = (Kvrpcpb.RawGetResponse)task.task.get();
                    logger.info(String.format("rawGetResponse indicates forward from [%s] to [%s]", task.store.getAddress(), this.store.getAddress()));
                    return this.store.withProxy(task.store);
                }
                catch (Exception exception) {
                }
            }
            if (unfinished.isEmpty()) {
                return null;
            }
            responses = unfinished;
        }
    }

    private static class ForwardCheckTask {
        private final ListenableFuture<Kvrpcpb.RawGetResponse> task;
        private final Metapb.Store store;

        private ForwardCheckTask(ListenableFuture<Kvrpcpb.RawGetResponse> task, Metapb.Store store) {
            this.task = task;
            this.store = store;
        }
    }

    private static class SwitchLeaderTask {
        private final ListenableFuture<Kvrpcpb.RawGetResponse> task;
        private final Metapb.Peer peer;

        private SwitchLeaderTask(ListenableFuture<Kvrpcpb.RawGetResponse> task, Metapb.Peer peer) {
            this.task = task;
            this.peer = peer;
        }
    }
}

