/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.operation;

import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.PDClient;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.operation.ErrorHandler;
import org.tikv.common.pd.PDError;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.BackOffer;
import org.tikv.kvproto.Pdpb;
import org.tikv.shade.io.grpc.StatusRuntimeException;

public class PDErrorHandler<RespT>
implements ErrorHandler<RespT> {
    public static final Function<Pdpb.GetRegionResponse, PDError> getRegionResponseErrorExtractor = r -> r.getHeader().hasError() ? PDError.buildFromPdpbError(r.getHeader().getError()) : (r.getRegion().getId() == 0L ? PDError.RegionPeerNotElected.DEFAULT_INSTANCE : null);
    private static final Logger logger = LoggerFactory.getLogger(PDErrorHandler.class);
    private final Function<RespT, PDError> getError;
    private final PDClient client;

    public PDErrorHandler(Function<RespT, PDError> errorExtractor, PDClient client) {
        this.getError = errorExtractor;
        this.client = client;
    }

    @Override
    public boolean handleResponseError(BackOffer backOffer, RespT resp) {
        if (resp == null) {
            String msg = String.format("PD Request Failed with unknown reason", new Object[0]);
            logger.warn(msg);
            return this.handleRequestError(backOffer, new GrpcException(msg));
        }
        PDError error = this.getError.apply(resp);
        if (error != null) {
            switch (error.getErrorType()) {
                case PD_ERROR: {
                    backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoPDRPC, new GrpcException(error.toString()));
                    this.client.updateLeaderOrforwardFollower();
                    return true;
                }
                case REGION_PEER_NOT_ELECTED: {
                    logger.debug(error.getMessage());
                    backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoPDRPC, new GrpcException(error.toString()));
                    return true;
                }
            }
            throw new TiClientInternalException("Unknown error type encountered: " + error);
        }
        return false;
    }

    @Override
    public boolean handleRequestError(BackOffer backOffer, Exception e) {
        if (e instanceof StatusRuntimeException && e.getMessage().contains("invalid store ID")) {
            return false;
        }
        backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoPDRPC, e);
        this.client.updateLeaderOrforwardFollower();
        return true;
    }
}

