/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.codec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.tikv.common.codec.RowDecoderV2;
import org.tikv.common.codec.RowEncoderV2;
import org.tikv.common.codec.RowV2;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.common.row.ObjectRowImpl;
import org.tikv.common.row.Row;

public class TableCodecV2 {
    protected static byte[] encodeRow(List<TiColumnInfo> columnInfos, Object[] values, boolean isPkHandle) {
        RowEncoderV2 encoder = new RowEncoderV2();
        ArrayList<TiColumnInfo> columnInfoList = new ArrayList<TiColumnInfo>();
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (int i = 0; i < columnInfos.size(); ++i) {
            TiColumnInfo col = columnInfos.get(i);
            if (col.isPrimaryKey() && isPkHandle) continue;
            columnInfoList.add(col);
            valueList.add(values[i]);
        }
        return encoder.encode(columnInfoList, valueList);
    }

    protected static Object[] decodeObjects(byte[] value, Long handle, TiTableInfo tableInfo) {
        if (handle == null && tableInfo.isPkHandle()) {
            throw new IllegalArgumentException("when pk is handle, handle cannot be null");
        }
        int colSize = tableInfo.getColumns().size();
        HashMap<Long, Object> decodedDataMap = new HashMap<Long, Object>(colSize);
        RowV2 rowV2 = RowV2.createNew(value);
        for (TiColumnInfo col : tableInfo.getColumns()) {
            if (col.isPrimaryKey() && tableInfo.isPkHandle()) {
                decodedDataMap.put(col.getId(), handle);
                continue;
            }
            RowV2.ColIDSearchResult searchResult = rowV2.findColID(col.getId());
            if (searchResult.isNull || searchResult.notFound) continue;
            assert (searchResult.idx != -1);
            byte[] colData = rowV2.getData(searchResult.idx);
            Object d = RowDecoderV2.decodeCol(colData, col.getType());
            decodedDataMap.put(col.getId(), d);
        }
        Object[] res = new Object[colSize];
        for (int i = 0; i < colSize; ++i) {
            TiColumnInfo col = tableInfo.getColumn(i);
            res[i] = decodedDataMap.get(col.getId());
        }
        return res;
    }

    protected static Row decodeRow(byte[] value, Long handle, TiTableInfo tableInfo) {
        return ObjectRowImpl.create(TableCodecV2.decodeObjects(value, handle, tableInfo));
    }
}

