/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.cdc;

import org.tikv.kvproto.Cdcpb;

class CDCEvent {
    public final long regionId;
    public final CDCEventType eventType;
    public final long resolvedTs;
    public final Cdcpb.Event.Row row;
    public final Throwable error;

    private CDCEvent(long regionId, CDCEventType eventType, long resolvedTs, Cdcpb.Event.Row row, Throwable error) {
        this.regionId = regionId;
        this.eventType = eventType;
        this.resolvedTs = resolvedTs;
        this.row = row;
        this.error = error;
    }

    public static CDCEvent rowEvent(long regionId, Cdcpb.Event.Row row) {
        return new CDCEvent(regionId, CDCEventType.ROW, 0L, row, null);
    }

    public static CDCEvent resolvedTsEvent(long regionId, long resolvedTs) {
        return new CDCEvent(regionId, CDCEventType.RESOLVED_TS, resolvedTs, null, null);
    }

    public static CDCEvent error(long regionId, Throwable error) {
        return new CDCEvent(regionId, CDCEventType.ERROR, 0L, null, error);
    }

    public static CDCEvent error(long regionId, Throwable error, long resolvedTs) {
        return new CDCEvent(regionId, CDCEventType.ERROR, resolvedTs, null, error);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CDCEvent[").append(this.eventType.toString()).append("] {");
        switch (this.eventType) {
            case ERROR: {
                builder.append("error=").append(this.error.getMessage());
                break;
            }
            case RESOLVED_TS: {
                builder.append("resolvedTs=").append(this.resolvedTs);
                break;
            }
            case ROW: {
                builder.append("row=").append(this.row);
            }
        }
        return builder.append("}").toString();
    }

    static enum CDCEventType {
        ROW,
        RESOLVED_TS,
        ERROR;

    }
}

