/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.expression.visitor;

import java.util.Objects;
import org.tikv.common.exception.TiExpressionException;
import org.tikv.common.expression.ComparisonBinaryExpression;
import org.tikv.common.expression.Expression;
import org.tikv.common.expression.LogicalBinaryExpression;
import org.tikv.common.expression.visitor.DefaultVisitor;
import org.tikv.shade.com.google.common.collect.Range;
import org.tikv.shade.com.google.common.collect.RangeSet;
import org.tikv.shade.com.google.common.collect.TreeRangeSet;

public class RangeSetBuilder<C extends Comparable>
extends DefaultVisitor<RangeSet<C>, Void> {
    static void throwOnError(Expression node) {
        String errorFormat = "Unsupported conversion to Range: %s";
        throw new TiExpressionException(String.format("Unsupported conversion to Range: %s", node));
    }

    RangeSet<C> visitComparisonBinaryExpr(ComparisonBinaryExpression node, Void context, C literal, boolean loose) {
        ComparisonBinaryExpression.NormalizedPredicate predicate = node.normalize();
        TreeRangeSet<C> ranges = TreeRangeSet.create();
        if (loose) {
            switch (predicate.getType()) {
                case GREATER_THAN: 
                case GREATER_EQUAL: {
                    ranges.add(Range.atLeast(literal));
                    break;
                }
                case LESS_THAN: 
                case LESS_EQUAL: {
                    ranges.add(Range.atMost(literal));
                    break;
                }
                case EQUAL: {
                    ranges.add(Range.singleton(literal));
                    break;
                }
                case NOT_EQUAL: {
                    ranges.add(Range.all());
                    break;
                }
                default: {
                    RangeSetBuilder.throwOnError(node);
                    break;
                }
            }
        } else {
            switch (predicate.getType()) {
                case GREATER_THAN: {
                    ranges.add(Range.greaterThan(literal));
                    break;
                }
                case GREATER_EQUAL: {
                    ranges.add(Range.atLeast(literal));
                    break;
                }
                case LESS_THAN: {
                    ranges.add(Range.lessThan(literal));
                    break;
                }
                case LESS_EQUAL: {
                    ranges.add(Range.atMost(literal));
                    break;
                }
                case EQUAL: {
                    ranges.add(Range.singleton(literal));
                    break;
                }
                case NOT_EQUAL: {
                    ranges.add(Range.lessThan(literal));
                    ranges.add(Range.greaterThan(literal));
                    break;
                }
                default: {
                    RangeSetBuilder.throwOnError(node);
                }
            }
        }
        return ranges;
    }

    @Override
    protected RangeSet<C> visit(LogicalBinaryExpression node, Void context) {
        RangeSet leftRanges = (RangeSet)node.getLeft().accept(this, context);
        RangeSet rightRanges = (RangeSet)node.getRight().accept(this, context);
        switch (node.getCompType()) {
            case AND: {
                rightRanges.removeAll(leftRanges.complement());
                break;
            }
            case OR: {
                rightRanges.addAll(leftRanges);
                break;
            }
            case XOR: {
                TreeRangeSet intersection = TreeRangeSet.create(rightRanges);
                intersection.removeAll(leftRanges.complement());
                rightRanges.addAll(leftRanges);
                rightRanges.removeAll(intersection);
                break;
            }
            default: {
                RangeSetBuilder.throwOnError(node);
            }
        }
        return rightRanges;
    }

    public RangeSet<C> buildRange(Expression predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return (RangeSet)predicate.accept(this, null);
    }

    @Override
    protected RangeSet<C> process(Expression node, Void context) {
        RangeSetBuilder.throwOnError(node);
        return null;
    }
}

