/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.sqlserver.source.reader.fetch;

import io.debezium.DebeziumException;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDatabaseSchema;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.SqlServerPartition;
import io.debezium.connector.sqlserver.SqlServerStreamingChangeEventSource;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import org.apache.flink.cdc.connectors.base.WatermarkDispatcher;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.split.SourceSplitBase;
import org.apache.flink.cdc.connectors.base.source.meta.split.StreamSplit;
import org.apache.flink.cdc.connectors.base.source.meta.wartermark.WatermarkKind;
import org.apache.flink.cdc.connectors.base.source.reader.external.FetchTask;
import org.apache.flink.cdc.connectors.sqlserver.source.offset.LsnOffset;
import org.apache.flink.cdc.connectors.sqlserver.source.reader.fetch.SqlServerScanFetchTask;
import org.apache.flink.cdc.connectors.sqlserver.source.reader.fetch.SqlServerSourceFetchTaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerStreamFetchTask
implements FetchTask<SourceSplitBase> {
    private final StreamSplit split;
    private volatile boolean taskRunning = false;

    public SqlServerStreamFetchTask(StreamSplit split) {
        this.split = split;
    }

    @Override
    public void execute(FetchTask.Context context) throws Exception {
        SqlServerSourceFetchTaskContext sourceFetchContext = (SqlServerSourceFetchTaskContext)context;
        if (this.split.isSnapshotCompleted()) {
            sourceFetchContext.getOffsetContext().preSnapshotCompletion();
        }
        this.taskRunning = true;
        StreamSplitReadTask redoLogSplitReadTask = new StreamSplitReadTask(sourceFetchContext.getDbzConnectorConfig(), sourceFetchContext.getConnection(), sourceFetchContext.getMetaDataConnection(), sourceFetchContext.getEventDispatcher(), sourceFetchContext.getWaterMarkDispatcher(), sourceFetchContext.getErrorHandler(), sourceFetchContext.getDatabaseSchema(), this.split);
        RedoLogSplitChangeEventSourceContext changeEventSourceContext = new RedoLogSplitChangeEventSourceContext();
        redoLogSplitReadTask.execute((ChangeEventSource.ChangeEventSourceContext)changeEventSourceContext, sourceFetchContext.getPartition(), sourceFetchContext.getOffsetContext());
    }

    @Override
    public boolean isRunning() {
        return this.taskRunning;
    }

    @Override
    public StreamSplit getSplit() {
        return this.split;
    }

    @Override
    public void close() {
        this.taskRunning = false;
    }

    private class RedoLogSplitChangeEventSourceContext
    implements ChangeEventSource.ChangeEventSourceContext {
        private RedoLogSplitChangeEventSourceContext() {
        }

        @Override
        public boolean isRunning() {
            return SqlServerStreamFetchTask.this.taskRunning;
        }
    }

    public static class StreamSplitReadTask
    extends SqlServerStreamingChangeEventSource {
        private static final Logger LOG = LoggerFactory.getLogger(StreamSplitReadTask.class);
        private final StreamSplit lsnSplit;
        private final WatermarkDispatcher watermarkDispatcher;
        private final ErrorHandler errorHandler;
        private ChangeEventSource.ChangeEventSourceContext context;

        public StreamSplitReadTask(SqlServerConnectorConfig connectorConfig, SqlServerConnection connection, SqlServerConnection metadataConnection, EventDispatcher<SqlServerPartition, TableId> eventDispatcher, WatermarkDispatcher watermarkDispatcher, ErrorHandler errorHandler, SqlServerDatabaseSchema schema, StreamSplit lsnSplit) {
            super(connectorConfig, connection, metadataConnection, eventDispatcher, errorHandler, Clock.system(), schema);
            this.lsnSplit = lsnSplit;
            this.watermarkDispatcher = watermarkDispatcher;
            this.errorHandler = errorHandler;
        }

        @Override
        public void afterHandleLsn(SqlServerPartition partition, Lsn toLsn) {
            Offset endingOffset;
            LsnOffset currentLsnOffset;
            if (this.isBoundedRead() && (currentLsnOffset = new LsnOffset(null, toLsn, null)).isAtOrAfter(endingOffset = this.lsnSplit.getEndingOffset())) {
                try {
                    this.watermarkDispatcher.dispatchWatermarkEvent(partition.getSourcePartition(), this.lsnSplit, currentLsnOffset, WatermarkKind.END);
                }
                catch (InterruptedException e) {
                    LOG.error("Send signal event error.", (Throwable)e);
                    this.errorHandler.setProducerThrowable(new DebeziumException("Error processing binlog signal event", e));
                }
                ((SqlServerScanFetchTask.SqlServerSnapshotSplitChangeEventSourceContext)this.context).finished();
            }
        }

        private boolean isBoundedRead() {
            return !LsnOffset.NO_STOPPING_OFFSET.equals(this.lsnSplit.getEndingOffset());
        }

        @Override
        public void execute(ChangeEventSource.ChangeEventSourceContext context, SqlServerPartition partition, SqlServerOffsetContext offsetContext) throws InterruptedException {
            this.context = context;
            super.execute(context, partition, offsetContext);
        }
    }
}

