/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.sqlserver.source.offset;

import io.debezium.connector.sqlserver.Lsn;
import java.util.HashMap;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;

public class LsnOffset
extends Offset {
    public static final LsnOffset INITIAL_OFFSET = new LsnOffset(Lsn.valueOf(new byte[]{-128}));
    public static final LsnOffset NO_STOPPING_OFFSET = new LsnOffset(Lsn.valueOf(new byte[]{127}));

    public LsnOffset(Lsn scn, Lsn commitScn, Long eventSerialNo) {
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        if (scn != null && scn.isAvailable()) {
            offsetMap.put("change_lsn", scn.toString());
        }
        if (commitScn != null && commitScn.isAvailable()) {
            offsetMap.put("commit_lsn", commitScn.toString());
        }
        if (eventSerialNo != null) {
            offsetMap.put("event_serial_no", eventSerialNo.toString());
        }
        this.offset = offsetMap;
    }

    public LsnOffset(Lsn changeLsn) {
        this(changeLsn, null, null);
    }

    @Override
    public int compareTo(Offset offset) {
        LsnOffset that = (LsnOffset)offset;
        if (NO_STOPPING_OFFSET.equals(that) && NO_STOPPING_OFFSET.equals(this)) {
            return 0;
        }
        if (NO_STOPPING_OFFSET.equals(this)) {
            return 1;
        }
        if (NO_STOPPING_OFFSET.equals(that)) {
            return -1;
        }
        Lsn lsn = Lsn.valueOf((String)this.offset.get("commit_lsn"));
        Lsn targetLsn = Lsn.valueOf((String)that.offset.get("commit_lsn"));
        if (targetLsn.isAvailable()) {
            if (lsn.isAvailable()) {
                return lsn.compareTo(targetLsn);
            }
            return -1;
        }
        if (lsn.isAvailable()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LsnOffset)) {
            return false;
        }
        LsnOffset that = (LsnOffset)o;
        return this.offset.equals(that.offset);
    }
}

