/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.config;

import java.time.Duration;
import org.apache.flink.cdc.common.annotation.Experimental;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public class MySqlSourceOptions {
    public static final ConfigOption<String> HOSTNAME = ConfigOptions.key((String)"hostname").stringType().noDefaultValue().withDescription("IP address or hostname of the MySQL database server.");
    public static final ConfigOption<Integer> PORT = ConfigOptions.key((String)"port").intType().defaultValue((Object)3306).withDescription("Integer port number of the MySQL database server.");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("Name of the MySQL database to use when connecting to the MySQL database server.");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("Password to use when connecting to the MySQL database server.");
    public static final ConfigOption<String> DATABASE_NAME = ConfigOptions.key((String)"database-name").stringType().noDefaultValue().withDescription("Database name of the MySQL server to monitor.");
    public static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("Table name of the MySQL database to monitor.");
    public static final ConfigOption<String> SERVER_TIME_ZONE = ConfigOptions.key((String)"server-time-zone").stringType().noDefaultValue().withDescription("The session time zone in database server. If not set, then ZoneId.systemDefault() is used to determine the server time zone.");
    public static final ConfigOption<String> SERVER_ID = ConfigOptions.key((String)"server-id").stringType().noDefaultValue().withDescription("A numeric ID or a numeric ID range of this database client, The numeric ID syntax is like '5400', the numeric ID range syntax is like '5400-5408', The numeric ID range syntax is recommended when 'scan.incremental.snapshot.enabled' enabled. Every ID must be unique across all currently-running database processes in the MySQL cluster. This connector joins the MySQL  cluster as another server (with this unique ID) so it can read the binlog. By default, a random number is generated between 5400 and 6400, though we recommend setting an explicit value.");
    public static final ConfigOption<Boolean> SCAN_INCREMENTAL_SNAPSHOT_ENABLED = ConfigOptions.key((String)"scan.incremental.snapshot.enabled").booleanType().defaultValue((Object)true).withDescription("Incremental snapshot is a new mechanism to read snapshot of a table. Compared to the old snapshot mechanism, the incremental snapshot has many advantages, including:\n(1) source can be parallel during snapshot reading, \n(2) source can perform checkpoints in the chunk granularity during snapshot reading, \n(3) source doesn't need to acquire global read lock (FLUSH TABLES WITH READ LOCK) before snapshot reading.\nIf you would like the source run in parallel, each parallel reader should have an unique server id, so the 'server-id' must be a range like '5400-6400', and the range must be larger than the parallelism.");
    public static final ConfigOption<Integer> SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE = ConfigOptions.key((String)"scan.incremental.snapshot.chunk.size").intType().defaultValue((Object)8096).withDescription("The chunk size (number of rows) of table snapshot, captured tables are split into multiple chunks when read the snapshot of table.");
    public static final ConfigOption<Integer> SCAN_SNAPSHOT_FETCH_SIZE = ConfigOptions.key((String)"scan.snapshot.fetch.size").intType().defaultValue((Object)1024).withDescription("The maximum fetch size for per poll when read table snapshot.");
    public static final ConfigOption<Duration> CONNECT_TIMEOUT = ConfigOptions.key((String)"connect.timeout").durationType().defaultValue((Object)Duration.ofSeconds(30L)).withDescription("The maximum time that the connector should wait after trying to connect to the MySQL database server before timing out. This value cannot be less than 250ms.");
    public static final ConfigOption<Integer> CONNECTION_POOL_SIZE = ConfigOptions.key((String)"connection.pool.size").intType().defaultValue((Object)20).withDescription("The connection pool size.");
    public static final ConfigOption<Integer> CONNECT_MAX_RETRIES = ConfigOptions.key((String)"connect.max-retries").intType().defaultValue((Object)3).withDescription("The max retry times that the connector should retry to build MySQL database server connection.");
    public static final ConfigOption<String> SCAN_STARTUP_MODE = ConfigOptions.key((String)"scan.startup.mode").stringType().defaultValue((Object)"initial").withDescription("Optional startup mode for MySQL CDC consumer, valid enumerations are \"initial\", \"earliest-offset\", \"latest-offset\", \"timestamp\"\nor \"specific-offset\"");
    public static final ConfigOption<String> SCAN_STARTUP_SPECIFIC_OFFSET_FILE = ConfigOptions.key((String)"scan.startup.specific-offset.file").stringType().noDefaultValue().withDescription("Optional binlog file name used in case of \"specific-offset\" startup mode");
    public static final ConfigOption<Long> SCAN_STARTUP_SPECIFIC_OFFSET_POS = ConfigOptions.key((String)"scan.startup.specific-offset.pos").longType().noDefaultValue().withDescription("Optional binlog file position used in case of \"specific-offset\" startup mode");
    public static final ConfigOption<String> SCAN_STARTUP_SPECIFIC_OFFSET_GTID_SET = ConfigOptions.key((String)"scan.startup.specific-offset.gtid-set").stringType().noDefaultValue().withDescription("Optional GTID set used in case of \"specific-offset\" startup mode");
    public static final ConfigOption<Long> SCAN_STARTUP_SPECIFIC_OFFSET_SKIP_EVENTS = ConfigOptions.key((String)"scan.startup.specific-offset.skip-events").longType().noDefaultValue().withDescription("Optional number of events to skip after the specific starting offset");
    public static final ConfigOption<Long> SCAN_STARTUP_SPECIFIC_OFFSET_SKIP_ROWS = ConfigOptions.key((String)"scan.startup.specific-offset.skip-rows").longType().noDefaultValue().withDescription("Optional number of rows to skip after the specific offset");
    public static final ConfigOption<Long> SCAN_STARTUP_TIMESTAMP_MILLIS = ConfigOptions.key((String)"scan.startup.timestamp-millis").longType().noDefaultValue().withDescription("Optional timestamp used in case of \"timestamp\" startup mode");
    public static final ConfigOption<Duration> HEARTBEAT_INTERVAL = ConfigOptions.key((String)"heartbeat.interval").durationType().defaultValue((Object)Duration.ofSeconds(30L)).withDescription("Optional interval of sending heartbeat event for tracing the latest available binlog offsets");
    public static final ConfigOption<Boolean> SCAN_READ_CHANGELOG_AS_APPEND_ONLY_ENABLED = ConfigOptions.key((String)"scan.read-changelog-as-append-only.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to convert the changelog data stream to an append-only data stream");
    @Experimental
    public static final ConfigOption<Integer> CHUNK_META_GROUP_SIZE = ConfigOptions.key((String)"chunk-meta.group.size").intType().defaultValue((Object)1000).withDescription("The group size of chunk meta, if the meta size exceeds the group size, the meta will be divided into multiple groups.");
    @Experimental
    public static final ConfigOption<Double> CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND = ConfigOptions.key((String)"chunk-key.even-distribution.factor.upper-bound").doubleType().defaultValue((Object)1000.0).withFallbackKeys(new String[]{"split-key.even-distribution.factor.upper-bound"}).withDescription("The upper bound of chunk key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query MySQL for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
    @Experimental
    public static final ConfigOption<Double> CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND = ConfigOptions.key((String)"chunk-key.even-distribution.factor.lower-bound").doubleType().defaultValue((Object)0.05).withFallbackKeys(new String[]{"split-key.even-distribution.factor.lower-bound"}).withDescription("The lower bound of chunk key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query MySQL for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
    @Experimental
    public static final ConfigOption<Boolean> SCAN_NEWLY_ADDED_TABLE_ENABLED = ConfigOptions.key((String)"scan.newly-added-table.enabled").booleanType().defaultValue((Object)false).withDescription("Whether capture the scan the newly added tables or not, by default is false. This option is only useful when we start the job from a savepoint/checkpoint.");
    @Experimental
    public static final ConfigOption<String> SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN = ConfigOptions.key((String)"scan.incremental.snapshot.chunk.key-column").stringType().noDefaultValue().withDescription("The chunk key of table snapshot, captured tables are split into multiple chunks by a chunk key when read the snapshot of table.By default, the chunk key is the first column of the primary key.");
    @Experimental
    public static final ConfigOption<Boolean> SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED = ConfigOptions.key((String)"scan.incremental.close-idle-reader.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to close idle readers at the end of the snapshot phase. This feature depends on FLIP-147: Support Checkpoints After Tasks Finished. The flink version is required to be greater than or equal to 1.14 when enabling this feature.");
    @Experimental
    public static final ConfigOption<Boolean> SCAN_INCREMENTAL_SNAPSHOT_BACKFILL_SKIP = ConfigOptions.key((String)"scan.incremental.snapshot.backfill.skip").booleanType().defaultValue((Object)false).withDescription("Whether to skip backfill in snapshot reading phase. If backfill is skipped, changes on captured tables during snapshot phase will be consumed later in binlog reading phase instead of being merged into the snapshot. WARNING: Skipping backfill might lead to data inconsistency because some binlog events happened within the snapshot phase might be replayed (only at-least-once semantic is promised). For example updating an already updated value in snapshot, or deleting an already deleted entry in snapshot. These replayed binlog events should be handled specially.");
    @Experimental
    public static final ConfigOption<Boolean> PARSE_ONLINE_SCHEMA_CHANGES = ConfigOptions.key((String)"scan.parse.online.schema.changes.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to parse schema change events generated by gh-ost/pt-osc utilities. Defaults to false.");
    @Experimental
    public static final ConfigOption<Boolean> USE_LEGACY_JSON_FORMAT = ConfigOptions.key((String)"use.legacy.json.format").booleanType().defaultValue((Object)true).withDescription("Whether to use legacy json format. The default value is true, which means there is no whitespace before value and after comma in json format.");
    public static final ConfigOption<Boolean> SCAN_INCREMENTAL_SNAPSHOT_UNBOUNDED_CHUNK_FIRST = ConfigOptions.key((String)"scan.incremental.snapshot.unbounded-chunk-first.enabled").booleanType().defaultValue((Object)true).withDescription("Whether to assign the unbounded chunks first during snapshot reading phase. This might help reduce the risk of the TaskManager experiencing an out-of-memory (OOM) error when taking a snapshot of the largest unbounded chunk.");
}

