/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.utils;

public class VersionComparable
implements Comparable<VersionComparable> {
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;
    private String versionString;

    private VersionComparable(String versionString) {
        this.versionString = versionString;
        try {
            int pos = versionString.indexOf(45);
            String numberPart = versionString;
            if (pos > 0) {
                numberPart = versionString.substring(0, pos);
            }
            String[] versions = numberPart.split("\\.");
            this.majorVersion = Integer.parseInt(versions[0]);
            this.minorVersion = Integer.parseInt(versions[1]);
            if (versions.length == 3) {
                this.patchVersion = Integer.parseInt(versions[2]);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Can not recognize version %s.", versionString));
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getPatchVersion() {
        return this.patchVersion;
    }

    public static VersionComparable fromVersionString(String versionString) {
        return new VersionComparable(versionString);
    }

    @Override
    public int compareTo(VersionComparable version) {
        if (this.equalTo(version)) {
            return 0;
        }
        if (this.newerThan(version)) {
            return 1;
        }
        return -1;
    }

    public boolean equalTo(VersionComparable version) {
        return this.majorVersion == version.majorVersion && this.minorVersion == version.minorVersion && this.patchVersion == version.patchVersion;
    }

    public boolean newerThan(VersionComparable version) {
        if (this.majorVersion <= version.majorVersion) {
            if (this.majorVersion < version.majorVersion) {
                return false;
            }
            if (this.minorVersion <= version.minorVersion) {
                if (this.minorVersion < version.patchVersion) {
                    return false;
                }
                return this.patchVersion > version.patchVersion;
            }
        }
        return true;
    }

    public boolean newerThanOrEqualTo(VersionComparable version) {
        return this.newerThan(version) || this.equalTo(version);
    }

    public String toString() {
        return this.versionString;
    }
}

