/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.source.utils;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.base.utils.SourceRecordUtils;
import org.apache.flink.table.api.ValidationException;

public class JdbcChunkUtils {
    public static Object[] queryMinMax(JdbcConnection jdbc, String quotedTableName, String quotedColumnName) throws SQLException {
        String minMaxQuery = String.format("SELECT MIN(%s), MAX(%s) FROM %s", quotedColumnName, quotedColumnName, quotedTableName);
        return jdbc.queryAndMap(minMaxQuery, rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", minMaxQuery));
            }
            return SourceRecordUtils.rowToArray(rs, 2);
        });
    }

    public static Object queryMin(JdbcConnection jdbc, String quotedTableName, String quotedColumnName, Object excludedLowerBound) throws SQLException {
        String minQuery = String.format("SELECT MIN(%s) FROM %s WHERE %s > ?", quotedColumnName, quotedTableName, quotedColumnName);
        return jdbc.prepareQueryAndMap(minQuery, ps -> ps.setObject(1, excludedLowerBound), rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", minQuery));
            }
            return rs.getObject(1);
        });
    }

    public static Column getSplitColumn(Table table, @Nullable String chunkKeyColumn) {
        List<Column> primaryKeys = table.primaryKeyColumns();
        if (primaryKeys.isEmpty()) {
            throw new ValidationException(String.format("Incremental snapshot for tables requires primary key, but table %s doesn't have primary key.", table.id()));
        }
        if (chunkKeyColumn != null) {
            Optional<Column> targetPkColumn = primaryKeys.stream().filter(col -> chunkKeyColumn.equals(col.name())).findFirst();
            if (targetPkColumn.isPresent()) {
                return targetPkColumn.get();
            }
            throw new ValidationException(String.format("Chunk key column '%s' doesn't exist in the primary key [%s] of the table %s.", chunkKeyColumn, primaryKeys.stream().map(Column::name).collect(Collectors.joining(",")), table.id()));
        }
        return primaryKeys.get(0);
    }
}

