/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util;

import com.mongodb.lang.Nullable;

public final class Assertions {
    @Nullable
    public static <T> T assertNull(@Nullable T value) throws AssertionError {
        if (value != null) {
            throw new AssertionError((Object)value.toString());
        }
        return null;
    }

    public static <T> T assertNotNull(@Nullable T value) throws AssertionError {
        if (value == null) {
            throw new AssertionError();
        }
        return value;
    }

    public static boolean assertTrue(boolean value) throws AssertionError {
        if (!value) {
            throw new AssertionError();
        }
        return true;
    }

    public static boolean assertFalse(boolean value) throws AssertionError {
        if (value) {
            throw new AssertionError();
        }
        return false;
    }

    public static AssertionError fail() throws AssertionError {
        throw new AssertionError();
    }

    public static AssertionError fail(String msg) throws AssertionError {
        throw new AssertionError((Object)Assertions.assertNotNull(msg));
    }

    private Assertions() {
    }
}

