/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.distributed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.distributed.ConnectProtocol;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.runtime.distributed.IncrementalCooperativeConnectProtocol;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.util.ConnectorTaskId;

public class ExtendedAssignment
extends ConnectProtocol.Assignment {
    private final short version;
    private final Collection<String> revokedConnectorIds;
    private final Collection<ConnectorTaskId> revokedTaskIds;
    private final int delay;
    private static final ExtendedAssignment EMPTY = new ExtendedAssignment(1, 0, null, null, -1L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), 0);

    public ExtendedAssignment(short version, short error, String leader, String leaderUrl, long configOffset, Collection<String> connectorIds, Collection<ConnectorTaskId> taskIds, Collection<String> revokedConnectorIds, Collection<ConnectorTaskId> revokedTaskIds, int delay) {
        super(error, leader, leaderUrl, configOffset, connectorIds, taskIds);
        this.version = version;
        this.revokedConnectorIds = Objects.requireNonNull(revokedConnectorIds, "Revoked connector IDs may be empty but not null");
        this.revokedTaskIds = Objects.requireNonNull(revokedTaskIds, "Revoked task IDs may be empty but not null");
        this.delay = delay;
    }

    public static ExtendedAssignment duplicate(ExtendedAssignment assignment) {
        return new ExtendedAssignment(assignment.version(), assignment.error(), assignment.leader(), assignment.leaderUrl(), assignment.offset(), new LinkedHashSet<String>(assignment.connectors()), new LinkedHashSet<ConnectorTaskId>(assignment.tasks()), new LinkedHashSet<String>(assignment.revokedConnectors()), new LinkedHashSet<ConnectorTaskId>(assignment.revokedTasks()), assignment.delay());
    }

    public short version() {
        return this.version;
    }

    public Collection<String> revokedConnectors() {
        return this.revokedConnectorIds;
    }

    public Collection<ConnectorTaskId> revokedTasks() {
        return this.revokedTaskIds;
    }

    public int delay() {
        return this.delay;
    }

    public static ExtendedAssignment empty() {
        return EMPTY;
    }

    @Override
    public String toString() {
        return "Assignment{error=" + this.error() + ", leader='" + this.leader() + '\'' + ", leaderUrl='" + this.leaderUrl() + '\'' + ", offset=" + this.offset() + ", connectorIds=" + this.connectors() + ", taskIds=" + this.tasks() + ", revokedConnectorIds=" + this.revokedConnectorIds + ", revokedTaskIds=" + this.revokedTaskIds + ", delay=" + this.delay + '}';
    }

    private Map<String, Collection<Integer>> revokedAsMap() {
        if (this.revokedConnectorIds == null && this.revokedTaskIds == null) {
            return null;
        }
        LinkedHashMap<String, Collection<Integer>> taskMap = new LinkedHashMap<String, Collection<Integer>>();
        Optional.ofNullable(this.revokedConnectorIds).orElseGet(Collections::emptyList).stream().distinct().forEachOrdered(connectorId -> {
            Collection connectorTasks = taskMap.computeIfAbsent((String)connectorId, v -> new ArrayList());
            connectorTasks.add(-1);
        });
        Optional.ofNullable(this.revokedTaskIds).orElseGet(Collections::emptyList).forEach(taskId -> {
            String connectorId = taskId.connector();
            Collection connectorTasks = taskMap.computeIfAbsent(connectorId, v -> new ArrayList());
            connectorTasks.add(taskId.task());
        });
        return taskMap;
    }

    public Struct toStruct() {
        Collection<Struct> assigned = ExtendedAssignment.taskAssignments(this.asMap());
        Collection<Struct> revoked = ExtendedAssignment.taskAssignments(this.revokedAsMap());
        return new Struct(IncrementalCooperativeConnectProtocol.ASSIGNMENT_V1).set("error", (Object)this.error()).set("leader", (Object)this.leader()).set("leader-url", (Object)this.leaderUrl()).set("config-offset", (Object)this.offset()).set("assignment", (Object)(assigned != null ? assigned.toArray() : null)).set("revoked", (Object)(revoked != null ? revoked.toArray() : null)).set("delay", (Object)this.delay);
    }

    public static ExtendedAssignment fromStruct(short version, Struct struct) {
        return struct == null ? null : new ExtendedAssignment(version, struct.getShort("error"), struct.getString("leader"), struct.getString("leader-url"), struct.getLong("config-offset"), ExtendedAssignment.extractConnectors(struct, "assignment"), ExtendedAssignment.extractTasks(struct, "assignment"), ExtendedAssignment.extractConnectors(struct, "revoked"), ExtendedAssignment.extractTasks(struct, "revoked"), struct.getInt("delay"));
    }

    private static Collection<Struct> taskAssignments(Map<String, Collection<Integer>> assignments) {
        return assignments == null ? null : (Collection)assignments.entrySet().stream().map(connectorEntry -> {
            Struct taskAssignment = new Struct(IncrementalCooperativeConnectProtocol.CONNECTOR_ASSIGNMENT_V1);
            taskAssignment.set("connector", connectorEntry.getKey());
            taskAssignment.set("tasks", (Object)((Collection)connectorEntry.getValue()).toArray());
            return taskAssignment;
        }).collect(Collectors.toList());
    }

    private static Collection<String> extractConnectors(Struct struct, String key) {
        assert ("revoked".equals(key) || "assignment".equals(key));
        Object[] connectors = struct.getArray(key);
        if (connectors == null) {
            return Collections.emptyList();
        }
        ArrayList<String> connectorIds = new ArrayList<String>();
        for (Object structObj : connectors) {
            Struct assignment = (Struct)structObj;
            String connector = assignment.getString("connector");
            for (Object taskIdObj : assignment.getArray("tasks")) {
                Integer taskId = (Integer)taskIdObj;
                if (taskId != -1) continue;
                connectorIds.add(connector);
            }
        }
        return connectorIds;
    }

    private static Collection<ConnectorTaskId> extractTasks(Struct struct, String key) {
        assert ("revoked".equals(key) || "assignment".equals(key));
        Object[] tasks = struct.getArray(key);
        if (tasks == null) {
            return Collections.emptyList();
        }
        ArrayList<ConnectorTaskId> tasksIds = new ArrayList<ConnectorTaskId>();
        for (Object structObj : tasks) {
            Struct assignment = (Struct)structObj;
            String connector = assignment.getString("connector");
            for (Object taskIdObj : assignment.getArray("tasks")) {
                Integer taskId = (Integer)taskIdObj;
                if (taskId == -1) continue;
                tasksIds.add(new ConnectorTaskId(connector, taskId));
            }
        }
        return tasksIds;
    }
}

