/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util.jmx;

import com.mongodb.kafka.connect.util.jmx.internal.Metric;
import com.mongodb.kafka.connect.util.jmx.internal.MongoMBean;
import java.util.HashMap;
import java.util.Map;

public class SourceTaskStatistics
extends MongoMBean {
    public static final Map<String, String> DESCRIPTIONS = new HashMap<String, String>();
    private final Metric records = this.registerTotal("records");
    private final Metric recordsFiltered = this.registerTotal("records-filtered");
    private final Metric recordsAcknowledged = this.registerTotal("records-acknowledged");
    private final Metric mongodbBytesRead = this.registerTotal("mongodb-bytes-read");
    private final Metric latestMongodbTimeDifferenceSecs = this.registerLatest("latest-mongodb-time-difference-secs");
    private final Metric inTaskPoll = this.registerMs("in-task-poll");
    private final Metric inConnectFramework = this.registerMs("in-connect-framework");
    private final Metric initialCommandsSuccessful = this.registerMs("initial-commands-successful");
    private final Metric getmoreCommandsSuccessful = this.registerMs("getmore-commands-successful");
    private final Metric initialCommandsFailed = this.registerMs("initial-commands-failed");
    private final Metric getmoreCommandsFailed = this.registerMs("getmore-commands-failed");

    public SourceTaskStatistics(String name) {
        super(name);
    }

    public Metric getRecords() {
        return this.records;
    }

    public Metric getRecordsFiltered() {
        return this.recordsFiltered;
    }

    public Metric getRecordsAcknowledged() {
        return this.recordsAcknowledged;
    }

    public Metric getMongodbBytesRead() {
        return this.mongodbBytesRead;
    }

    public Metric getLatestMongodbTimeDifferenceSecs() {
        return this.latestMongodbTimeDifferenceSecs;
    }

    public Metric getInTaskPoll() {
        return this.inTaskPoll;
    }

    public Metric getInConnectFramework() {
        return this.inConnectFramework;
    }

    public Metric getInitialCommandsSuccessful() {
        return this.initialCommandsSuccessful;
    }

    public Metric getGetmoreCommandsSuccessful() {
        return this.getmoreCommandsSuccessful;
    }

    public Metric getInitialCommandsFailed() {
        return this.initialCommandsFailed;
    }

    public Metric getGetmoreCommandsFailed() {
        return this.getmoreCommandsFailed;
    }

    @Override
    protected String getDescription(String name) {
        return DESCRIPTIONS.get(name);
    }

    static {
        DESCRIPTIONS.put("records", "The total number of records a MongoDB source task passed to the Kafka Connect framework.");
        DESCRIPTIONS.put("records-filtered", "The number of records a MongoDB source task passed to the Kafka connect framework that were then filtered by the framework. A filtered record is not written to Kafka.");
        DESCRIPTIONS.put("records-acknowledged", "The total number of records a MongoDB source task passed to the Kafka Connect framework that were then successfully written to Kafka.");
        DESCRIPTIONS.put("mongodb-bytes-read", "The total number of bytes a MongoDB source task read from the MongoDB server.");
        DESCRIPTIONS.put("latest-mongodb-time-difference-secs", "The number of seconds of the most recent time difference recorded between a MongoDB server and the post-batch resume token held by a MongoDB source task. This value is calculated by subtracting the timestamp of the task's post-batch resume token from the operationTime value of the most recent successful MongoDB command executed by the task.");
        DESCRIPTIONS.put("in-task-poll", "The total number of times the Kafka Connect framework executed the poll() method of a MongoDB source task.");
        DESCRIPTIONS.put("in-task-poll-duration-ms", "The total number of milliseconds the Kafka Connect framework spent executing the poll() method of a MongoDB source task.");
        DESCRIPTIONS.put("in-task-poll-duration-over-1-ms", "The total number of MongoDB source task poll() method executions with a duration that exceeded 1ms.");
        DESCRIPTIONS.put("in-task-poll-duration-over-10-ms", "The total number of MongoDB source task poll() method executions with a duration that exceeded 10ms.");
        DESCRIPTIONS.put("in-task-poll-duration-over-100-ms", "The total number of MongoDB source task poll() method executions with a duration that exceeded 100ms.");
        DESCRIPTIONS.put("in-task-poll-duration-over-1000-ms", "The total number of MongoDB source task poll() method executions with a duration that exceeded 1000ms.");
        DESCRIPTIONS.put("in-task-poll-duration-over-10000-ms", "The total number of MongoDB source task poll() method executions with a duration that exceeded 10000ms.");
        DESCRIPTIONS.put("in-connect-framework", "The total number of times code in the Kafka Connect framework executed after the first invocation of the poll() method of the MongoDB source task.");
        DESCRIPTIONS.put("in-connect-framework-duration-ms", "The total number of milliseconds spent executing code in the Kafka Connect framework since the framework first invoked the poll() method of the MongoDB source task. This metric does not count time executing code in the MongoDB sink task towards the total.");
        DESCRIPTIONS.put("in-connect-framework-duration-over-1-ms", "The total number of times code in the Kafka Connect framework executed for a duration that exceeded 1ms.");
        DESCRIPTIONS.put("in-connect-framework-duration-over-10-ms", "The total number of times code in the Kafka Connect framework executed for a duration that exceeded 10ms.");
        DESCRIPTIONS.put("in-connect-framework-duration-over-100-ms", "The total number of times code in the Kafka Connect framework executed for a duration that exceeded 100ms.");
        DESCRIPTIONS.put("in-connect-framework-duration-over-1000-ms", "The total number of times code in the Kafka Connect framework executed for a duration that exceeded 1000ms.");
        DESCRIPTIONS.put("in-connect-framework-duration-over-10000-ms", "The total number of times code in the Kafka Connect framework executed for a duration that exceeded 10000ms.");
        DESCRIPTIONS.put("initial-commands-successful", "The total number of initial commands issued by a MongoDB source task that succeeded. An initial command is a find or aggregate command sent to a MongoDB server that retrieves the first set of documents in a cursor. A getMore command is not an initial command.");
        DESCRIPTIONS.put("initial-commands-successful-duration-ms", "The total number of milliseconds a MongoDB source task spent executing initial commands that succeeded.");
        DESCRIPTIONS.put("initial-commands-successful-duration-over-1-ms", "The total number of successful initial commands issued by a MongoDB source task with a duration that exceeded 1ms.");
        DESCRIPTIONS.put("initial-commands-successful-duration-over-10-ms", "The total number of successful initial commands issued by a MongoDB source task with a duration that exceeded 10ms.");
        DESCRIPTIONS.put("initial-commands-successful-duration-over-100-ms", "The total number of successful initial commands issued by a MongoDB source task with a duration that exceeded 100ms.");
        DESCRIPTIONS.put("initial-commands-successful-duration-over-1000-ms", "The total number of successful initial commands issued by a MongoDB source task with a duration that exceeded 1000ms.");
        DESCRIPTIONS.put("initial-commands-successful-duration-over-10000-ms", "The total number of successful initial commands issued by a MongoDB source task with a duration that exceeded 10000ms.");
        DESCRIPTIONS.put("getmore-commands-successful", "The total number of getMore commands issued by a MongoDB source task that succeeded.");
        DESCRIPTIONS.put("getmore-commands-successful-duration-ms", "The total number of milliseconds a MongoDB source task spent executing getMore commands that succeeded.");
        DESCRIPTIONS.put("getmore-commands-successful-duration-over-1-ms", "The total number of successful getMore commands issued by a MongoDB source task with a duration that exceeded 1ms.");
        DESCRIPTIONS.put("getmore-commands-successful-duration-over-10-ms", "The total number of successful getMore commands issued by a MongoDB source task with a duration that exceeded 10ms.");
        DESCRIPTIONS.put("getmore-commands-successful-duration-over-100-ms", "The total number of successful getMore commands issued by a MongoDB source task with a duration that exceeded 100ms.");
        DESCRIPTIONS.put("getmore-commands-successful-duration-over-1000-ms", "The total number of successful getMore commands issued by a MongoDB source task with a duration that exceeded 1000ms.");
        DESCRIPTIONS.put("getmore-commands-successful-duration-over-10000-ms", "The total number of successful getMore commands issued by a MongoDB source task with a duration that exceeded 10000ms.");
        DESCRIPTIONS.put("initial-commands-failed", "The total number of initial commands issued by a MongoDB source task that failed. An initial command is a find or aggregate command sent to a MongoDB server that retrieves the first set of documents in a cursor. A getMore command is not an initial command.");
        DESCRIPTIONS.put("initial-commands-failed-duration-ms", "The total number of milliseconds a MongoDB source task spent unsuccessfully attempting to issue initial commands to the MongoDB server.");
        DESCRIPTIONS.put("initial-commands-failed-duration-over-1-ms", "The total number of failed initial commands issued by a MongoDB source task with a duration that exceeded 1ms.");
        DESCRIPTIONS.put("initial-commands-failed-duration-over-10-ms", "The total number of failed initial commands issued by a MongoDB source task with a duration that exceeded 10ms.");
        DESCRIPTIONS.put("initial-commands-failed-duration-over-100-ms", "The total number of failed initial commands issued by a MongoDB source task with a duration that exceeded 100ms.");
        DESCRIPTIONS.put("initial-commands-failed-duration-over-1000-ms", "The total number of failed initial commands issued by a MongoDB source task with a duration that exceeded 1000ms.");
        DESCRIPTIONS.put("initial-commands-failed-duration-over-10000-ms", "The total number of failed initial commands issued by a MongoDB source task with a duration that exceeded 10000ms.");
        DESCRIPTIONS.put("getmore-commands-failed", "The total number of getMore commands issued by a MongoDB source task that failed.");
        DESCRIPTIONS.put("getmore-commands-failed-duration-ms", "The total number of milliseconds a MongoDB source task spent unsuccessfully attempting to issue getMore commands to the MongoDB server.");
        DESCRIPTIONS.put("getmore-commands-failed-duration-over-1-ms", "The total number of failed getMore commands issued by a MongoDB source task with a duration that exceeded 1ms.");
        DESCRIPTIONS.put("getmore-commands-failed-duration-over-10-ms", "The total number of failed getMore commands issued by a MongoDB source task with a duration that exceeded 10ms.");
        DESCRIPTIONS.put("getmore-commands-failed-duration-over-100-ms", "The total number of failed getMore commands issued by a MongoDB source task with a duration that exceeded 100ms.");
        DESCRIPTIONS.put("getmore-commands-failed-duration-over-1000-ms", "The total number of failed getMore commands issued by a MongoDB source task with a duration that exceeded 1000ms.");
        DESCRIPTIONS.put("getmore-commands-failed-duration-over-10000-ms", "The total number of failed getMore commands issued by a MongoDB source task with a duration that exceeded 10000ms.");
    }
}

