/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util.config;

import com.mongodb.annotations.Immutable;
import com.mongodb.kafka.connect.util.Assertions;
import com.mongodb.lang.Nullable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ConfigSoftValidator {
    public static void logObsoleteProperties(Set<ObsoletePropertiesSet> obsoleteConfigs, Collection<String> propertyNames, Consumer<String> logger) {
        propertyNames.stream().map(propertyName -> obsoleteConfigs.stream().map(obsolete -> ((ObsoletePropertiesSet)obsolete).msg(propertyName)).filter(Optional::isPresent).map(Optional::get).findFirst()).filter(Optional::isPresent).map(Optional::get).forEach(logger);
    }

    public static void logIncompatibleProperties(Set<IncompatiblePropertiesPair> incompatibleConfigs, Map<String, String> props, Consumer<String> logger) {
        String global = "";
        Map<String, Map<String, String>> topicNameToItsStrippedProps = props.entrySet().stream().collect(Collectors.groupingBy(propNameAndValue -> ConfigSoftValidator.topicNameFromPropertyName((String)propNameAndValue.getKey()), Collectors.toMap(propNameAndValue -> ConfigSoftValidator.strippedPropertyName((String)propNameAndValue.getKey()), Map.Entry::getValue)));
        Map<String, String> globalProps = topicNameToItsStrippedProps.getOrDefault(global, Collections.emptyMap());
        topicNameToItsStrippedProps.remove(global);
        Map<String, Map> topicNameToCombinedStrippedProps = topicNameToItsStrippedProps.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, topicNameAndItsStrippedProps -> ConfigSoftValidator.combineProperties(globalProps, (String)topicNameAndItsStrippedProps.getKey(), (Map)topicNameAndItsStrippedProps.getValue())));
        Map<String, Map.Entry<String, Boolean>> globalPropsWithFalseFlags = ConfigSoftValidator.combineProperties(globalProps, null, null);
        incompatibleConfigs.forEach(incompatiblePair -> {
            ((IncompatiblePropertiesPair)incompatiblePair).logIfPresent(null, globalPropsWithFalseFlags, logger);
            topicNameToCombinedStrippedProps.forEach((topicName, combinedStrippedProps) -> ((IncompatiblePropertiesPair)incompatiblePair).logIfPresent(topicName.equals(global) ? null : topicName, combinedStrippedProps, logger));
        });
    }

    private static Map<String, Map.Entry<String, Boolean>> combineProperties(Map<String, String> globalProps, @Nullable String topicName, @Nullable Map<String, String> topicStrippedProps) {
        Assertions.assertTrue(topicName == null ^ topicStrippedProps != null);
        HashMap<String, Map.Entry<String, Boolean>> combinedStrippedProps = new HashMap<String, Map.Entry<String, Boolean>>();
        globalProps.forEach((propertyName, propertyValue) -> combinedStrippedProps.put((String)propertyName, (Map.Entry<String, Boolean>)new AbstractMap.SimpleImmutableEntry<String, Boolean>((String)propertyValue, false)));
        if (topicStrippedProps != null) {
            topicStrippedProps.forEach((propertyName, propertyValue) -> combinedStrippedProps.put((String)propertyName, (Map.Entry<String, Boolean>)new AbstractMap.SimpleImmutableEntry<String, Boolean>((String)propertyValue, true)));
        }
        return combinedStrippedProps;
    }

    private static String strippedPropertyName(String propertyName) {
        return propertyName.startsWith("topic.override.") ? propertyName.substring(propertyName.indexOf(".", "topic.override.".length() + 1) + 1) : propertyName;
    }

    private static String overriddenPropertyName(String topicName, String strippedPropertyName) {
        return "topic.override." + topicName + "." + strippedPropertyName;
    }

    private static String topicNameFromPropertyName(String propertyName) {
        if (propertyName.startsWith("topic.override.")) {
            int topicNameStartIdx = "topic.override.".length();
            return propertyName.substring(topicNameStartIdx, propertyName.indexOf(".", topicNameStartIdx));
        }
        return "";
    }

    private ConfigSoftValidator() {
    }

    @Immutable
    public static final class IncompatiblePropertiesPair {
        private final String propertyName1;
        private final String defaultPropertyValue1;
        private final String propertyName2;
        private final String defaultPropertyValue2;
        private final String msg;

        private IncompatiblePropertiesPair(String propertyName1, @Nullable String defaultPropertyValue1, String propertyName2, @Nullable String defaultPropertyValue2, @Nullable String msg) {
            this.propertyName1 = propertyName1;
            this.defaultPropertyValue1 = defaultPropertyValue1;
            this.propertyName2 = propertyName2;
            this.defaultPropertyValue2 = defaultPropertyValue2;
            this.msg = msg == null ? "" : " " + msg;
        }

        public static IncompatiblePropertiesPair latterIgnored(String propertyName1, @Nullable String defaultPropertyValue1, String propertyName2, @Nullable String defaultPropertyValue2) {
            return new IncompatiblePropertiesPair(propertyName1, defaultPropertyValue1, propertyName2, defaultPropertyValue2, "The latter is ignored.");
        }

        private void logIfPresent(@Nullable String topicName, Map<String, Map.Entry<String, Boolean>> combinedStrippedProps, Consumer<String> logger) {
            Map.Entry<String, Boolean> property1ValueAndOverridden = combinedStrippedProps.get(this.propertyName1);
            if (property1ValueAndOverridden == null || property1ValueAndOverridden.getKey().equals(this.defaultPropertyValue1)) {
                return;
            }
            Map.Entry<String, Boolean> property2ValueAndOverridden = combinedStrippedProps.get(this.propertyName2);
            if (property2ValueAndOverridden == null || property2ValueAndOverridden.getKey().equals(this.defaultPropertyValue2)) {
                return;
            }
            logger.accept(String.format("Configuration property '%s' is incompatible with '%s'.%s", property1ValueAndOverridden.getValue() != false ? ConfigSoftValidator.overriddenPropertyName(Assertions.assertNotNull(topicName), this.propertyName1) : this.propertyName1, property2ValueAndOverridden.getValue() != false ? ConfigSoftValidator.overriddenPropertyName(Assertions.assertNotNull(topicName), this.propertyName2) : this.propertyName2, this.msg));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IncompatiblePropertiesPair that = (IncompatiblePropertiesPair)o;
            return this.propertyName1.equals(that.propertyName1) && this.propertyName2.equals(that.propertyName2);
        }

        public int hashCode() {
            return this.propertyName1.hashCode() + this.propertyName2.hashCode();
        }

        public String toString() {
            return "IncompatiblePropertiesPair{name1=" + this.propertyName1 + ", name2=" + this.propertyName2 + ", msg=" + this.msg + '}';
        }
    }

    @Immutable
    public static final class ObsoletePropertiesSet {
        private final Set<String> propertyNames;
        private final String msgFormat;

        private ObsoletePropertiesSet(Set<String> propertyNames, String msgFormat) {
            this.propertyNames = Collections.unmodifiableSet(new HashSet<String>(propertyNames));
            this.msgFormat = Assertions.assertNotNull(msgFormat);
        }

        public static ObsoletePropertiesSet deprecated(String propertyName, String newPropertyName, @Nullable String msg) {
            return new ObsoletePropertiesSet(Stream.of(propertyName).collect(Collectors.toSet()), "The configuration property '%s' is deprecated. Use '" + newPropertyName + "' instead." + (msg == null ? "" : " " + msg));
        }

        public static ObsoletePropertiesSet unused(Set<String> propertyNames, @Nullable String msg) {
            return new ObsoletePropertiesSet(propertyNames, "The configuration property '%s' is unused." + (msg == null ? "" : " " + msg));
        }

        private Optional<String> msg(String propertyName) {
            return this.propertyNames.contains(ConfigSoftValidator.strippedPropertyName(propertyName)) ? Optional.of(String.format(this.msgFormat, propertyName)) : Optional.empty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObsoletePropertiesSet that = (ObsoletePropertiesSet)o;
            return this.propertyNames.equals(that.propertyNames);
        }

        public int hashCode() {
            return this.propertyNames.hashCode();
        }

        public String toString() {
            return "ObsoletePropertiesSet{names=" + this.propertyNames + ", msg=" + this.msgFormat + '}';
        }
    }
}

