/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.schema.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.cdc.common.pipeline.SchemaChangeBehavior;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.MetricGroup;

public class SchemaOperatorMetrics {
    public static final String SCHEMA_CHANGE_BEHAVIOR = "schemaChangeBehavior";
    public static final Map<SchemaChangeBehavior, Integer> SCHEMA_CHANGE_BEHAVIOR_INTEGER_MAP = new HashMap<SchemaChangeBehavior, Integer>(){
        {
            this.put(SchemaChangeBehavior.IGNORE, 0);
            this.put(SchemaChangeBehavior.LENIENT, 1);
            this.put(SchemaChangeBehavior.TRY_EVOLVE, 2);
            this.put(SchemaChangeBehavior.EVOLVE, 3);
            this.put(SchemaChangeBehavior.EXCEPTION, 4);
        }
    };
    public static final String NUM_SCHEMA_CHANGE_EVENTS = "numSchemaChangeEvents";
    public static final String NUM_FINISHED_SCHEMA_CHANGE_EVENTS = "numFinishedSchemaChangeEvents";
    public static final String NUM_FAILED_SCHEMA_CHANGE_EVENTS = "numFailedSchemaChangeEvents";
    public static final String NUM_IGNORED_SCHEMA_CHANGE_EVENTS = "numIgnoredSchemaChangeEvents";
    private final Counter numSchemaChangeEventsCounter;
    private final Counter numFinishedSchemaChangeEventsCounter;
    private final Counter numFailedSchemaChangeEventsCounter;
    private final Counter numIgnoredSchemaChangeEventsCounter;

    public SchemaOperatorMetrics(MetricGroup metricGroup, SchemaChangeBehavior behavior) {
        this.numSchemaChangeEventsCounter = metricGroup.counter(NUM_SCHEMA_CHANGE_EVENTS);
        this.numFinishedSchemaChangeEventsCounter = metricGroup.counter(NUM_FINISHED_SCHEMA_CHANGE_EVENTS);
        this.numFailedSchemaChangeEventsCounter = metricGroup.counter(NUM_FAILED_SCHEMA_CHANGE_EVENTS);
        this.numIgnoredSchemaChangeEventsCounter = metricGroup.counter(NUM_IGNORED_SCHEMA_CHANGE_EVENTS);
        metricGroup.gauge(SCHEMA_CHANGE_BEHAVIOR, () -> SCHEMA_CHANGE_BEHAVIOR_INTEGER_MAP.get((Object)behavior));
    }

    public void increaseSchemaChangeEvents(long count) {
        this.numSchemaChangeEventsCounter.inc(count);
    }

    public void increaseFinishedSchemaChangeEvents(long count) {
        this.numFinishedSchemaChangeEventsCounter.inc(count);
    }

    public void increaseFailedSchemaChangeEvents(long count) {
        this.numFailedSchemaChangeEventsCounter.inc(count);
    }

    public void increaseIgnoredSchemaChangeEvents(long count) {
        this.numIgnoredSchemaChangeEventsCounter.inc(count);
    }
}

