/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.schema.coordinator;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.pipeline.SchemaChangeBehavior;
import org.apache.flink.cdc.common.route.RouteRule;
import org.apache.flink.cdc.common.sink.MetadataApplier;
import org.apache.flink.cdc.runtime.operators.schema.coordinator.SchemaRegistry;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.util.FatalExitExceptionHandler;

@Internal
public class SchemaRegistryProvider
implements OperatorCoordinator.Provider {
    private static final long serialVersionUID = 1L;
    private final OperatorID operatorID;
    private final String operatorName;
    private final MetadataApplier metadataApplier;
    private final List<RouteRule> routingRules;
    private final SchemaChangeBehavior schemaChangeBehavior;

    public SchemaRegistryProvider(OperatorID operatorID, String operatorName, MetadataApplier metadataApplier, List<RouteRule> routingRules, SchemaChangeBehavior schemaChangeBehavior) {
        this.operatorID = operatorID;
        this.operatorName = operatorName;
        this.metadataApplier = metadataApplier;
        this.routingRules = routingRules;
        this.schemaChangeBehavior = schemaChangeBehavior;
    }

    public OperatorID getOperatorId() {
        return this.operatorID;
    }

    public OperatorCoordinator create(OperatorCoordinator.Context context) throws Exception {
        CoordinatorExecutorThreadFactory coordinatorThreadFactory = new CoordinatorExecutorThreadFactory("schema-evolution-coordinator", context.getUserCodeClassloader());
        ExecutorService coordinatorExecutor = Executors.newSingleThreadExecutor(coordinatorThreadFactory);
        return new SchemaRegistry(this.operatorName, context, coordinatorExecutor, this.metadataApplier, this.routingRules, this.schemaChangeBehavior);
    }

    public static class CoordinatorExecutorThreadFactory
    implements ThreadFactory {
        private final String coordinatorThreadName;
        private final ClassLoader cl;
        private final Thread.UncaughtExceptionHandler errorHandler;
        private Thread t;

        CoordinatorExecutorThreadFactory(String coordinatorThreadName, ClassLoader contextClassLoader) {
            this(coordinatorThreadName, contextClassLoader, (Thread.UncaughtExceptionHandler)FatalExitExceptionHandler.INSTANCE);
        }

        CoordinatorExecutorThreadFactory(String coordinatorThreadName, ClassLoader contextClassLoader, Thread.UncaughtExceptionHandler errorHandler) {
            this.coordinatorThreadName = coordinatorThreadName;
            this.cl = contextClassLoader;
            this.errorHandler = errorHandler;
        }

        @Override
        public synchronized Thread newThread(Runnable r) {
            if (this.t != null) {
                throw new Error("This indicates that a fatal error has happened and caused the coordinator executor thread to exit. Check the earlier logsto see the root cause of the problem.");
            }
            this.t = new Thread(r, this.coordinatorThreadName);
            this.t.setContextClassLoader(this.cl);
            this.t.setUncaughtExceptionHandler(this.errorHandler);
            return this.t;
        }
    }
}

