/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.Cluster;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.Node;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.PartitionInfo;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPartitionAssignor
implements ConsumerPartitionAssignor {
    private static final Logger log = LoggerFactory.getLogger(AbstractPartitionAssignor.class);
    private static final Node[] NO_NODES = new Node[]{Node.noNode()};
    boolean preferRackAwareLogic;

    public abstract Map<String, List<TopicPartition>> assign(Map<String, Integer> var1, Map<String, ConsumerPartitionAssignor.Subscription> var2);

    public Map<String, List<TopicPartition>> assignPartitions(Map<String, List<PartitionInfo>> partitionsPerTopic, Map<String, ConsumerPartitionAssignor.Subscription> subscriptions) {
        Map<String, Integer> partitionCountPerTopic = partitionsPerTopic.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).size()));
        return this.assign(partitionCountPerTopic, subscriptions);
    }

    @Override
    public ConsumerPartitionAssignor.GroupAssignment assign(Cluster metadata, ConsumerPartitionAssignor.GroupSubscription groupSubscription) {
        Map<String, ConsumerPartitionAssignor.Subscription> subscriptions = groupSubscription.groupSubscription();
        HashSet<String> allSubscribedTopics = new HashSet<String>();
        for (Map.Entry<String, ConsumerPartitionAssignor.Subscription> entry : subscriptions.entrySet()) {
            allSubscribedTopics.addAll(entry.getValue().topics());
        }
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        for (String topic : allSubscribedTopics) {
            List<PartitionInfo> partitions = metadata.partitionsForTopic(topic);
            if (partitions != null && !partitions.isEmpty()) {
                partitions = new ArrayList<PartitionInfo>(partitions);
                partitions.sort(Comparator.comparingInt(PartitionInfo::partition));
                partitionsPerTopic.put(topic, partitions);
                continue;
            }
            log.debug("Skipping assignment for topic {} since no metadata is available", (Object)topic);
        }
        Map<String, List<TopicPartition>> map = this.assignPartitions(partitionsPerTopic, subscriptions);
        HashMap<String, ConsumerPartitionAssignor.Assignment> assignments = new HashMap<String, ConsumerPartitionAssignor.Assignment>();
        for (Map.Entry<String, List<TopicPartition>> assignmentEntry : map.entrySet()) {
            assignments.put(assignmentEntry.getKey(), new ConsumerPartitionAssignor.Assignment(assignmentEntry.getValue()));
        }
        return new ConsumerPartitionAssignor.GroupAssignment(assignments);
    }

    protected static <K, V> void put(Map<K, List<V>> map, K key, V value) {
        List list = map.computeIfAbsent(key, k -> new ArrayList());
        list.add(value);
    }

    protected static List<TopicPartition> partitions(String topic, int numPartitions) {
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>(numPartitions);
        for (int i = 0; i < numPartitions; ++i) {
            partitions.add(new TopicPartition(topic, i));
        }
        return partitions;
    }

    protected static Map<String, List<PartitionInfo>> partitionInfosWithoutRacks(Map<String, Integer> partitionsPerTopic) {
        return partitionsPerTopic.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            String topic = (String)e.getKey();
            int numPartitions = (Integer)e.getValue();
            ArrayList<PartitionInfo> partitionInfos = new ArrayList<PartitionInfo>(numPartitions);
            for (int i = 0; i < numPartitions; ++i) {
                partitionInfos.add(new PartitionInfo(topic, i, Node.noNode(), NO_NODES, NO_NODES));
            }
            return partitionInfos;
        }));
    }

    protected boolean useRackAwareAssignment(Set<String> consumerRacks, Set<String> partitionRacks, Map<TopicPartition, Set<String>> racksPerPartition) {
        if (consumerRacks.isEmpty() || Collections.disjoint(consumerRacks, partitionRacks)) {
            return false;
        }
        if (this.preferRackAwareLogic) {
            return true;
        }
        return !racksPerPartition.values().stream().allMatch(partitionRacks::equals);
    }

    public static class MemberInfo
    implements Comparable<MemberInfo> {
        public final String memberId;
        public final Optional<String> groupInstanceId;
        public final Optional<String> rackId;

        public MemberInfo(String memberId, Optional<String> groupInstanceId, Optional<String> rackId) {
            this.memberId = memberId;
            this.groupInstanceId = groupInstanceId;
            this.rackId = rackId;
        }

        public MemberInfo(String memberId, Optional<String> groupInstanceId) {
            this(memberId, groupInstanceId, Optional.empty());
        }

        @Override
        public int compareTo(MemberInfo otherMemberInfo) {
            if (this.groupInstanceId.isPresent() && otherMemberInfo.groupInstanceId.isPresent()) {
                return this.groupInstanceId.get().compareTo(otherMemberInfo.groupInstanceId.get());
            }
            if (this.groupInstanceId.isPresent()) {
                return -1;
            }
            if (otherMemberInfo.groupInstanceId.isPresent()) {
                return 1;
            }
            return this.memberId.compareTo(otherMemberInfo.memberId);
        }

        public boolean equals(Object o) {
            return o instanceof MemberInfo && this.memberId.equals(((MemberInfo)o).memberId);
        }

        public int hashCode() {
            return this.memberId.hashCode();
        }

        public String toString() {
            return "MemberInfo [member.id: " + this.memberId + ", group.instance.id: " + this.groupInstanceId.orElse("{}") + "]";
        }
    }
}

