/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.util.LinkedHashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.AvroUtils;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistration;
import org.apache.flink.api.java.typeutils.runtime.kryo.Serializers;
import org.apache.flink.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericData;
import org.apache.flink.avro.shaded.org.apache.avro.specific.SpecificRecordBase;
import org.apache.flink.formats.avro.typeutils.AvroSerializer;
import org.apache.flink.formats.avro.typeutils.AvroTypeInfo;

public class AvroKryoSerializerUtils
extends AvroUtils {
    public void addAvroSerializersIfRequired(SerializerConfig reg, Class<?> type) {
        if (SpecificRecordBase.class.isAssignableFrom(type) || GenericData.Record.class.isAssignableFrom(type)) {
            reg.registerTypeWithKryoSerializer(GenericData.Array.class, Serializers.SpecificInstanceCollectionSerializerForArrayList.class);
            reg.addDefaultKryoSerializer(Schema.class, AvroSchemaSerializer.class);
        }
    }

    public void addAvroGenericDataArrayRegistration(LinkedHashMap<String, KryoRegistration> kryoRegistrations) {
        kryoRegistrations.put(GenericData.Array.class.getName(), new KryoRegistration(GenericData.Array.class, new ExecutionConfig.SerializableSerializer((Serializer)new Serializers.SpecificInstanceCollectionSerializerForArrayList())));
    }

    public <T> TypeSerializer<T> createAvroSerializer(Class<T> type) {
        return new AvroSerializer<T>(type);
    }

    public <T> TypeInformation<T> createAvroTypeInfo(Class<T> type) {
        return new AvroTypeInfo<T>(type);
    }

    public static class AvroSchemaSerializer
    extends Serializer<Schema>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void write(Kryo kryo, Output output, Schema object) {
            String schemaAsString = object.toString(false);
            output.writeString(schemaAsString);
        }

        public Schema read(Kryo kryo, Input input, Class<Schema> type) {
            String schemaAsString = input.readString();
            Schema.Parser sParser = new Schema.Parser();
            return sParser.parse(schemaAsString);
        }
    }
}

