/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class OffsetCommitResponse
extends AbstractResponse {
    private final OffsetCommitResponseData data;

    public OffsetCommitResponse(OffsetCommitResponseData data) {
        super(ApiKeys.OFFSET_COMMIT);
        this.data = data;
    }

    public OffsetCommitResponse(int requestThrottleMs, Map<TopicPartition, Errors> responseData) {
        super(ApiKeys.OFFSET_COMMIT);
        HashMap<String, OffsetCommitResponseData.OffsetCommitResponseTopic> responseTopicDataMap = new HashMap<String, OffsetCommitResponseData.OffsetCommitResponseTopic>();
        for (Map.Entry<TopicPartition, Errors> entry : responseData.entrySet()) {
            TopicPartition topicPartition = entry.getKey();
            String topicName = topicPartition.topic();
            OffsetCommitResponseData.OffsetCommitResponseTopic topic = responseTopicDataMap.getOrDefault(topicName, new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(topicName));
            topic.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setErrorCode(entry.getValue().code()).setPartitionIndex(topicPartition.partition()));
            responseTopicDataMap.put(topicName, topic);
        }
        this.data = new OffsetCommitResponseData().setTopics(new ArrayList<OffsetCommitResponseData.OffsetCommitResponseTopic>(responseTopicDataMap.values())).setThrottleTimeMs(requestThrottleMs);
    }

    public OffsetCommitResponse(Map<TopicPartition, Errors> responseData) {
        this(0, responseData);
    }

    @Override
    public OffsetCommitResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.data.topics().stream().flatMap(topicResult -> topicResult.partitions().stream().map(partitionResult -> Errors.forCode(partitionResult.errorCode()))));
    }

    public static OffsetCommitResponse parse(ByteBuffer buffer, short version) {
        return new OffsetCommitResponse(new OffsetCommitResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 4;
    }

    public static class Builder {
        OffsetCommitResponseData data = new OffsetCommitResponseData();
        HashMap<String, OffsetCommitResponseData.OffsetCommitResponseTopic> byTopicName = new HashMap();

        private OffsetCommitResponseData.OffsetCommitResponseTopic getOrCreateTopic(String topicName) {
            OffsetCommitResponseData.OffsetCommitResponseTopic topic = this.byTopicName.get(topicName);
            if (topic == null) {
                topic = new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(topicName);
                this.data.topics().add(topic);
                this.byTopicName.put(topicName, topic);
            }
            return topic;
        }

        public Builder addPartition(String topicName, int partitionIndex, Errors error) {
            OffsetCommitResponseData.OffsetCommitResponseTopic topicResponse = this.getOrCreateTopic(topicName);
            topicResponse.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(partitionIndex).setErrorCode(error.code()));
            return this;
        }

        public <P> Builder addPartitions(String topicName, List<P> partitions, Function<P, Integer> partitionIndex, Errors error) {
            OffsetCommitResponseData.OffsetCommitResponseTopic topicResponse = this.getOrCreateTopic(topicName);
            partitions.forEach(partition -> topicResponse.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex((Integer)partitionIndex.apply(partition)).setErrorCode(error.code())));
            return this;
        }

        public Builder merge(OffsetCommitResponseData newData) {
            if (this.data.topics().isEmpty()) {
                this.data = newData;
            } else {
                newData.topics().forEach(newTopic -> {
                    OffsetCommitResponseData.OffsetCommitResponseTopic existingTopic = this.byTopicName.get(newTopic.name());
                    if (existingTopic == null) {
                        this.data.topics().add((OffsetCommitResponseData.OffsetCommitResponseTopic)newTopic);
                        this.byTopicName.put(newTopic.name(), (OffsetCommitResponseData.OffsetCommitResponseTopic)newTopic);
                    } else {
                        existingTopic.partitions().addAll(newTopic.partitions());
                    }
                });
            }
            return this;
        }

        public OffsetCommitResponse build() {
            return new OffsetCommitResponse(this.data);
        }
    }
}

