/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.admin.internals.ApiRequestScope;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.MetadataRequestData;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.MetadataResponseData;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.MetadataRequest;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.MetadataResponse;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class PartitionLeaderStrategy
implements AdminApiLookupStrategy<TopicPartition> {
    private static final ApiRequestScope SINGLE_REQUEST_SCOPE = new ApiRequestScope(){};
    private final Logger log;

    public PartitionLeaderStrategy(LogContext logContext) {
        this.log = logContext.logger(PartitionLeaderStrategy.class);
    }

    @Override
    public ApiRequestScope lookupScope(TopicPartition key) {
        return SINGLE_REQUEST_SCOPE;
    }

    public MetadataRequest.Builder buildRequest(Set<TopicPartition> partitions) {
        MetadataRequestData request = new MetadataRequestData();
        request.setAllowAutoTopicCreation(false);
        partitions.stream().map(TopicPartition::topic).distinct().forEach(topic -> request.topics().add(new MetadataRequestData.MetadataRequestTopic().setName((String)topic)));
        return new MetadataRequest.Builder(request);
    }

    private void handleTopicError(String topic, Errors topicError, Set<TopicPartition> requestPartitions, Map<TopicPartition, Throwable> failed) {
        switch (topicError) {
            case UNKNOWN_TOPIC_OR_PARTITION: 
            case LEADER_NOT_AVAILABLE: 
            case BROKER_NOT_AVAILABLE: {
                this.log.debug("Metadata request for topic {} returned topic-level error {}. Will retry", (Object)topic, (Object)topicError);
                break;
            }
            case TOPIC_AUTHORIZATION_FAILED: {
                this.log.error("Received authorization failure for topic {} in `Metadata` response", (Object)topic, (Object)topicError.exception());
                this.failAllPartitionsForTopic(topic, requestPartitions, failed, tp -> new TopicAuthorizationException("Failed to fetch metadata for partition " + tp + " due to topic authorization failure", Collections.singleton(topic)));
                break;
            }
            case INVALID_TOPIC_EXCEPTION: {
                this.log.error("Received invalid topic error for topic {} in `Metadata` response", (Object)topic, (Object)topicError.exception());
                this.failAllPartitionsForTopic(topic, requestPartitions, failed, tp -> new InvalidTopicException("Failed to fetch metadata for partition " + tp + " due to invalid topic `" + topic + "`", Collections.singleton(topic)));
                break;
            }
            default: {
                this.log.error("Received unexpected error for topic {} in `Metadata` response", (Object)topic, (Object)topicError.exception());
                this.failAllPartitionsForTopic(topic, requestPartitions, failed, tp -> topicError.exception("Failed to fetch metadata for partition " + tp + " due to unexpected error for topic `" + topic + "`"));
            }
        }
    }

    private void failAllPartitionsForTopic(String topic, Set<TopicPartition> partitions, Map<TopicPartition, Throwable> failed, Function<TopicPartition, Throwable> exceptionGenerator) {
        partitions.stream().filter(tp -> tp.topic().equals(topic)).forEach(tp -> failed.put((TopicPartition)tp, (Throwable)exceptionGenerator.apply((TopicPartition)tp)));
    }

    private void handlePartitionError(TopicPartition topicPartition, Errors partitionError, Map<TopicPartition, Throwable> failed) {
        switch (partitionError) {
            case LEADER_NOT_AVAILABLE: 
            case BROKER_NOT_AVAILABLE: 
            case NOT_LEADER_OR_FOLLOWER: 
            case REPLICA_NOT_AVAILABLE: 
            case KAFKA_STORAGE_ERROR: {
                this.log.debug("Metadata request for partition {} returned partition-level error {}. Will retry", (Object)topicPartition, (Object)partitionError);
                break;
            }
            default: {
                this.log.error("Received unexpected error for partition {} in `Metadata` response", (Object)topicPartition, (Object)partitionError.exception());
                failed.put(topicPartition, partitionError.exception("Unexpected error during metadata lookup for " + topicPartition));
            }
        }
    }

    @Override
    public AdminApiLookupStrategy.LookupResult<TopicPartition> handleResponse(Set<TopicPartition> requestPartitions, AbstractResponse abstractResponse) {
        MetadataResponse response = (MetadataResponse)abstractResponse;
        HashMap<TopicPartition, Throwable> failed = new HashMap<TopicPartition, Throwable>();
        HashMap<TopicPartition, Integer> mapped = new HashMap<TopicPartition, Integer>();
        for (MetadataResponseData.MetadataResponseTopic topicMetadata : response.data().topics()) {
            String topic = topicMetadata.name();
            Errors topicError = Errors.forCode(topicMetadata.errorCode());
            if (topicError != Errors.NONE) {
                this.handleTopicError(topic, topicError, requestPartitions, failed);
                continue;
            }
            for (MetadataResponseData.MetadataResponsePartition partitionMetadata : topicMetadata.partitions()) {
                TopicPartition topicPartition = new TopicPartition(topic, partitionMetadata.partitionIndex());
                Errors partitionError = Errors.forCode(partitionMetadata.errorCode());
                if (!requestPartitions.contains(topicPartition)) continue;
                if (partitionError != Errors.NONE) {
                    this.handlePartitionError(topicPartition, partitionError, failed);
                    continue;
                }
                int leaderId = partitionMetadata.leaderId();
                if (leaderId >= 0) {
                    mapped.put(topicPartition, leaderId);
                    continue;
                }
                this.log.debug("Metadata request for {} returned no error, but the leader is unknown. Will retry", (Object)topicPartition);
            }
        }
        return new AdminApiLookupStrategy.LookupResult<TopicPartition>(failed, mapped);
    }
}

