/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.admin;

import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.admin.TransactionState;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class TransactionDescription {
    private final int coordinatorId;
    private final TransactionState state;
    private final long producerId;
    private final int producerEpoch;
    private final long transactionTimeoutMs;
    private final OptionalLong transactionStartTimeMs;
    private final Set<TopicPartition> topicPartitions;

    public TransactionDescription(int coordinatorId, TransactionState state, long producerId, int producerEpoch, long transactionTimeoutMs, OptionalLong transactionStartTimeMs, Set<TopicPartition> topicPartitions) {
        this.coordinatorId = coordinatorId;
        this.state = state;
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.transactionTimeoutMs = transactionTimeoutMs;
        this.transactionStartTimeMs = transactionStartTimeMs;
        this.topicPartitions = topicPartitions;
    }

    public int coordinatorId() {
        return this.coordinatorId;
    }

    public TransactionState state() {
        return this.state;
    }

    public long producerId() {
        return this.producerId;
    }

    public int producerEpoch() {
        return this.producerEpoch;
    }

    public long transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public OptionalLong transactionStartTimeMs() {
        return this.transactionStartTimeMs;
    }

    public Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionDescription that = (TransactionDescription)o;
        return this.coordinatorId == that.coordinatorId && this.producerId == that.producerId && this.producerEpoch == that.producerEpoch && this.transactionTimeoutMs == that.transactionTimeoutMs && this.state == that.state && Objects.equals(this.transactionStartTimeMs, that.transactionStartTimeMs) && Objects.equals(this.topicPartitions, that.topicPartitions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.coordinatorId, this.state, this.producerId, this.producerEpoch, this.transactionTimeoutMs, this.transactionStartTimeMs, this.topicPartitions});
    }

    public String toString() {
        return "TransactionDescription(coordinatorId=" + this.coordinatorId + ", state=" + (Object)((Object)this.state) + ", producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", transactionTimeoutMs=" + this.transactionTimeoutMs + ", transactionStartTimeMs=" + this.transactionStartTimeMs + ", topicPartitions=" + this.topicPartitions + ')';
    }
}

