/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.record.ControlRecordType;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.record.Record;

public class ControlRecordUtils {
    public static final short LEADER_CHANGE_SCHEMA_HIGHEST_VERSION = new LeaderChangeMessage().highestSupportedVersion();
    public static final short SNAPSHOT_HEADER_HIGHEST_VERSION = new SnapshotHeaderRecord().highestSupportedVersion();
    public static final short SNAPSHOT_FOOTER_HIGHEST_VERSION = new SnapshotFooterRecord().highestSupportedVersion();

    public static LeaderChangeMessage deserializeLeaderChangeMessage(Record record) {
        ControlRecordType recordType = ControlRecordType.parse(record.key());
        if (recordType != ControlRecordType.LEADER_CHANGE) {
            throw new IllegalArgumentException("Expected LEADER_CHANGE control record type(2), but found " + recordType.toString());
        }
        return ControlRecordUtils.deserializeLeaderChangeMessage(record.value().duplicate());
    }

    public static LeaderChangeMessage deserializeLeaderChangeMessage(ByteBuffer data) {
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(data.duplicate());
        return new LeaderChangeMessage(byteBufferAccessor, LEADER_CHANGE_SCHEMA_HIGHEST_VERSION);
    }

    public static SnapshotHeaderRecord deserializedSnapshotHeaderRecord(Record record) {
        ControlRecordType recordType = ControlRecordType.parse(record.key());
        if (recordType != ControlRecordType.SNAPSHOT_HEADER) {
            throw new IllegalArgumentException("Expected SNAPSHOT_HEADER control record type(3), but found " + recordType.toString());
        }
        return ControlRecordUtils.deserializedSnapshotHeaderRecord(record.value().duplicate());
    }

    public static SnapshotHeaderRecord deserializedSnapshotHeaderRecord(ByteBuffer data) {
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(data.duplicate());
        return new SnapshotHeaderRecord(byteBufferAccessor, SNAPSHOT_HEADER_HIGHEST_VERSION);
    }

    public static SnapshotFooterRecord deserializedSnapshotFooterRecord(Record record) {
        ControlRecordType recordType = ControlRecordType.parse(record.key());
        if (recordType != ControlRecordType.SNAPSHOT_FOOTER) {
            throw new IllegalArgumentException("Expected SNAPSHOT_FOOTER control record type(4), but found " + recordType.toString());
        }
        return ControlRecordUtils.deserializedSnapshotFooterRecord(record.value().duplicate());
    }

    public static SnapshotFooterRecord deserializedSnapshotFooterRecord(ByteBuffer data) {
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(data.duplicate());
        return new SnapshotFooterRecord(byteBufferAccessor, SNAPSHOT_FOOTER_HIGHEST_VERSION);
    }
}

