/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.ConsumerProtocolSubscription;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.avro.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.avro.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.avro.shaded.com.fasterxml.jackson.databind.node.BinaryNode;
import org.apache.flink.avro.shaded.com.fasterxml.jackson.databind.node.IntNode;
import org.apache.flink.avro.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.apache.flink.avro.shaded.com.fasterxml.jackson.databind.node.NullNode;
import org.apache.flink.avro.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.avro.shaded.com.fasterxml.jackson.databind.node.TextNode;

public class ConsumerProtocolSubscriptionJsonConverter {
    public static ConsumerProtocolSubscription read(JsonNode _node, short _version) {
        ConsumerProtocolSubscription _object = new ConsumerProtocolSubscription();
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("ConsumerProtocolSubscription: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("ConsumerProtocolSubscription expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
        }
        ArrayList<String> _collection = new ArrayList<String>(_topicsNode.size());
        _object.topics = _collection;
        for (JsonNode _element : _topicsNode) {
            if (!_element.isTextual()) {
                throw new RuntimeException("ConsumerProtocolSubscription element expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _collection.add(_element.asText());
        }
        JsonNode _userDataNode = _node.get("userData");
        if (_userDataNode == null) {
            throw new RuntimeException("ConsumerProtocolSubscription: unable to locate field 'userData', which is mandatory in version " + _version);
        }
        _object.userData = _userDataNode.isNull() ? null : ByteBuffer.wrap(MessageUtil.jsonNodeToBinary(_userDataNode, "ConsumerProtocolSubscription"));
        JsonNode _ownedPartitionsNode = _node.get("ownedPartitions");
        if (_ownedPartitionsNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("ConsumerProtocolSubscription: unable to locate field 'ownedPartitions', which is mandatory in version " + _version);
            }
            _object.ownedPartitions = new ConsumerProtocolSubscription.TopicPartitionCollection(0);
        } else {
            ConsumerProtocolSubscription.TopicPartitionCollection _collection2;
            if (!_ownedPartitionsNode.isArray()) {
                throw new RuntimeException("ConsumerProtocolSubscription expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.ownedPartitions = _collection2 = new ConsumerProtocolSubscription.TopicPartitionCollection(_ownedPartitionsNode.size());
            for (JsonNode _element : _ownedPartitionsNode) {
                _collection2.add(TopicPartitionJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }

    public static JsonNode write(ConsumerProtocolSubscription _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (String _element : _object.topics) {
            _topicsArray.add(new TextNode(_element));
        }
        _node.set("topics", _topicsArray);
        if (_object.userData == null) {
            _node.set("userData", NullNode.instance);
        } else {
            _node.set("userData", new BinaryNode(MessageUtil.byteBufferToArray(_object.userData)));
        }
        if (_version >= 1) {
            ArrayNode _ownedPartitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (ConsumerProtocolSubscription.TopicPartition _element : _object.ownedPartitions) {
                _ownedPartitionsArray.add(TopicPartitionJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("ownedPartitions", _ownedPartitionsArray);
        }
        return _node;
    }

    public static JsonNode write(ConsumerProtocolSubscription _object, short _version) {
        return ConsumerProtocolSubscriptionJsonConverter.write(_object, _version, true);
    }

    public static class TopicPartitionJsonConverter {
        public static ConsumerProtocolSubscription.TopicPartition read(JsonNode _node, short _version) {
            ConsumerProtocolSubscription.TopicPartition _object = new ConsumerProtocolSubscription.TopicPartition();
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicPartition");
            }
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                throw new RuntimeException("TopicPartition: unable to locate field 'topic', which is mandatory in version " + _version);
            }
            if (!_topicNode.isTextual()) {
                throw new RuntimeException("TopicPartition expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.topic = _topicNode.asText();
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("TopicPartition: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("TopicPartition expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(MessageUtil.jsonNodeToInt(_element, "TopicPartition element"));
            }
            return _object;
        }

        public static JsonNode write(ConsumerProtocolSubscription.TopicPartition _object, short _version, boolean _serializeRecords) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TopicPartition");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topic", new TextNode(_object.topic));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.partitions) {
                _partitionsArray.add(new IntNode(_element));
            }
            _node.set("partitions", _partitionsArray);
            return _node;
        }

        public static JsonNode write(ConsumerProtocolSubscription.TopicPartition _object, short _version) {
            return TopicPartitionJsonConverter.write(_object, _version, true);
        }
    }
}

