/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server;

import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.metrics.Counter;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.metrics.CounterSet;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.metrics.MetricsContext;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.metrics.MetricsProvider;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.metrics.Summary;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.metrics.SummarySet;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.metrics.impl.DefaultMetricsProvider;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.metrics.impl.NullMetricsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(ServerMetrics.class);
    public static final ServerMetrics NULL_METRICS = new ServerMetrics(NullMetricsProvider.INSTANCE);
    public static final ServerMetrics DEFAULT_METRICS_FOR_TESTS;
    private static volatile ServerMetrics CURRENT;
    public final Summary FSYNC_TIME;
    public final Summary SNAPSHOT_TIME;
    public final Summary DB_INIT_TIME;
    public final Summary READ_LATENCY;
    public final Summary UPDATE_LATENCY;
    public final Summary PROPAGATION_LATENCY;
    public final Summary FOLLOWER_SYNC_TIME;
    public final Summary OBSERVER_SYNC_TIME;
    public final Summary ELECTION_TIME;
    public final Counter LOOKING_COUNT;
    public final Counter DIFF_COUNT;
    public final Counter SNAP_COUNT;
    public final Counter COMMIT_COUNT;
    public final Counter CONNECTION_REQUEST_COUNT;
    public final Counter REVALIDATE_COUNT;
    public final Counter CONNECTION_DROP_COUNT;
    public final Counter CONNECTION_REVALIDATE_COUNT;
    public final Counter SESSIONLESS_CONNECTIONS_EXPIRED;
    public final Counter STALE_SESSIONS_EXPIRED;
    public final Summary UNAVAILABLE_TIME;
    public final Summary LEADER_UNAVAILABLE_TIME;
    public final Summary CONNECTION_TOKEN_DEFICIT;
    public final Counter CONNECTION_REJECTED;
    public final Summary INFLIGHT_SNAP_COUNT;
    public final Summary INFLIGHT_DIFF_COUNT;
    public final Counter UNRECOVERABLE_ERROR_COUNT;
    public final SummarySet WRITE_PER_NAMESPACE;
    public final SummarySet READ_PER_NAMESPACE;
    public final Counter BYTES_RECEIVED_COUNT;
    public final Summary PREP_PROCESSOR_QUEUE_TIME;
    public final Summary PREP_PROCESSOR_QUEUE_SIZE;
    public final Counter PREP_PROCESSOR_QUEUED;
    public final Counter OUTSTANDING_CHANGES_QUEUED;
    public final Counter OUTSTANDING_CHANGES_REMOVED;
    public final Summary PREP_PROCESS_TIME;
    public final Summary PROPOSAL_PROCESS_TIME;
    public final Summary CLOSE_SESSION_PREP_TIME;
    public final Summary PROPOSAL_LATENCY;
    public final Summary PROPOSAL_ACK_CREATION_LATENCY;
    public final Summary COMMIT_PROPAGATION_LATENCY;
    public final Counter LEARNER_PROPOSAL_RECEIVED_COUNT;
    public final Counter LEARNER_COMMIT_RECEIVED_COUNT;
    public final Summary STARTUP_TXNS_LOADED;
    public final Summary STARTUP_TXNS_LOAD_TIME;
    public final Summary STARTUP_SNAP_LOAD_TIME;
    public final Summary SYNC_PROCESSOR_QUEUE_AND_FLUSH_TIME;
    public final Summary SYNC_PROCESSOR_QUEUE_SIZE;
    public final Counter SYNC_PROCESSOR_QUEUED;
    public final Summary SYNC_PROCESSOR_QUEUE_TIME;
    public final Summary SYNC_PROCESSOR_FLUSH_TIME;
    public final Summary SYNC_PROCESS_TIME;
    public final Summary BATCH_SIZE;
    public final Summary QUORUM_ACK_LATENCY;
    public final SummarySet ACK_LATENCY;
    public final Counter PROPOSAL_COUNT;
    public final Counter QUIT_LEADING_DUE_TO_DISLOYAL_VOTER;
    public final Summary NODE_CREATED_WATCHER;
    public final Summary NODE_DELETED_WATCHER;
    public final Summary NODE_CHANGED_WATCHER;
    public final Summary NODE_CHILDREN_WATCHER;
    public final Counter ADD_DEAD_WATCHER_STALL_TIME;
    public final Counter DEAD_WATCHERS_QUEUED;
    public final Counter DEAD_WATCHERS_CLEARED;
    public final Summary DEAD_WATCHERS_CLEANER_LATENCY;
    public final Counter RESPONSE_PACKET_CACHE_HITS;
    public final Counter RESPONSE_PACKET_CACHE_MISSING;
    public final Counter RESPONSE_PACKET_GET_CHILDREN_CACHE_HITS;
    public final Counter RESPONSE_PACKET_GET_CHILDREN_CACHE_MISSING;
    public final SummarySet LEARNER_HANDLER_QP_SIZE;
    public final SummarySet LEARNER_HANDLER_QP_TIME;
    public final Summary REQUESTS_IN_SESSION_QUEUE;
    public final Summary PENDING_SESSION_QUEUE_SIZE;
    public final Summary READS_AFTER_WRITE_IN_SESSION_QUEUE;
    public final Summary READ_ISSUED_FROM_SESSION_QUEUE;
    public final Summary SESSION_QUEUES_DRAINED;
    public final Summary TIME_WAITING_EMPTY_POOL_IN_COMMIT_PROCESSOR_READ;
    public final Summary WRITE_BATCH_TIME_IN_COMMIT_PROCESSOR;
    public final Summary CONCURRENT_REQUEST_PROCESSING_IN_COMMIT_PROCESSOR;
    public final Summary READS_QUEUED_IN_COMMIT_PROCESSOR;
    public final Summary WRITES_QUEUED_IN_COMMIT_PROCESSOR;
    public final Summary COMMITS_QUEUED_IN_COMMIT_PROCESSOR;
    public final Counter COMMITS_QUEUED;
    public final Summary READS_ISSUED_IN_COMMIT_PROC;
    public final Summary WRITES_ISSUED_IN_COMMIT_PROC;
    public final Counter THROTTLED_OPS;
    public final Summary READ_COMMITPROC_TIME;
    public final Summary WRITE_COMMITPROC_TIME;
    public final Summary LOCAL_WRITE_COMMITTED_TIME;
    public final Summary SERVER_WRITE_COMMITTED_TIME;
    public final Summary COMMIT_PROCESS_TIME;
    public final Summary OM_PROPOSAL_PROCESS_TIME;
    public final Summary OM_COMMIT_PROCESS_TIME;
    public final Summary READ_FINAL_PROC_TIME;
    public final Summary WRITE_FINAL_PROC_TIME;
    public final Counter ENSEMBLE_AUTH_SUCCESS;
    public final Counter ENSEMBLE_AUTH_FAIL;
    public final Counter ENSEMBLE_AUTH_SKIP;
    public final Counter STALE_REQUESTS;
    public final Counter STALE_REQUESTS_DROPPED;
    public final Counter STALE_REPLIES;
    public final Summary REQUEST_THROTTLE_QUEUE_TIME;
    public final Counter REQUEST_THROTTLE_WAIT_COUNT;
    public final Counter LARGE_REQUESTS_REJECTED;
    public final Summary NETTY_QUEUED_BUFFER;
    public final Counter DIGEST_MISMATCHES_COUNT;
    public final Summary LEARNER_REQUEST_PROCESSOR_QUEUE_SIZE;
    public final Counter UNSUCCESSFUL_HANDSHAKE;
    public final Counter INSECURE_ADMIN;
    public final Counter TLS_HANDSHAKE_EXCEEDED;
    public final Counter CNXN_CLOSED_WITHOUT_ZK_SERVER_RUNNING;
    public final Counter SKIP_LEARNER_REQUEST_TO_NEXT_PROCESSOR_COUNT;
    public final Summary SOCKET_CLOSING_TIME;
    public final Counter REQUESTS_NOT_FORWARDED_TO_COMMIT_PROCESSOR;
    public final Counter RESPONSE_BYTES;
    public final Counter WATCH_BYTES;
    public final Summary JVM_PAUSE_TIME;
    public final CounterSet QUOTA_EXCEEDED_ERROR_PER_NAMESPACE;
    private final MetricsProvider metricsProvider;

    public static ServerMetrics getMetrics() {
        return CURRENT;
    }

    public static void metricsProviderInitialized(MetricsProvider metricsProvider) {
        LOG.info("ServerMetrics initialized with provider {}", (Object)metricsProvider);
        CURRENT = new ServerMetrics(metricsProvider);
    }

    private ServerMetrics(MetricsProvider metricsProvider) {
        this.metricsProvider = metricsProvider;
        MetricsContext metricsContext = this.metricsProvider.getRootContext();
        this.FSYNC_TIME = metricsContext.getSummary("fsynctime", MetricsContext.DetailLevel.BASIC);
        this.SNAPSHOT_TIME = metricsContext.getSummary("snapshottime", MetricsContext.DetailLevel.BASIC);
        this.DB_INIT_TIME = metricsContext.getSummary("dbinittime", MetricsContext.DetailLevel.BASIC);
        this.READ_LATENCY = metricsContext.getSummary("readlatency", MetricsContext.DetailLevel.ADVANCED);
        this.UPDATE_LATENCY = metricsContext.getSummary("updatelatency", MetricsContext.DetailLevel.ADVANCED);
        this.PROPAGATION_LATENCY = metricsContext.getSummary("propagation_latency", MetricsContext.DetailLevel.ADVANCED);
        this.FOLLOWER_SYNC_TIME = metricsContext.getSummary("follower_sync_time", MetricsContext.DetailLevel.BASIC);
        this.OBSERVER_SYNC_TIME = metricsContext.getSummary("observer_sync_time", MetricsContext.DetailLevel.BASIC);
        this.ELECTION_TIME = metricsContext.getSummary("election_time", MetricsContext.DetailLevel.BASIC);
        this.LOOKING_COUNT = metricsContext.getCounter("looking_count");
        this.DIFF_COUNT = metricsContext.getCounter("diff_count");
        this.SNAP_COUNT = metricsContext.getCounter("snap_count");
        this.COMMIT_COUNT = metricsContext.getCounter("commit_count");
        this.CONNECTION_REQUEST_COUNT = metricsContext.getCounter("connection_request_count");
        this.CONNECTION_TOKEN_DEFICIT = metricsContext.getSummary("connection_token_deficit", MetricsContext.DetailLevel.BASIC);
        this.CONNECTION_REJECTED = metricsContext.getCounter("connection_rejected");
        this.INFLIGHT_SNAP_COUNT = metricsContext.getSummary("inflight_snap_count", MetricsContext.DetailLevel.BASIC);
        this.INFLIGHT_DIFF_COUNT = metricsContext.getSummary("inflight_diff_count", MetricsContext.DetailLevel.BASIC);
        this.WRITE_PER_NAMESPACE = metricsContext.getSummarySet("write_per_namespace", MetricsContext.DetailLevel.BASIC);
        this.READ_PER_NAMESPACE = metricsContext.getSummarySet("read_per_namespace", MetricsContext.DetailLevel.BASIC);
        this.BYTES_RECEIVED_COUNT = metricsContext.getCounter("bytes_received_count");
        this.UNRECOVERABLE_ERROR_COUNT = metricsContext.getCounter("unrecoverable_error_count");
        this.NODE_CREATED_WATCHER = metricsContext.getSummary("node_created_watch_count", MetricsContext.DetailLevel.BASIC);
        this.NODE_DELETED_WATCHER = metricsContext.getSummary("node_deleted_watch_count", MetricsContext.DetailLevel.BASIC);
        this.NODE_CHANGED_WATCHER = metricsContext.getSummary("node_changed_watch_count", MetricsContext.DetailLevel.BASIC);
        this.NODE_CHILDREN_WATCHER = metricsContext.getSummary("node_children_watch_count", MetricsContext.DetailLevel.BASIC);
        this.ADD_DEAD_WATCHER_STALL_TIME = metricsContext.getCounter("add_dead_watcher_stall_time");
        this.DEAD_WATCHERS_QUEUED = metricsContext.getCounter("dead_watchers_queued");
        this.DEAD_WATCHERS_CLEARED = metricsContext.getCounter("dead_watchers_cleared");
        this.DEAD_WATCHERS_CLEANER_LATENCY = metricsContext.getSummary("dead_watchers_cleaner_latency", MetricsContext.DetailLevel.ADVANCED);
        this.RESPONSE_PACKET_CACHE_HITS = metricsContext.getCounter("response_packet_cache_hits");
        this.RESPONSE_PACKET_CACHE_MISSING = metricsContext.getCounter("response_packet_cache_misses");
        this.RESPONSE_PACKET_GET_CHILDREN_CACHE_HITS = metricsContext.getCounter("response_packet_get_children_cache_hits");
        this.RESPONSE_PACKET_GET_CHILDREN_CACHE_MISSING = metricsContext.getCounter("response_packet_get_children_cache_misses");
        this.ENSEMBLE_AUTH_SUCCESS = metricsContext.getCounter("ensemble_auth_success");
        this.ENSEMBLE_AUTH_FAIL = metricsContext.getCounter("ensemble_auth_fail");
        this.ENSEMBLE_AUTH_SKIP = metricsContext.getCounter("ensemble_auth_skip");
        this.PREP_PROCESSOR_QUEUE_TIME = metricsContext.getSummary("prep_processor_queue_time_ms", MetricsContext.DetailLevel.ADVANCED);
        this.PREP_PROCESSOR_QUEUE_SIZE = metricsContext.getSummary("prep_processor_queue_size", MetricsContext.DetailLevel.BASIC);
        this.PREP_PROCESSOR_QUEUED = metricsContext.getCounter("prep_processor_request_queued");
        this.OUTSTANDING_CHANGES_QUEUED = metricsContext.getCounter("outstanding_changes_queued");
        this.OUTSTANDING_CHANGES_REMOVED = metricsContext.getCounter("outstanding_changes_removed");
        this.PREP_PROCESS_TIME = metricsContext.getSummary("prep_process_time", MetricsContext.DetailLevel.BASIC);
        this.PROPOSAL_PROCESS_TIME = metricsContext.getSummary("proposal_process_time", MetricsContext.DetailLevel.BASIC);
        this.CLOSE_SESSION_PREP_TIME = metricsContext.getSummary("close_session_prep_time", MetricsContext.DetailLevel.ADVANCED);
        this.REVALIDATE_COUNT = metricsContext.getCounter("revalidate_count");
        this.CONNECTION_DROP_COUNT = metricsContext.getCounter("connection_drop_count");
        this.CONNECTION_REVALIDATE_COUNT = metricsContext.getCounter("connection_revalidate_count");
        this.SESSIONLESS_CONNECTIONS_EXPIRED = metricsContext.getCounter("sessionless_connections_expired");
        this.STALE_SESSIONS_EXPIRED = metricsContext.getCounter("stale_sessions_expired");
        this.UNAVAILABLE_TIME = metricsContext.getSummary("unavailable_time", MetricsContext.DetailLevel.BASIC);
        this.LEADER_UNAVAILABLE_TIME = metricsContext.getSummary("leader_unavailable_time", MetricsContext.DetailLevel.BASIC);
        this.REQUESTS_IN_SESSION_QUEUE = metricsContext.getSummary("requests_in_session_queue", MetricsContext.DetailLevel.BASIC);
        this.PENDING_SESSION_QUEUE_SIZE = metricsContext.getSummary("pending_session_queue_size", MetricsContext.DetailLevel.BASIC);
        this.READS_AFTER_WRITE_IN_SESSION_QUEUE = metricsContext.getSummary("reads_after_write_in_session_queue", MetricsContext.DetailLevel.BASIC);
        this.READ_ISSUED_FROM_SESSION_QUEUE = metricsContext.getSummary("reads_issued_from_session_queue", MetricsContext.DetailLevel.BASIC);
        this.SESSION_QUEUES_DRAINED = metricsContext.getSummary("session_queues_drained", MetricsContext.DetailLevel.BASIC);
        this.TIME_WAITING_EMPTY_POOL_IN_COMMIT_PROCESSOR_READ = metricsContext.getSummary("time_waiting_empty_pool_in_commit_processor_read_ms", MetricsContext.DetailLevel.BASIC);
        this.WRITE_BATCH_TIME_IN_COMMIT_PROCESSOR = metricsContext.getSummary("write_batch_time_in_commit_processor", MetricsContext.DetailLevel.BASIC);
        this.CONCURRENT_REQUEST_PROCESSING_IN_COMMIT_PROCESSOR = metricsContext.getSummary("concurrent_request_processing_in_commit_processor", MetricsContext.DetailLevel.BASIC);
        this.READS_QUEUED_IN_COMMIT_PROCESSOR = metricsContext.getSummary("read_commit_proc_req_queued", MetricsContext.DetailLevel.BASIC);
        this.WRITES_QUEUED_IN_COMMIT_PROCESSOR = metricsContext.getSummary("write_commit_proc_req_queued", MetricsContext.DetailLevel.BASIC);
        this.COMMITS_QUEUED_IN_COMMIT_PROCESSOR = metricsContext.getSummary("commit_commit_proc_req_queued", MetricsContext.DetailLevel.BASIC);
        this.COMMITS_QUEUED = metricsContext.getCounter("request_commit_queued");
        this.READS_ISSUED_IN_COMMIT_PROC = metricsContext.getSummary("read_commit_proc_issued", MetricsContext.DetailLevel.BASIC);
        this.WRITES_ISSUED_IN_COMMIT_PROC = metricsContext.getSummary("write_commit_proc_issued", MetricsContext.DetailLevel.BASIC);
        this.THROTTLED_OPS = metricsContext.getCounter("throttled_ops");
        this.READ_COMMITPROC_TIME = metricsContext.getSummary("read_commitproc_time_ms", MetricsContext.DetailLevel.ADVANCED);
        this.WRITE_COMMITPROC_TIME = metricsContext.getSummary("write_commitproc_time_ms", MetricsContext.DetailLevel.ADVANCED);
        this.LOCAL_WRITE_COMMITTED_TIME = metricsContext.getSummary("local_write_committed_time_ms", MetricsContext.DetailLevel.ADVANCED);
        this.SERVER_WRITE_COMMITTED_TIME = metricsContext.getSummary("server_write_committed_time_ms", MetricsContext.DetailLevel.ADVANCED);
        this.COMMIT_PROCESS_TIME = metricsContext.getSummary("commit_process_time", MetricsContext.DetailLevel.BASIC);
        this.OM_PROPOSAL_PROCESS_TIME = metricsContext.getSummary("om_proposal_process_time_ms", MetricsContext.DetailLevel.ADVANCED);
        this.OM_COMMIT_PROCESS_TIME = metricsContext.getSummary("om_commit_process_time_ms", MetricsContext.DetailLevel.ADVANCED);
        this.READ_FINAL_PROC_TIME = metricsContext.getSummary("read_final_proc_time_ms", MetricsContext.DetailLevel.ADVANCED);
        this.WRITE_FINAL_PROC_TIME = metricsContext.getSummary("write_final_proc_time_ms", MetricsContext.DetailLevel.ADVANCED);
        this.PROPOSAL_LATENCY = metricsContext.getSummary("proposal_latency", MetricsContext.DetailLevel.ADVANCED);
        this.PROPOSAL_ACK_CREATION_LATENCY = metricsContext.getSummary("proposal_ack_creation_latency", MetricsContext.DetailLevel.ADVANCED);
        this.COMMIT_PROPAGATION_LATENCY = metricsContext.getSummary("commit_propagation_latency", MetricsContext.DetailLevel.ADVANCED);
        this.LEARNER_PROPOSAL_RECEIVED_COUNT = metricsContext.getCounter("learner_proposal_received_count");
        this.LEARNER_COMMIT_RECEIVED_COUNT = metricsContext.getCounter("learner_commit_received_count");
        this.LEARNER_HANDLER_QP_SIZE = metricsContext.getSummarySet("learner_handler_qp_size", MetricsContext.DetailLevel.BASIC);
        this.LEARNER_HANDLER_QP_TIME = metricsContext.getSummarySet("learner_handler_qp_time_ms", MetricsContext.DetailLevel.ADVANCED);
        this.STARTUP_TXNS_LOADED = metricsContext.getSummary("startup_txns_loaded", MetricsContext.DetailLevel.BASIC);
        this.STARTUP_TXNS_LOAD_TIME = metricsContext.getSummary("startup_txns_load_time", MetricsContext.DetailLevel.BASIC);
        this.STARTUP_SNAP_LOAD_TIME = metricsContext.getSummary("startup_snap_load_time", MetricsContext.DetailLevel.BASIC);
        this.SYNC_PROCESSOR_QUEUE_AND_FLUSH_TIME = metricsContext.getSummary("sync_processor_queue_and_flush_time_ms", MetricsContext.DetailLevel.ADVANCED);
        this.SYNC_PROCESSOR_QUEUE_SIZE = metricsContext.getSummary("sync_processor_queue_size", MetricsContext.DetailLevel.BASIC);
        this.SYNC_PROCESSOR_QUEUED = metricsContext.getCounter("sync_processor_request_queued");
        this.SYNC_PROCESSOR_QUEUE_TIME = metricsContext.getSummary("sync_processor_queue_time_ms", MetricsContext.DetailLevel.ADVANCED);
        this.SYNC_PROCESSOR_FLUSH_TIME = metricsContext.getSummary("sync_processor_queue_flush_time_ms", MetricsContext.DetailLevel.ADVANCED);
        this.SYNC_PROCESS_TIME = metricsContext.getSummary("sync_process_time", MetricsContext.DetailLevel.BASIC);
        this.BATCH_SIZE = metricsContext.getSummary("sync_processor_batch_size", MetricsContext.DetailLevel.BASIC);
        this.QUORUM_ACK_LATENCY = metricsContext.getSummary("quorum_ack_latency", MetricsContext.DetailLevel.ADVANCED);
        this.ACK_LATENCY = metricsContext.getSummarySet("ack_latency", MetricsContext.DetailLevel.ADVANCED);
        this.PROPOSAL_COUNT = metricsContext.getCounter("proposal_count");
        this.QUIT_LEADING_DUE_TO_DISLOYAL_VOTER = metricsContext.getCounter("quit_leading_due_to_disloyal_voter");
        this.STALE_REQUESTS = metricsContext.getCounter("stale_requests");
        this.STALE_REQUESTS_DROPPED = metricsContext.getCounter("stale_requests_dropped");
        this.STALE_REPLIES = metricsContext.getCounter("stale_replies");
        this.REQUEST_THROTTLE_QUEUE_TIME = metricsContext.getSummary("request_throttle_queue_time_ms", MetricsContext.DetailLevel.ADVANCED);
        this.REQUEST_THROTTLE_WAIT_COUNT = metricsContext.getCounter("request_throttle_wait_count");
        this.LARGE_REQUESTS_REJECTED = metricsContext.getCounter("large_requests_rejected");
        this.NETTY_QUEUED_BUFFER = metricsContext.getSummary("netty_queued_buffer_capacity", MetricsContext.DetailLevel.BASIC);
        this.DIGEST_MISMATCHES_COUNT = metricsContext.getCounter("digest_mismatches_count");
        this.LEARNER_REQUEST_PROCESSOR_QUEUE_SIZE = metricsContext.getSummary("learner_request_processor_queue_size", MetricsContext.DetailLevel.BASIC);
        this.UNSUCCESSFUL_HANDSHAKE = metricsContext.getCounter("unsuccessful_handshake");
        this.INSECURE_ADMIN = metricsContext.getCounter("insecure_admin_count");
        this.TLS_HANDSHAKE_EXCEEDED = metricsContext.getCounter("tls_handshake_exceeded");
        this.CNXN_CLOSED_WITHOUT_ZK_SERVER_RUNNING = metricsContext.getCounter("cnxn_closed_without_zk_server_running");
        this.SKIP_LEARNER_REQUEST_TO_NEXT_PROCESSOR_COUNT = metricsContext.getCounter("skip_learner_request_to_next_processor_count");
        this.SOCKET_CLOSING_TIME = metricsContext.getSummary("socket_closing_time", MetricsContext.DetailLevel.BASIC);
        this.REQUESTS_NOT_FORWARDED_TO_COMMIT_PROCESSOR = metricsContext.getCounter("requests_not_forwarded_to_commit_processor");
        this.RESPONSE_BYTES = metricsContext.getCounter("response_bytes");
        this.WATCH_BYTES = metricsContext.getCounter("watch_bytes");
        this.JVM_PAUSE_TIME = metricsContext.getSummary("jvm_pause_time_ms", MetricsContext.DetailLevel.ADVANCED);
        this.QUOTA_EXCEEDED_ERROR_PER_NAMESPACE = metricsContext.getCounterSet("quota_exceeded_error_per_namespace");
    }

    public void resetAll() {
        this.metricsProvider.resetAllValues();
    }

    public MetricsProvider getMetricsProvider() {
        return this.metricsProvider;
    }

    static {
        CURRENT = DEFAULT_METRICS_FOR_TESTS = new ServerMetrics(new DefaultMetricsProvider());
    }
}

