/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.zookeeper3.com.codahale.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.flink.shaded.zookeeper3.com.codahale.metrics.LongAdderAdapter;
import org.apache.flink.shaded.zookeeper3.com.codahale.metrics.LongAdderProxy;

public class EWMA {
    private static final int INTERVAL = 5;
    private static final double SECONDS_PER_MINUTE = 60.0;
    private static final int ONE_MINUTE = 1;
    private static final int FIVE_MINUTES = 5;
    private static final int FIFTEEN_MINUTES = 15;
    private static final double M1_ALPHA = 1.0 - Math.exp(-0.08333333333333333);
    private static final double M5_ALPHA = 1.0 - Math.exp(-0.016666666666666666);
    private static final double M15_ALPHA = 1.0 - Math.exp(-0.005555555555555555);
    private volatile boolean initialized = false;
    private volatile double rate = 0.0;
    private final LongAdderAdapter uncounted = LongAdderProxy.create();
    private final double alpha;
    private final double interval;

    public static EWMA oneMinuteEWMA() {
        return new EWMA(M1_ALPHA, 5L, TimeUnit.SECONDS);
    }

    public static EWMA fiveMinuteEWMA() {
        return new EWMA(M5_ALPHA, 5L, TimeUnit.SECONDS);
    }

    public static EWMA fifteenMinuteEWMA() {
        return new EWMA(M15_ALPHA, 5L, TimeUnit.SECONDS);
    }

    public EWMA(double alpha, long interval, TimeUnit intervalUnit) {
        this.interval = intervalUnit.toNanos(interval);
        this.alpha = alpha;
    }

    public void update(long n) {
        this.uncounted.add(n);
    }

    public void tick() {
        long count = this.uncounted.sumThenReset();
        double instantRate = (double)count / this.interval;
        if (this.initialized) {
            this.rate += this.alpha * (instantRate - this.rate);
        } else {
            this.rate = instantRate;
            this.initialized = true;
        }
    }

    public double getRate(TimeUnit rateUnit) {
        return this.rate * (double)rateUnit.toNanos(1L);
    }
}

