/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import org.apache.flink.hadoop.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.flink.hadoop.shaded.org.jboss.netty.buffer.ChannelBufferFactory;
import org.apache.flink.hadoop.shaded.org.jboss.netty.channel.Channel;
import org.apache.flink.hadoop.shaded.org.jboss.netty.channel.ChannelException;
import org.apache.flink.hadoop.shaded.org.jboss.netty.channel.ChannelFuture;
import org.apache.flink.hadoop.shaded.org.jboss.netty.channel.Channels;
import org.apache.flink.hadoop.shaded.org.jboss.netty.channel.ReceiveBufferSizePredictor;
import org.apache.flink.hadoop.shaded.org.jboss.netty.channel.socket.nio.AbstractNioChannel;
import org.apache.flink.hadoop.shaded.org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.apache.flink.hadoop.shaded.org.jboss.netty.channel.socket.nio.NioClientSocketChannel;
import org.apache.flink.hadoop.shaded.org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.apache.flink.hadoop.shaded.org.jboss.netty.channel.socket.nio.SocketReceiveBufferAllocator;
import org.apache.flink.hadoop.shaded.org.jboss.netty.util.ThreadNameDeterminer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioWorker
extends AbstractNioWorker {
    private final SocketReceiveBufferAllocator recvBufferPool = new SocketReceiveBufferAllocator();

    public NioWorker(Executor executor) {
        super(executor);
    }

    public NioWorker(Executor executor, ThreadNameDeterminer determiner) {
        super(executor, determiner);
    }

    @Override
    protected boolean read(SelectionKey k) {
        SocketChannel ch = (SocketChannel)k.channel();
        NioSocketChannel channel = (NioSocketChannel)k.attachment();
        ReceiveBufferSizePredictor predictor = channel.getConfig().getReceiveBufferSizePredictor();
        int predictedRecvBufSize = predictor.nextReceiveBufferSize();
        ChannelBufferFactory bufferFactory = channel.getConfig().getBufferFactory();
        int ret = 0;
        int readBytes = 0;
        boolean failure = true;
        ByteBuffer bb = this.recvBufferPool.get(predictedRecvBufSize).order(bufferFactory.getDefaultOrder());
        try {
            while ((ret = ch.read(bb)) > 0) {
                readBytes += ret;
                if (bb.hasRemaining()) continue;
            }
            failure = false;
        }
        catch (ClosedChannelException e) {
        }
        catch (Throwable t) {
            Channels.fireExceptionCaught(channel, t);
        }
        if (readBytes > 0) {
            bb.flip();
            ChannelBuffer buffer = bufferFactory.getBuffer(readBytes);
            buffer.setBytes(0, bb);
            buffer.writerIndex(readBytes);
            predictor.previousReceiveBufferSize(readBytes);
            Channels.fireMessageReceived(channel, (Object)buffer);
        }
        if (ret < 0 || failure) {
            k.cancel();
            this.close(channel, Channels.succeededFuture(channel));
            return false;
        }
        return true;
    }

    @Override
    protected boolean scheduleWriteIfNecessary(AbstractNioChannel<?> channel) {
        Thread workerThread;
        Thread currentThread = Thread.currentThread();
        if (currentThread != (workerThread = this.thread)) {
            if (channel.writeTaskInTaskQueue.compareAndSet(false, true)) {
                this.registerTask(channel.writeTask);
            }
            return true;
        }
        return false;
    }

    @Override
    protected Runnable createRegisterTask(Channel channel, ChannelFuture future) {
        boolean server = !(channel instanceof NioClientSocketChannel);
        return new RegisterTask((NioSocketChannel)channel, future, server);
    }

    @Override
    public void run() {
        super.run();
        this.recvBufferPool.releaseExternalResources();
    }

    private final class RegisterTask
    implements Runnable {
        private final NioSocketChannel channel;
        private final ChannelFuture future;
        private final boolean server;

        RegisterTask(NioSocketChannel channel, ChannelFuture future, boolean server) {
            this.channel = channel;
            this.future = future;
            this.server = server;
        }

        public void run() {
            block8: {
                InetSocketAddress localAddress = this.channel.getLocalAddress();
                InetSocketAddress remoteAddress = this.channel.getRemoteAddress();
                if (localAddress == null || remoteAddress == null) {
                    if (this.future != null) {
                        this.future.setFailure(new ClosedChannelException());
                    }
                    NioWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    return;
                }
                try {
                    if (this.server) {
                        ((SocketChannel)this.channel.channel).configureBlocking(false);
                    }
                    ((SocketChannel)this.channel.channel).register(NioWorker.this.selector, this.channel.getRawInterestOps(), this.channel);
                    if (this.future != null) {
                        this.channel.setConnected();
                        this.future.setSuccess();
                    }
                    if (this.server || !((NioClientSocketChannel)this.channel).boundManually) {
                        Channels.fireChannelBound(this.channel, (SocketAddress)localAddress);
                    }
                    Channels.fireChannelConnected(this.channel, (SocketAddress)remoteAddress);
                }
                catch (IOException e) {
                    if (this.future != null) {
                        this.future.setFailure(e);
                    }
                    NioWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    if (e instanceof ClosedChannelException) break block8;
                    throw new ChannelException("Failed to register a socket to the selector.", e);
                }
            }
        }
    }
}

