/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hadoop.shaded.org.apache.http.impl.cookie;

import org.apache.flink.hadoop.shaded.org.apache.http.annotation.Immutable;
import org.apache.flink.hadoop.shaded.org.apache.http.cookie.Cookie;
import org.apache.flink.hadoop.shaded.org.apache.http.cookie.CookieOrigin;
import org.apache.flink.hadoop.shaded.org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.flink.hadoop.shaded.org.apache.http.cookie.MalformedCookieException;
import org.apache.flink.hadoop.shaded.org.apache.http.cookie.SetCookie;
import org.apache.flink.hadoop.shaded.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;

@Immutable
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().length() == 0) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }
}

