/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;

@Internal
public final class StreamRecord<T>
extends StreamElement {
    private T value;
    private long timestamp;
    private boolean hasTimestamp;

    public StreamRecord(T value) {
        this.value = value;
    }

    public StreamRecord(T value, long timestamp) {
        this.value = value;
        this.timestamp = timestamp;
        this.hasTimestamp = true;
    }

    public T getValue() {
        return this.value;
    }

    public long getTimestamp() {
        if (this.hasTimestamp) {
            return this.timestamp;
        }
        return Long.MIN_VALUE;
    }

    public boolean hasTimestamp() {
        return this.hasTimestamp;
    }

    public <X> StreamRecord<X> replace(X element) {
        this.value = element;
        return this;
    }

    public <X> StreamRecord<X> replace(X value, long timestamp) {
        this.timestamp = timestamp;
        this.value = value;
        this.hasTimestamp = true;
        return this;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        this.hasTimestamp = true;
    }

    public void eraseTimestamp() {
        this.hasTimestamp = false;
    }

    public StreamRecord<T> copy(T valueCopy) {
        StreamRecord<T> copy = new StreamRecord<T>(valueCopy);
        copy.timestamp = this.timestamp;
        copy.hasTimestamp = this.hasTimestamp;
        return copy;
    }

    public void copyTo(T valueCopy, StreamRecord<T> target) {
        target.value = valueCopy;
        target.timestamp = this.timestamp;
        target.hasTimestamp = this.hasTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            StreamRecord that = (StreamRecord)o;
            return this.hasTimestamp == that.hasTimestamp && (!this.hasTimestamp || this.timestamp == that.timestamp) && (this.value == null ? that.value == null : this.value.equals(that.value));
        }
        return false;
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        return 31 * result + (this.hasTimestamp ? (int)(this.timestamp ^ this.timestamp >>> 32) : 0);
    }

    public String toString() {
        return "Record @ " + String.valueOf(this.hasTimestamp ? Long.valueOf(this.timestamp) : "(undef)") + " : " + String.valueOf(this.value);
    }
}

