/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.assigners;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.WindowStagger;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;

@PublicEvolving
public class TumblingProcessingTimeWindows
extends WindowAssigner<Object, TimeWindow> {
    private static final long serialVersionUID = 1L;
    private final long size;
    private final long globalOffset;
    private Long staggerOffset = null;
    private final WindowStagger windowStagger;

    private TumblingProcessingTimeWindows(long size, long offset, WindowStagger windowStagger) {
        if (Math.abs(offset) >= size) {
            throw new IllegalArgumentException("TumblingProcessingTimeWindows parameters must satisfy abs(offset) < size");
        }
        this.size = size;
        this.globalOffset = offset;
        this.windowStagger = windowStagger;
    }

    @Override
    public Collection<TimeWindow> assignWindows(Object element, long timestamp, WindowAssigner.WindowAssignerContext context) {
        long now = context.getCurrentProcessingTime();
        if (this.staggerOffset == null) {
            this.staggerOffset = this.windowStagger.getStaggerOffset(context.getCurrentProcessingTime(), this.size);
        }
        long start = TimeWindow.getWindowStartWithOffset(now, (this.globalOffset + this.staggerOffset) % this.size, this.size);
        return Collections.singletonList(new TimeWindow(start, start + this.size));
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public Trigger<Object, TimeWindow> getDefaultTrigger() {
        return ProcessingTimeTrigger.create();
    }

    public String toString() {
        return "TumblingProcessingTimeWindows(" + this.size + ")";
    }

    public static TumblingProcessingTimeWindows of(Duration size) {
        return new TumblingProcessingTimeWindows(size.toMillis(), 0L, WindowStagger.ALIGNED);
    }

    public static TumblingProcessingTimeWindows of(Duration size, Duration offset) {
        return new TumblingProcessingTimeWindows(size.toMillis(), offset.toMillis(), WindowStagger.ALIGNED);
    }

    @PublicEvolving
    public static TumblingProcessingTimeWindows of(Duration size, Duration offset, WindowStagger windowStagger) {
        return new TumblingProcessingTimeWindows(size.toMillis(), offset.toMillis(), windowStagger);
    }

    @Override
    public TypeSerializer<TimeWindow> getWindowSerializer(ExecutionConfig executionConfig) {
        return new TimeWindow.Serializer();
    }

    @Override
    public boolean isEventTime() {
        return false;
    }
}

