/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.guava33.com.google.common.collect.Lists;

@Internal
public class UnionTransformation<T>
extends Transformation<T> {
    private final List<Transformation<T>> inputs;

    public UnionTransformation(List<Transformation<T>> inputs) {
        super("Union", inputs.get(0).getOutputType(), inputs.get(0).getParallelism());
        for (Transformation<T> input : inputs) {
            if (input.getOutputType().equals((Object)this.getOutputType())) continue;
            throw new UnsupportedOperationException("Type mismatch in input " + String.valueOf(input));
        }
        this.inputs = Lists.newArrayList(inputs);
    }

    public List<Transformation<?>> getInputs() {
        return new ArrayList(this.inputs);
    }

    protected List<Transformation<?>> getTransitivePredecessorsInternal() {
        List<Transformation<?>> predecessors = this.inputs.stream().flatMap(input -> input.getTransitivePredecessors().stream()).distinct().collect(Collectors.toList());
        predecessors.add(this);
        return predecessors;
    }
}

