/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.co;

import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.SimpleTimerService;
import org.apache.flink.streaming.api.TimeDomain;
import org.apache.flink.streaming.api.TimerService;
import org.apache.flink.streaming.api.functions.co.CoProcessFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

@Deprecated
@Internal
public class LegacyKeyedCoProcessOperator<K, IN1, IN2, OUT>
extends AbstractUdfStreamOperator<OUT, CoProcessFunction<IN1, IN2, OUT>>
implements TwoInputStreamOperator<IN1, IN2, OUT>,
Triggerable<K, VoidNamespace> {
    private static final long serialVersionUID = 1L;
    private transient TimestampedCollector<OUT> collector;
    private transient ContextImpl<IN1, IN2, OUT> context;
    private transient OnTimerContextImpl<IN1, IN2, OUT> onTimerContext;

    public LegacyKeyedCoProcessOperator(CoProcessFunction<IN1, IN2, OUT> flatMapper) {
        super(flatMapper);
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.collector = new TimestampedCollector(this.output);
        InternalTimerService<VoidNamespace> internalTimerService = this.getInternalTimerService("user-timers", VoidNamespaceSerializer.INSTANCE, this);
        SimpleTimerService timerService = new SimpleTimerService(internalTimerService);
        this.context = new ContextImpl((CoProcessFunction)this.userFunction, timerService);
        this.onTimerContext = new OnTimerContextImpl((CoProcessFunction)this.userFunction, timerService);
    }

    @Override
    public void processElement1(StreamRecord<IN1> element) throws Exception {
        this.collector.setTimestamp(element);
        this.context.element = element;
        ((CoProcessFunction)this.userFunction).processElement1(element.getValue(), this.context, this.collector);
        this.context.element = null;
    }

    @Override
    public void processElement2(StreamRecord<IN2> element) throws Exception {
        this.collector.setTimestamp(element);
        this.context.element = element;
        ((CoProcessFunction)this.userFunction).processElement2(element.getValue(), this.context, this.collector);
        this.context.element = null;
    }

    @Override
    public void onEventTime(InternalTimer<K, VoidNamespace> timer) throws Exception {
        this.collector.setAbsoluteTimestamp(timer.getTimestamp());
        this.onTimerContext.timeDomain = TimeDomain.EVENT_TIME;
        this.onTimerContext.timer = timer;
        ((CoProcessFunction)this.userFunction).onTimer(timer.getTimestamp(), this.onTimerContext, this.collector);
        this.onTimerContext.timeDomain = null;
        this.onTimerContext.timer = null;
    }

    @Override
    public void onProcessingTime(InternalTimer<K, VoidNamespace> timer) throws Exception {
        this.collector.eraseTimestamp();
        this.onTimerContext.timeDomain = TimeDomain.PROCESSING_TIME;
        this.onTimerContext.timer = timer;
        ((CoProcessFunction)this.userFunction).onTimer(timer.getTimestamp(), this.onTimerContext, this.collector);
        this.onTimerContext.timeDomain = null;
        this.onTimerContext.timer = null;
    }

    protected TimestampedCollector<OUT> getCollector() {
        return this.collector;
    }

    private class OnTimerContextImpl<IN1, IN2, OUT>
    extends CoProcessFunction.OnTimerContext {
        private final TimerService timerService;
        private TimeDomain timeDomain;
        private InternalTimer<?, VoidNamespace> timer;

        OnTimerContextImpl(CoProcessFunction<IN1, IN2, OUT> function, TimerService timerService) {
            super(function);
            this.timerService = (TimerService)Preconditions.checkNotNull((Object)timerService);
        }

        @Override
        public Long timestamp() {
            Preconditions.checkState((this.timer != null ? 1 : 0) != 0);
            return this.timer.getTimestamp();
        }

        @Override
        public TimerService timerService() {
            return this.timerService;
        }

        @Override
        public <X> void output(OutputTag<X> outputTag, X value) {
            if (outputTag == null) {
                throw new IllegalArgumentException("OutputTag must not be null.");
            }
            LegacyKeyedCoProcessOperator.this.output.collect(outputTag, new StreamRecord<X>(value, this.timer.getTimestamp()));
        }

        @Override
        public TimeDomain timeDomain() {
            Preconditions.checkState((this.timeDomain != null ? 1 : 0) != 0);
            return this.timeDomain;
        }
    }

    private class ContextImpl<IN1, IN2, OUT>
    extends CoProcessFunction.Context {
        private final TimerService timerService;
        private StreamRecord<?> element;

        ContextImpl(CoProcessFunction<IN1, IN2, OUT> function, TimerService timerService) {
            super(function);
            this.timerService = (TimerService)Preconditions.checkNotNull((Object)timerService);
        }

        @Override
        public Long timestamp() {
            Preconditions.checkState((this.element != null ? 1 : 0) != 0);
            if (this.element.hasTimestamp()) {
                return this.element.getTimestamp();
            }
            return null;
        }

        @Override
        public TimerService timerService() {
            return this.timerService;
        }

        @Override
        public <X> void output(OutputTag<X> outputTag, X value) {
            if (outputTag == null) {
                throw new IllegalArgumentException("OutputTag must not be null.");
            }
            LegacyKeyedCoProcessOperator.this.output.collect(outputTag, new StreamRecord<X>(value, this.element.getTimestamp()));
        }
    }
}

