/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.util.OperatorChainInfo;
import org.apache.flink.util.SerializedValue;

@Internal
public class JobVertexBuildContext {
    private final JobGraph jobGraph;
    private final StreamGraph streamGraph;
    private final Map<Integer, OperatorChainInfo> chainInfosInOrder;
    private final Map<Integer, Map<Integer, StreamConfig>> chainedConfigs;
    private final Map<Integer, JobVertex> jobVerticesInOrder;
    private final Map<JobVertexID, List<CompletableFuture<SerializedValue<OperatorCoordinator.Provider>>>> coordinatorSerializationFuturesPerJobVertex;
    private final List<StreamEdge> physicalEdgesInOrder;
    private final AtomicBoolean hasHybridResultPartition;
    private final Map<Integer, byte[]> hashes;
    private final List<Map<Integer, byte[]>> legacyHashes;
    private final SlotSharingGroup defaultSlotSharingGroup;

    public JobVertexBuildContext(JobGraph jobGraph, StreamGraph streamGraph, AtomicBoolean hasHybridResultPartition, Map<Integer, byte[]> hashes, List<Map<Integer, byte[]>> legacyHashes, SlotSharingGroup defaultSlotSharingGroup) {
        this.jobGraph = jobGraph;
        this.streamGraph = streamGraph;
        this.hashes = hashes;
        this.legacyHashes = legacyHashes;
        this.chainInfosInOrder = new LinkedHashMap<Integer, OperatorChainInfo>();
        this.jobVerticesInOrder = new LinkedHashMap<Integer, JobVertex>();
        this.physicalEdgesInOrder = new ArrayList<StreamEdge>();
        this.hasHybridResultPartition = hasHybridResultPartition;
        this.coordinatorSerializationFuturesPerJobVertex = new HashMap<JobVertexID, List<CompletableFuture<SerializedValue<OperatorCoordinator.Provider>>>>();
        this.chainedConfigs = new HashMap<Integer, Map<Integer, StreamConfig>>();
        this.defaultSlotSharingGroup = defaultSlotSharingGroup;
    }

    public void addChainInfo(Integer startNodeId, OperatorChainInfo chainInfo) {
        this.chainInfosInOrder.put(startNodeId, chainInfo);
    }

    public OperatorChainInfo getChainInfo(Integer startNodeId) {
        return this.chainInfosInOrder.get(startNodeId);
    }

    public Map<Integer, OperatorChainInfo> getChainInfosInOrder() {
        return this.chainInfosInOrder;
    }

    public StreamGraph getStreamGraph() {
        return this.streamGraph;
    }

    public boolean hasHybridResultPartition() {
        return this.hasHybridResultPartition.get();
    }

    public void setHasHybridResultPartition(boolean hasHybridResultPartition) {
        this.hasHybridResultPartition.set(hasHybridResultPartition);
    }

    public void addPhysicalEdgesInOrder(StreamEdge edge) {
        this.physicalEdgesInOrder.add(edge);
    }

    public List<StreamEdge> getPhysicalEdgesInOrder() {
        return this.physicalEdgesInOrder;
    }

    public void addJobVertex(Integer startNodeId, JobVertex jobVertex) {
        this.jobVerticesInOrder.put(startNodeId, jobVertex);
    }

    public Map<Integer, JobVertex> getJobVerticesInOrder() {
        return this.jobVerticesInOrder;
    }

    public JobVertex getJobVertex(Integer startNodeId) {
        return this.jobVerticesInOrder.get(startNodeId);
    }

    public void putCoordinatorSerializationFutures(JobVertexID vertexId, List<CompletableFuture<SerializedValue<OperatorCoordinator.Provider>>> serializationFutures) {
        this.coordinatorSerializationFuturesPerJobVertex.put(vertexId, serializationFutures);
    }

    public Map<JobVertexID, List<CompletableFuture<SerializedValue<OperatorCoordinator.Provider>>>> getCoordinatorSerializationFuturesPerJobVertex() {
        return this.coordinatorSerializationFuturesPerJobVertex;
    }

    public Map<Integer, Map<Integer, StreamConfig>> getChainedConfigs() {
        return this.chainedConfigs;
    }

    public Map<Integer, StreamConfig> getOrCreateChainedConfig(Integer streamNodeId) {
        return this.chainedConfigs.computeIfAbsent(streamNodeId, key -> new HashMap());
    }

    public byte[] getHash(Integer streamNodeId) {
        return this.hashes.get(streamNodeId);
    }

    public List<byte[]> getLegacyHashes(Integer streamNodeId) {
        ArrayList<byte[]> hashes = new ArrayList<byte[]>();
        for (Map<Integer, byte[]> legacyHash : this.legacyHashes) {
            hashes.add(legacyHash.get(streamNodeId));
        }
        return hashes;
    }

    public JobGraph getJobGraph() {
        return this.jobGraph;
    }

    public SlotSharingGroup getDefaultSlotSharingGroup() {
        return this.defaultSlotSharingGroup;
    }
}

