/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.time.Duration;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.NullByteKeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.functions.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.functions.aggregation.SumAggregator;
import org.apache.flink.streaming.api.functions.windowing.AggregateApplyAllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.AllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.PassThroughAllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ProcessAllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ReduceApplyAllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ReduceApplyProcessAllWindowFunction;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.EvictingWindowOperatorFactory;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperatorFactory;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalAggregateProcessAllWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalIterableAllWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalIterableProcessAllWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalSingleValueAllWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalSingleValueProcessAllWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalWindowFunction;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.Utils;

@Public
public class AllWindowedStream<T, W extends Window> {
    private final KeyedStream<T, Byte> input;
    private final WindowAssigner<? super T, W> windowAssigner;
    private Trigger<? super T, ? super W> trigger;
    private Evictor<? super T, ? super W> evictor;
    private long allowedLateness = 0L;
    private OutputTag<T> lateDataOutputTag;

    @PublicEvolving
    public AllWindowedStream(DataStream<T> input, WindowAssigner<? super T, W> windowAssigner) {
        this.input = input.keyBy(new NullByteKeySelector());
        this.windowAssigner = windowAssigner;
        this.trigger = windowAssigner.getDefaultTrigger();
    }

    @PublicEvolving
    public AllWindowedStream<T, W> trigger(Trigger<? super T, ? super W> trigger) {
        if (this.windowAssigner instanceof MergingWindowAssigner && !trigger.canMerge()) {
            throw new UnsupportedOperationException("A merging window assigner cannot be used with a trigger that does not support merging.");
        }
        this.trigger = trigger;
        return this;
    }

    @PublicEvolving
    public AllWindowedStream<T, W> allowedLateness(Duration lateness) {
        long millis = lateness.toMillis();
        Preconditions.checkArgument((millis >= 0L ? 1 : 0) != 0, (Object)"The allowed lateness cannot be negative.");
        this.allowedLateness = millis;
        return this;
    }

    @PublicEvolving
    public AllWindowedStream<T, W> sideOutputLateData(OutputTag<T> outputTag) {
        Preconditions.checkNotNull(outputTag, (String)"Side output tag must not be null.");
        this.lateDataOutputTag = this.input.getExecutionEnvironment().clean(outputTag);
        return this;
    }

    @PublicEvolving
    public AllWindowedStream<T, W> evictor(Evictor<? super T, ? super W> evictor) {
        this.evictor = evictor;
        return this;
    }

    public SingleOutputStreamOperator<T> reduce(ReduceFunction<T> function) {
        if (function instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of reduce can not be a RichFunction. Please use reduce(ReduceFunction, WindowFunction) instead.");
        }
        function = this.input.getExecutionEnvironment().clean(function);
        String callLocation = Utils.getCallLocationName();
        String udfName = "AllWindowedStream." + callLocation;
        return this.reduce(function, new PassThroughAllWindowFunction());
    }

    @PublicEvolving
    public <R> SingleOutputStreamOperator<R> reduce(ReduceFunction<T> reduceFunction, AllWindowFunction<T, R, W> function) {
        TypeInformation inType = this.input.getType();
        TypeInformation<R> resultType = AllWindowedStream.getAllWindowFunctionReturnType(function, inType);
        return this.reduce(reduceFunction, function, resultType);
    }

    @PublicEvolving
    public <R> SingleOutputStreamOperator<R> reduce(ReduceFunction<T> reduceFunction, AllWindowFunction<T, R, W> function, TypeInformation<R> resultType) {
        WindowOperatorFactory operator;
        String opDescription;
        if (reduceFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of reduce can not be a RichFunction.");
        }
        function = this.input.getExecutionEnvironment().clean(function);
        reduceFunction = this.input.getExecutionEnvironment().clean(reduceFunction);
        String callLocation = Utils.getCallLocationName();
        String udfName = "AllWindowedStream." + callLocation;
        String opName = this.windowAssigner.getClass().getSimpleName();
        KeySelector<T, Byte> keySel = this.input.getKeySelector();
        if (this.evictor != null) {
            StreamElementSerializer streamRecordSerializer = new StreamElementSerializer(this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()));
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", streamRecordSerializer);
            opDescription = "TriggerWindow(" + String.valueOf(this.windowAssigner) + ", " + String.valueOf(stateDesc) + ", " + String.valueOf(this.trigger) + ", " + String.valueOf(this.evictor) + ", " + udfName + ")";
            operator = new EvictingWindowOperatorFactory(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()), stateDesc, new InternalIterableAllWindowFunction<W, T, R>(new ReduceApplyAllWindowFunction<W, T, R>(reduceFunction, function)), this.trigger, this.evictor, this.allowedLateness, this.lateDataOutputTag);
        } else {
            ReducingStateDescriptor stateDesc = new ReducingStateDescriptor("window-contents", reduceFunction, this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()));
            opDescription = "TriggerWindow(" + String.valueOf(this.windowAssigner) + ", " + String.valueOf(stateDesc) + ", " + String.valueOf(this.trigger) + ", " + udfName + ")";
            operator = new WindowOperatorFactory(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()), stateDesc, new InternalSingleValueAllWindowFunction<T, R, W>(function), this.trigger, this.allowedLateness, this.lateDataOutputTag);
        }
        return this.input.transform(opName, resultType, operator).setDescription(opDescription).forceNonParallel();
    }

    @PublicEvolving
    public <R> SingleOutputStreamOperator<R> reduce(ReduceFunction<T> reduceFunction, ProcessAllWindowFunction<T, R, W> function) {
        TypeInformation<R> resultType = AllWindowedStream.getProcessAllWindowFunctionReturnType(function, this.input.getType());
        return this.reduce(reduceFunction, function, resultType);
    }

    @PublicEvolving
    public <R> SingleOutputStreamOperator<R> reduce(ReduceFunction<T> reduceFunction, ProcessAllWindowFunction<T, R, W> function, TypeInformation<R> resultType) {
        WindowOperatorFactory operator;
        String opName;
        if (reduceFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of reduce can not be a RichFunction.");
        }
        function = this.input.getExecutionEnvironment().clean(function);
        reduceFunction = this.input.getExecutionEnvironment().clean(reduceFunction);
        String callLocation = Utils.getCallLocationName();
        String udfName = "AllWindowedStream." + callLocation;
        KeySelector<T, Byte> keySel = this.input.getKeySelector();
        if (this.evictor != null) {
            StreamElementSerializer streamRecordSerializer = new StreamElementSerializer(this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()));
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", streamRecordSerializer);
            opName = "TriggerWindow(" + String.valueOf(this.windowAssigner) + ", " + String.valueOf(stateDesc) + ", " + String.valueOf(this.trigger) + ", " + String.valueOf(this.evictor) + ", " + udfName + ")";
            operator = new EvictingWindowOperatorFactory(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()), stateDesc, new InternalIterableProcessAllWindowFunction<W, T, R>(new ReduceApplyProcessAllWindowFunction<W, T, R>(reduceFunction, function)), this.trigger, this.evictor, this.allowedLateness, this.lateDataOutputTag);
        } else {
            ReducingStateDescriptor stateDesc = new ReducingStateDescriptor("window-contents", reduceFunction, this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()));
            opName = "TriggerWindow(" + String.valueOf(this.windowAssigner) + ", " + String.valueOf(stateDesc) + ", " + String.valueOf(this.trigger) + ", " + udfName + ")";
            operator = new WindowOperatorFactory(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()), stateDesc, new InternalSingleValueProcessAllWindowFunction<T, R, W>(function), this.trigger, this.allowedLateness, this.lateDataOutputTag);
        }
        return this.input.transform(opName, resultType, operator).forceNonParallel();
    }

    @PublicEvolving
    public <ACC, R> SingleOutputStreamOperator<R> aggregate(AggregateFunction<T, ACC, R> function) {
        Preconditions.checkNotNull(function, (String)"function");
        if (function instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregation function cannot be a RichFunction.");
        }
        TypeInformation accumulatorType = TypeExtractor.getAggregateFunctionAccumulatorType(function, this.input.getType(), null, (boolean)false);
        TypeInformation resultType = TypeExtractor.getAggregateFunctionReturnType(function, this.input.getType(), null, (boolean)false);
        return this.aggregate(function, accumulatorType, resultType);
    }

    @PublicEvolving
    public <ACC, R> SingleOutputStreamOperator<R> aggregate(AggregateFunction<T, ACC, R> function, TypeInformation<ACC> accumulatorType, TypeInformation<R> resultType) {
        Preconditions.checkNotNull(function, (String)"function");
        Preconditions.checkNotNull(accumulatorType, (String)"accumulatorType");
        Preconditions.checkNotNull(resultType, (String)"resultType");
        if (function instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregation function cannot be a RichFunction.");
        }
        return this.aggregate(function, new PassThroughAllWindowFunction(), accumulatorType, resultType);
    }

    @PublicEvolving
    public <ACC, V, R> SingleOutputStreamOperator<R> aggregate(AggregateFunction<T, ACC, V> aggFunction, AllWindowFunction<V, R, W> windowFunction) {
        Preconditions.checkNotNull(aggFunction, (String)"aggFunction");
        Preconditions.checkNotNull(windowFunction, (String)"windowFunction");
        TypeInformation accumulatorType = TypeExtractor.getAggregateFunctionAccumulatorType(aggFunction, this.input.getType(), null, (boolean)false);
        TypeInformation aggResultType = TypeExtractor.getAggregateFunctionReturnType(aggFunction, this.input.getType(), null, (boolean)false);
        TypeInformation<R> resultType = AllWindowedStream.getAllWindowFunctionReturnType(windowFunction, aggResultType);
        return this.aggregate(aggFunction, windowFunction, accumulatorType, resultType);
    }

    private static <IN, OUT> TypeInformation<OUT> getAllWindowFunctionReturnType(AllWindowFunction<IN, OUT, ?> function, TypeInformation<IN> inType) {
        return TypeExtractor.getUnaryOperatorReturnType(function, AllWindowFunction.class, (int)0, (int)1, (int[])new int[]{2, 0}, inType, null, (boolean)false);
    }

    private static <IN, OUT> TypeInformation<OUT> getProcessAllWindowFunctionReturnType(ProcessAllWindowFunction<IN, OUT, ?> function, TypeInformation<IN> inType) {
        return TypeExtractor.getUnaryOperatorReturnType(function, ProcessAllWindowFunction.class, (int)0, (int)1, (int[])TypeExtractor.NO_INDEX, inType, null, (boolean)false);
    }

    @PublicEvolving
    public <ACC, V, R> SingleOutputStreamOperator<R> aggregate(AggregateFunction<T, ACC, V> aggregateFunction, AllWindowFunction<V, R, W> windowFunction, TypeInformation<ACC> accumulatorType, TypeInformation<R> resultType) {
        WindowOperatorFactory operator;
        String opName;
        Preconditions.checkNotNull(aggregateFunction, (String)"aggregateFunction");
        Preconditions.checkNotNull(windowFunction, (String)"windowFunction");
        Preconditions.checkNotNull(accumulatorType, (String)"accumulatorType");
        Preconditions.checkNotNull(resultType, (String)"resultType");
        if (aggregateFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregate function cannot be a RichFunction.");
        }
        windowFunction = this.input.getExecutionEnvironment().clean(windowFunction);
        aggregateFunction = this.input.getExecutionEnvironment().clean(aggregateFunction);
        String callLocation = Utils.getCallLocationName();
        String udfName = "AllWindowedStream." + callLocation;
        KeySelector<T, Byte> keySel = this.input.getKeySelector();
        if (this.evictor != null) {
            StreamElementSerializer streamRecordSerializer = new StreamElementSerializer(this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()));
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", streamRecordSerializer);
            opName = "TriggerWindow(" + String.valueOf(this.windowAssigner) + ", " + String.valueOf(stateDesc) + ", " + String.valueOf(this.trigger) + ", " + String.valueOf(this.evictor) + ", " + udfName + ")";
            operator = new EvictingWindowOperatorFactory(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()), stateDesc, new InternalIterableAllWindowFunction(new AggregateApplyAllWindowFunction<W, T, ACC, V, R>(aggregateFunction, windowFunction)), this.trigger, this.evictor, this.allowedLateness, this.lateDataOutputTag);
        } else {
            AggregatingStateDescriptor stateDesc = new AggregatingStateDescriptor("window-contents", aggregateFunction, accumulatorType.createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()));
            opName = "TriggerWindow(" + String.valueOf(this.windowAssigner) + ", " + String.valueOf(stateDesc) + ", " + String.valueOf(this.trigger) + ", " + udfName + ")";
            operator = new WindowOperatorFactory(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()), stateDesc, new InternalSingleValueAllWindowFunction<V, R, W>(windowFunction), this.trigger, this.allowedLateness, this.lateDataOutputTag);
        }
        return this.input.transform(opName, resultType, operator).forceNonParallel();
    }

    @PublicEvolving
    public <ACC, V, R> SingleOutputStreamOperator<R> aggregate(AggregateFunction<T, ACC, V> aggFunction, ProcessAllWindowFunction<V, R, W> windowFunction) {
        Preconditions.checkNotNull(aggFunction, (String)"aggFunction");
        Preconditions.checkNotNull(windowFunction, (String)"windowFunction");
        TypeInformation accumulatorType = TypeExtractor.getAggregateFunctionAccumulatorType(aggFunction, this.input.getType(), null, (boolean)false);
        TypeInformation aggResultType = TypeExtractor.getAggregateFunctionReturnType(aggFunction, this.input.getType(), null, (boolean)false);
        TypeInformation<R> resultType = AllWindowedStream.getProcessAllWindowFunctionReturnType(windowFunction, aggResultType);
        return this.aggregate(aggFunction, windowFunction, accumulatorType, aggResultType, resultType);
    }

    @PublicEvolving
    public <ACC, V, R> SingleOutputStreamOperator<R> aggregate(AggregateFunction<T, ACC, V> aggregateFunction, ProcessAllWindowFunction<V, R, W> windowFunction, TypeInformation<ACC> accumulatorType, TypeInformation<V> aggregateResultType, TypeInformation<R> resultType) {
        WindowOperatorFactory operator;
        String opDescription;
        Preconditions.checkNotNull(aggregateFunction, (String)"aggregateFunction");
        Preconditions.checkNotNull(windowFunction, (String)"windowFunction");
        Preconditions.checkNotNull(accumulatorType, (String)"accumulatorType");
        Preconditions.checkNotNull(aggregateResultType, (String)"aggregateResultType");
        Preconditions.checkNotNull(resultType, (String)"resultType");
        if (aggregateFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregate function cannot be a RichFunction.");
        }
        windowFunction = this.input.getExecutionEnvironment().clean(windowFunction);
        aggregateFunction = this.input.getExecutionEnvironment().clean(aggregateFunction);
        String callLocation = Utils.getCallLocationName();
        String udfName = "AllWindowedStream." + callLocation;
        String opName = this.windowAssigner.getClass().getSimpleName();
        KeySelector<T, Byte> keySel = this.input.getKeySelector();
        if (this.evictor != null) {
            StreamElementSerializer streamRecordSerializer = new StreamElementSerializer(this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()));
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", streamRecordSerializer);
            opDescription = "TriggerWindow(" + String.valueOf(this.windowAssigner) + ", " + String.valueOf(stateDesc) + ", " + String.valueOf(this.trigger) + ", " + String.valueOf(this.evictor) + ", " + udfName + ")";
            operator = new EvictingWindowOperatorFactory(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()), stateDesc, new InternalAggregateProcessAllWindowFunction<T, ACC, V, R, W>(aggregateFunction, windowFunction), this.trigger, this.evictor, this.allowedLateness, this.lateDataOutputTag);
        } else {
            AggregatingStateDescriptor stateDesc = new AggregatingStateDescriptor("window-contents", aggregateFunction, accumulatorType.createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()));
            opDescription = "TriggerWindow(" + String.valueOf(this.windowAssigner) + ", " + String.valueOf(stateDesc) + ", " + String.valueOf(this.trigger) + ", " + udfName + ")";
            operator = new WindowOperatorFactory(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()), stateDesc, new InternalSingleValueProcessAllWindowFunction<V, R, W>(windowFunction), this.trigger, this.allowedLateness, this.lateDataOutputTag);
        }
        return this.input.transform(opName, resultType, operator).setDescription(opDescription).forceNonParallel();
    }

    public <R> SingleOutputStreamOperator<R> apply(AllWindowFunction<T, R, W> function) {
        String callLocation = Utils.getCallLocationName();
        function = this.input.getExecutionEnvironment().clean(function);
        TypeInformation<R> resultType = AllWindowedStream.getAllWindowFunctionReturnType(function, this.getInputType());
        return this.apply(new InternalIterableAllWindowFunction<T, R, W>(function), resultType, callLocation);
    }

    public <R> SingleOutputStreamOperator<R> apply(AllWindowFunction<T, R, W> function, TypeInformation<R> resultType) {
        String callLocation = Utils.getCallLocationName();
        function = this.input.getExecutionEnvironment().clean(function);
        return this.apply(new InternalIterableAllWindowFunction<T, R, W>(function), resultType, callLocation);
    }

    @PublicEvolving
    public <R> SingleOutputStreamOperator<R> process(ProcessAllWindowFunction<T, R, W> function) {
        String callLocation = Utils.getCallLocationName();
        function = this.input.getExecutionEnvironment().clean(function);
        TypeInformation<R> resultType = AllWindowedStream.getProcessAllWindowFunctionReturnType(function, this.getInputType());
        return this.apply(new InternalIterableProcessAllWindowFunction<T, R, W>(function), resultType, callLocation);
    }

    @PublicEvolving
    public <R> SingleOutputStreamOperator<R> process(ProcessAllWindowFunction<T, R, W> function, TypeInformation<R> resultType) {
        String callLocation = Utils.getCallLocationName();
        function = this.input.getExecutionEnvironment().clean(function);
        return this.apply(new InternalIterableProcessAllWindowFunction<T, R, W>(function), resultType, callLocation);
    }

    private <R> SingleOutputStreamOperator<R> apply(InternalWindowFunction<Iterable<T>, R, Byte, W> function, TypeInformation<R> resultType, String callLocation) {
        WindowOperatorFactory<Byte, ? super T, Iterable<T>, R, ? super W> operator;
        String opName;
        String udfName = "AllWindowedStream." + callLocation;
        KeySelector<T, Byte> keySel = this.input.getKeySelector();
        if (this.evictor != null) {
            StreamElementSerializer streamRecordSerializer = new StreamElementSerializer(this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()));
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", streamRecordSerializer);
            opName = "TriggerWindow(" + String.valueOf(this.windowAssigner) + ", " + String.valueOf(stateDesc) + ", " + String.valueOf(this.trigger) + ", " + String.valueOf(this.evictor) + ", " + udfName + ")";
            operator = new EvictingWindowOperatorFactory<Byte, T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()), stateDesc, function, this.trigger, this.evictor, this.allowedLateness, this.lateDataOutputTag);
        } else {
            ListStateDescriptor stateDesc = new ListStateDescriptor("window-contents", this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()));
            opName = "TriggerWindow(" + String.valueOf(this.windowAssigner) + ", " + String.valueOf(stateDesc) + ", " + String.valueOf(this.trigger) + ", " + udfName + ")";
            operator = new WindowOperatorFactory<Byte, T, Iterable<T>, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, (TypeSerializer<Byte>)this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig().getSerializerConfig()), stateDesc, function, this.trigger, this.allowedLateness, this.lateDataOutputTag);
        }
        return this.input.transform(opName, resultType, operator).forceNonParallel();
    }

    public SingleOutputStreamOperator<T> sum(int positionToSum) {
        return this.aggregate(new SumAggregator(positionToSum, this.input.getType(), this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> sum(String field) {
        return this.aggregate(new SumAggregator(field, this.input.getType(), this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> min(int positionToMin) {
        return this.aggregate(new ComparableAggregator(positionToMin, this.input.getType(), AggregationFunction.AggregationType.MIN, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> min(String field) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MIN, false, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> minBy(int positionToMinBy) {
        return this.minBy(positionToMinBy, true);
    }

    public SingleOutputStreamOperator<T> minBy(String positionToMinBy) {
        return this.minBy(positionToMinBy, true);
    }

    public SingleOutputStreamOperator<T> minBy(int positionToMinBy, boolean first) {
        return this.aggregate(new ComparableAggregator(positionToMinBy, this.input.getType(), AggregationFunction.AggregationType.MINBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> minBy(String field, boolean first) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MINBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> max(int positionToMax) {
        return this.aggregate(new ComparableAggregator(positionToMax, this.input.getType(), AggregationFunction.AggregationType.MAX, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> max(String field) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MAX, false, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> maxBy(int positionToMaxBy) {
        return this.maxBy(positionToMaxBy, true);
    }

    public SingleOutputStreamOperator<T> maxBy(String positionToMaxBy) {
        return this.maxBy(positionToMaxBy, true);
    }

    public SingleOutputStreamOperator<T> maxBy(int positionToMaxBy, boolean first) {
        return this.aggregate(new ComparableAggregator(positionToMaxBy, this.input.getType(), AggregationFunction.AggregationType.MAXBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T> maxBy(String field, boolean first) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MAXBY, first, this.input.getExecutionConfig()));
    }

    private SingleOutputStreamOperator<T> aggregate(AggregationFunction<T> aggregator) {
        return this.reduce(aggregator);
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.input.getExecutionEnvironment();
    }

    public TypeInformation<T> getInputType() {
        return this.input.getType();
    }
}

