/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2.ttl;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.state.v2.StateIterator;
import org.apache.flink.runtime.state.ttl.TtlStateContext;
import org.apache.flink.runtime.state.ttl.TtlUtils;
import org.apache.flink.runtime.state.ttl.TtlValue;
import org.apache.flink.runtime.state.v2.internal.InternalMapState;
import org.apache.flink.runtime.state.v2.ttl.AbstractTtlState;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;

class TtlMapState<K, N, UK, UV>
extends AbstractTtlState<K, N, UV, TtlValue<UV>, InternalMapState<K, N, UK, TtlValue<UV>>>
implements InternalMapState<K, N, UK, UV> {
    protected TtlMapState(TtlStateContext<InternalMapState<K, N, UK, TtlValue<UV>>, UV> ttlStateContext) {
        super(ttlStateContext);
    }

    @Override
    public void clear() {
        ((InternalMapState)this.original).clear();
    }

    public StateFuture<UV> asyncGet(UK key) {
        return ((InternalMapState)this.original).asyncGet(key).thenApply(ttlValue -> this.getElementWithTtlCheck(ttlValue));
    }

    public StateFuture<Void> asyncPut(UK key, UV value) {
        return ((InternalMapState)this.original).asyncPut(key, value == null ? null : this.wrapWithTs(value));
    }

    public StateFuture<Void> asyncPutAll(Map<UK, UV> map) {
        HashMap<UK, TtlValue<UV>> withTs = new HashMap<UK, TtlValue<UV>>();
        for (Map.Entry<UK, UV> entry : map.entrySet()) {
            withTs.put(entry.getKey(), entry.getValue() == null ? null : this.wrapWithTs(entry.getValue()));
        }
        return ((InternalMapState)this.original).asyncPutAll(withTs);
    }

    public StateFuture<Void> asyncRemove(UK key) {
        return ((InternalMapState)this.original).asyncRemove(key);
    }

    public StateFuture<Boolean> asyncContains(UK key) {
        return ((InternalMapState)this.original).asyncGet(key).thenApply(ttlValue -> this.getElementWithTtlCheck(ttlValue) != null);
    }

    public StateFuture<StateIterator<Map.Entry<UK, UV>>> asyncEntries() {
        return ((InternalMapState)this.original).asyncEntries().thenApply(iter -> new AsyncEntriesIterator<Map.Entry>(iter, e -> e));
    }

    public StateFuture<StateIterator<UK>> asyncKeys() {
        return ((InternalMapState)this.original).asyncEntries().thenApply(iter -> new AsyncEntriesIterator<Object>(iter, e -> e.getKey()));
    }

    public StateFuture<StateIterator<UV>> asyncValues() {
        return ((InternalMapState)this.original).asyncEntries().thenApply(iter -> new AsyncEntriesIterator<Object>(iter, e -> e.getValue()));
    }

    public StateFuture<Boolean> asyncIsEmpty() {
        return ((InternalMapState)this.original).asyncIsEmpty();
    }

    public UV get(UK key) {
        return (UV)this.getElementWithTtlCheck((TtlValue)((InternalMapState)this.original).get(key));
    }

    public void put(UK key, UV value) {
        ((InternalMapState)this.original).put(key, value == null ? null : this.wrapWithTs(value));
    }

    public void putAll(Map<UK, UV> map) {
        HashMap<UK, TtlValue<UV>> withTs = new HashMap<UK, TtlValue<UV>>();
        long currentTimestamp = this.timeProvider.currentTimestamp();
        for (Map.Entry<UK, UV> entry : map.entrySet()) {
            withTs.put(entry.getKey(), entry.getValue() == null ? null : TtlUtils.wrapWithTs(entry.getValue(), currentTimestamp));
        }
        ((InternalMapState)this.original).putAll(withTs);
    }

    public void remove(UK key) {
        ((InternalMapState)this.original).remove(key);
    }

    public boolean contains(UK key) {
        return this.getElementWithTtlCheck((TtlValue)((InternalMapState)this.original).get(key)) != null;
    }

    public Iterable<Map.Entry<UK, UV>> entries() {
        return this.entries(e -> e);
    }

    public Iterable<UK> keys() {
        return this.entries(e -> e.getKey());
    }

    public Iterable<UV> values() {
        return this.entries(e -> e.getValue());
    }

    private <R> Iterable<R> entries(Function<Map.Entry<UK, UV>, R> resultMapper) {
        Iterable withTs = ((InternalMapState)this.original).entries();
        return () -> new EntriesIterator(withTs == null ? Collections.emptyList() : withTs, resultMapper);
    }

    public Iterator<Map.Entry<UK, UV>> iterator() {
        return this.entries().iterator();
    }

    public boolean isEmpty() {
        return this.iterator().hasNext();
    }

    private class AsyncEntriesIterator<R>
    implements StateIterator<R> {
        private final StateIterator<Map.Entry<UK, TtlValue<UV>>> originalIterator;
        private final Function<Map.Entry<UK, UV>, R> resultMapper;

        public AsyncEntriesIterator(@Nonnull StateIterator<Map.Entry<UK, TtlValue<UV>>> originalIterator, Function<Map.Entry<UK, UV>, R> resultMapper) {
            this.originalIterator = originalIterator;
            this.resultMapper = resultMapper;
        }

        public <U> StateFuture<Collection<U>> onNext(FunctionWithException<R, StateFuture<? extends U>, Exception> iterating) {
            FunctionWithException ttlIterating = item -> {
                Object value = TtlMapState.this.getElementWithTtlCheck((TtlValue)item.getValue());
                if (value == null) {
                    return null;
                }
                R result = this.resultMapper.apply(new AbstractMap.SimpleEntry(item.getKey(), value));
                return (StateFuture)iterating.apply(result);
            };
            return this.originalIterator.onNext(ttlIterating);
        }

        public StateFuture<Void> onNext(ThrowingConsumer<R, Exception> iterating) {
            ThrowingConsumer ttlIterating = item -> {
                Object value = TtlMapState.this.getElementWithTtlCheck((TtlValue)item.getValue());
                if (value == null) {
                    return;
                }
                iterating.accept(this.resultMapper.apply(new AbstractMap.SimpleEntry(item.getKey(), value)));
            };
            return this.originalIterator.onNext(ttlIterating);
        }

        public boolean isEmpty() {
            return false;
        }
    }

    private class EntriesIterator<R>
    implements Iterator<R> {
        private final Iterator<Map.Entry<UK, TtlValue<UV>>> originalIterator;
        private final Function<Map.Entry<UK, UV>, R> resultMapper;
        private Map.Entry<UK, UV> nextUnexpired = null;
        private boolean rightAfterNextIsCalled = false;

        private EntriesIterator(@Nonnull Iterable<Map.Entry<UK, TtlValue<UV>>> withTs, Function<Map.Entry<UK, UV>, R> resultMapper) {
            this.originalIterator = withTs.iterator();
            this.resultMapper = resultMapper;
        }

        @Override
        public boolean hasNext() {
            this.rightAfterNextIsCalled = false;
            while (this.nextUnexpired == null && this.originalIterator.hasNext()) {
                Map.Entry ttlEntry = this.originalIterator.next();
                Object value = TtlMapState.this.getElementWithTtlCheck(ttlEntry.getValue());
                this.nextUnexpired = value == null ? null : new AbstractMap.SimpleEntry(ttlEntry.getKey(), value);
            }
            return this.nextUnexpired != null;
        }

        @Override
        public R next() {
            if (this.hasNext()) {
                this.rightAfterNextIsCalled = true;
                R result = this.resultMapper.apply(this.nextUnexpired);
                this.nextUnexpired = null;
                return result;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (!this.rightAfterNextIsCalled) {
                throw new IllegalStateException("next() has not been called or hasNext() has been called afterwards, remove() is supported only right after calling next()");
            }
            this.originalIterator.remove();
        }
    }
}

