/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Set;
import org.apache.flink.core.execution.RecoveryClaimMode;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistryFactory;
import org.apache.flink.runtime.state.SharedStateRegistryImpl;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StreamStateHandle;

public interface SharedStateRegistry
extends AutoCloseable {
    public static final SharedStateRegistryFactory DEFAULT_FACTORY = (deleteExecutor, checkpoints, recoveryClaimMode) -> {
        SharedStateRegistryImpl sharedStateRegistry = new SharedStateRegistryImpl(deleteExecutor);
        for (CompletedCheckpoint checkpoint : checkpoints) {
            checkpoint.registerSharedStatesAfterRestored(sharedStateRegistry, recoveryClaimMode);
        }
        return sharedStateRegistry;
    };

    default public StreamStateHandle registerReference(SharedStateRegistryKey registrationKey, StreamStateHandle state, long checkpointID) {
        return this.registerReference(registrationKey, state, checkpointID, false);
    }

    public StreamStateHandle registerReference(SharedStateRegistryKey var1, StreamStateHandle var2, long var3, boolean var5);

    public Set<Long> unregisterUnusedState(long var1);

    public void registerAll(Iterable<? extends CompositeStateHandle> var1, long var2);

    public void registerAllAfterRestored(CompletedCheckpoint var1, RecoveryClaimMode var2);

    public void checkpointCompleted(long var1);
}

