/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.flink.runtime.state.KeyGroupsList;
import org.apache.flink.util.Preconditions;

public class KeyGroupRange
implements KeyGroupsList,
Serializable {
    private static final long serialVersionUID = 4869121477592070607L;
    public static final KeyGroupRange EMPTY_KEY_GROUP_RANGE = new KeyGroupRange();
    private final int startKeyGroup;
    private final int endKeyGroup;

    private KeyGroupRange() {
        this.startKeyGroup = 0;
        this.endKeyGroup = -1;
    }

    public KeyGroupRange(int startKeyGroup, int endKeyGroup) {
        Preconditions.checkArgument((startKeyGroup >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((startKeyGroup <= endKeyGroup ? 1 : 0) != 0);
        this.startKeyGroup = startKeyGroup;
        this.endKeyGroup = endKeyGroup;
        Preconditions.checkArgument((this.getNumberOfKeyGroups() >= 0 ? 1 : 0) != 0, (Object)"Potential overflow detected.");
    }

    @Override
    public boolean contains(int keyGroup) {
        return keyGroup >= this.startKeyGroup && keyGroup <= this.endKeyGroup;
    }

    public KeyGroupRange getIntersection(KeyGroupRange other) {
        int end;
        int start = Math.max(this.startKeyGroup, other.startKeyGroup);
        return start <= (end = Math.min(this.endKeyGroup, other.endKeyGroup)) ? new KeyGroupRange(start, end) : EMPTY_KEY_GROUP_RANGE;
    }

    @Override
    public int getNumberOfKeyGroups() {
        return 1 + this.endKeyGroup - this.startKeyGroup;
    }

    public int getStartKeyGroup() {
        return this.startKeyGroup;
    }

    public int getEndKeyGroup() {
        return this.endKeyGroup;
    }

    @Override
    public int getKeyGroupId(int idx) {
        if (idx < 0 || idx > this.getNumberOfKeyGroups()) {
            throw new IndexOutOfBoundsException("Key group index out of bounds: " + idx);
        }
        return this.startKeyGroup + idx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyGroupRange)) {
            return false;
        }
        KeyGroupRange that = (KeyGroupRange)o;
        return this.startKeyGroup == that.startKeyGroup && this.endKeyGroup == that.endKeyGroup;
    }

    public int hashCode() {
        int result = this.startKeyGroup;
        result = 31 * result + this.endKeyGroup;
        return result;
    }

    public String toString() {
        return "KeyGroupRange{startKeyGroup=" + this.startKeyGroup + ", endKeyGroup=" + this.endKeyGroup + "}";
    }

    public String prettyPrintInterval() {
        return "[" + this.startKeyGroup + ", " + this.endKeyGroup + "]";
    }

    @Override
    public Iterator<Integer> iterator() {
        return new KeyGroupIterator();
    }

    public static KeyGroupRange of(int startKeyGroup, int endKeyGroup) {
        return startKeyGroup <= endKeyGroup ? new KeyGroupRange(startKeyGroup, endKeyGroup) : EMPTY_KEY_GROUP_RANGE;
    }

    private final class KeyGroupIterator
    implements Iterator<Integer> {
        private int iteratorPos = 0;

        @Override
        public boolean hasNext() {
            return this.iteratorPos < KeyGroupRange.this.getNumberOfKeyGroups();
        }

        @Override
        public Integer next() {
            int rv = KeyGroupRange.this.startKeyGroup + this.iteratorPos;
            ++this.iteratorPos;
            return rv;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unsupported by this iterator!");
        }
    }
}

