/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.messages.FlinkJobTerminatedWithoutCancellationException;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;
import org.apache.flink.runtime.rest.messages.JobCancellationMessageParameters;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.TerminationModeQueryParameter;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

public class JobCancellationHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, EmptyResponseBody, JobCancellationMessageParameters> {
    private final TerminationModeQueryParameter.TerminationMode defaultTerminationMode;

    public JobCancellationHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> headers, MessageHeaders<EmptyRequestBody, EmptyResponseBody, JobCancellationMessageParameters> messageHeaders, TerminationModeQueryParameter.TerminationMode defaultTerminationMode) {
        super(leaderRetriever, timeout, headers, messageHeaders);
        this.defaultTerminationMode = (TerminationModeQueryParameter.TerminationMode)((Object)Preconditions.checkNotNull((Object)((Object)defaultTerminationMode)));
    }

    @Override
    public CompletableFuture<EmptyResponseBody> handleRequest(HandlerRequest<EmptyRequestBody> request, RestfulGateway gateway) throws RestHandlerException {
        CompletableFuture terminationFuture;
        JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        List terminationModes = request.getQueryParameter(TerminationModeQueryParameter.class);
        TerminationModeQueryParameter.TerminationMode terminationMode = terminationModes.isEmpty() ? this.defaultTerminationMode : (TerminationModeQueryParameter.TerminationMode)((Object)terminationModes.get(0));
        switch (terminationMode) {
            case CANCEL: {
                terminationFuture = gateway.cancelJob(jobId, this.timeout);
                break;
            }
            case STOP: {
                throw new RestHandlerException("The termination mode \"stop\" has been removed. For an ungraceful shutdown, please use \"cancel\" instead. For a graceful shutdown, please use \"jobs/:jobId/stop\" instead.", HttpResponseStatus.PERMANENT_REDIRECT);
            }
            default: {
                terminationFuture = FutureUtils.completedExceptionally((Throwable)((Object)new RestHandlerException("Unknown termination mode " + String.valueOf((Object)terminationMode) + ".", HttpResponseStatus.BAD_REQUEST)));
            }
        }
        return terminationFuture.handle((ack, throwable) -> {
            if (throwable != null) {
                Throwable error = ExceptionUtils.stripCompletionException((Throwable)throwable);
                if (error instanceof FlinkJobTerminatedWithoutCancellationException) {
                    throw new CompletionException((Throwable)((Object)new RestHandlerException(String.format("Job cancellation failed because the job has already reached another terminal state (%s).", ((FlinkJobTerminatedWithoutCancellationException)((Object)((Object)error))).getJobStatus()), HttpResponseStatus.CONFLICT)));
                }
                if (error instanceof TimeoutException) {
                    throw new CompletionException((Throwable)((Object)new RestHandlerException("Job cancellation timed out.", HttpResponseStatus.REQUEST_TIMEOUT, error)));
                }
                if (error instanceof FlinkJobNotFoundException) {
                    throw new CompletionException((Throwable)((Object)new RestHandlerException("Job could not be found.", HttpResponseStatus.NOT_FOUND, error)));
                }
                throw new CompletionException((Throwable)((Object)new RestHandlerException("Job cancellation failed: " + error.getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR, error)));
            }
            return EmptyResponseBody.getInstance();
        });
    }
}

