/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.net.URI;
import java.nio.file.Path;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.util.Preconditions;

public class CheckpointStorageUtils {
    public static void configureJobManagerCheckpointStorage(StreamExecutionEnvironment env) {
        env.configure((ReadableConfig)new Configuration().set(CheckpointingOptions.CHECKPOINT_STORAGE, (Object)"jobmanager"));
    }

    public static void configureFileSystemCheckpointStorage(StreamExecutionEnvironment env, String checkpointDirectory) {
        Preconditions.checkNotNull((Object)checkpointDirectory, (String)"Checkpoint directory must not be null");
        env.configure((ReadableConfig)new Configuration().set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)checkpointDirectory));
    }

    public static void configureFileSystemCheckpointStorage(StreamExecutionEnvironment env, String checkpointDirectory, long stateThreshold) {
        Preconditions.checkNotNull((Object)checkpointDirectory, (String)"Checkpoint directory must not be null");
        CheckpointStorageUtils.configureFileSystemCheckpointStorage(env, checkpointDirectory);
        MemorySize memorySize = MemorySize.parse((String)(stateThreshold + "b"));
        env.configure((ReadableConfig)new Configuration().set(CheckpointingOptions.FS_SMALL_FILE_THRESHOLD, (Object)memorySize));
    }

    public static void configureFileSystemCheckpointStorage(StreamExecutionEnvironment env, URI checkpointDirectory) {
        Preconditions.checkNotNull((Object)checkpointDirectory, (String)"Checkpoint directory must not be null");
        CheckpointStorageUtils.configureFileSystemCheckpointStorage(env, checkpointDirectory.toString());
    }

    public static void configureFileSystemCheckpointStorage(StreamExecutionEnvironment env, Path checkpointDirectory) {
        Preconditions.checkNotNull((Object)checkpointDirectory, (String)"Checkpoint directory must not be null");
        CheckpointStorageUtils.configureFileSystemCheckpointStorage(env, checkpointDirectory.toString());
    }

    public static void configureCheckpointStorageWithFactory(StreamExecutionEnvironment env, String checkpointStorageFactory) {
        Preconditions.checkNotNull((Object)(checkpointStorageFactory != null ? 1 : 0), (String)"Checkpoint storage factory must not be null.");
        env.configure((ReadableConfig)new Configuration().set(CheckpointingOptions.CHECKPOINT_STORAGE, (Object)checkpointStorageFactory));
    }
}

