/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import org.apache.flink.api.common.eventtime.SerializableTimestampAssigner;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.windowing.AllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ProcessAllWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ProcessWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperatorFactory;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class StateDescriptorPassingTest {
    StateDescriptorPassingTest() {
    }

    @Test
    void testReduceWindowState() {
        Configuration configuration = new Configuration();
        String serializerConfigStr = "{java.io.File: {type: kryo, kryo-type: registered, class: com.esotericsoftware.kryo.serializers.JavaSerializer}}";
        configuration.setString(PipelineOptions.SERIALIZATION_CONFIG.key(), serializerConfigStr);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)configuration);
        SingleOutputStreamOperator src = env.fromData((Object[])new File[]{new File("/")}).assignTimestampsAndWatermarks(WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(file, ts) -> System.currentTimeMillis()));
        SingleOutputStreamOperator result = src.keyBy((KeySelector)new KeySelector<File, String>(){

            public String getKey(File value) {
                return null;
            }
        }).window((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofMillis(1000L))).reduce((ReduceFunction)new ReduceFunction<File>(){

            public File reduce(File value1, File value2) {
                return null;
            }
        });
        this.validateStateDescriptorConfigured(result);
    }

    @Test
    void testApplyWindowState() {
        Configuration configuration = new Configuration();
        String serializerConfigStr = "{java.io.File: {type: kryo, kryo-type: registered, class: com.esotericsoftware.kryo.serializers.JavaSerializer}}";
        configuration.setString(PipelineOptions.SERIALIZATION_CONFIG.key(), serializerConfigStr);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)configuration);
        SingleOutputStreamOperator src = env.fromData((Object[])new File[]{new File("/")}).assignTimestampsAndWatermarks(WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(file, ts) -> System.currentTimeMillis()));
        SingleOutputStreamOperator result = src.keyBy((KeySelector)new KeySelector<File, String>(){

            public String getKey(File value) {
                return null;
            }
        }).window((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofMillis(1000L))).apply((WindowFunction)new WindowFunction<File, String, String, TimeWindow>(){

            public void apply(String s, TimeWindow window, Iterable<File> input, Collector<String> out) {
            }
        });
        this.validateListStateDescriptorConfigured(result);
    }

    @Test
    void testProcessWindowState() {
        Configuration configuration = new Configuration();
        String serializerConfigStr = "{java.io.File: {type: kryo, kryo-type: registered, class: com.esotericsoftware.kryo.serializers.JavaSerializer}}";
        configuration.setString(PipelineOptions.SERIALIZATION_CONFIG.key(), serializerConfigStr);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)configuration);
        SingleOutputStreamOperator src = env.fromData((Object[])new File[]{new File("/")}).assignTimestampsAndWatermarks(WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(file, ts) -> System.currentTimeMillis()));
        SingleOutputStreamOperator result = src.keyBy((KeySelector)new KeySelector<File, String>(){

            public String getKey(File value) {
                return null;
            }
        }).window((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofMillis(1000L))).process((ProcessWindowFunction)new ProcessWindowFunction<File, String, String, TimeWindow>(){

            public void process(String s, ProcessWindowFunction.Context ctx, Iterable<File> input, Collector<String> out) {
            }
        });
        this.validateListStateDescriptorConfigured(result);
    }

    @Test
    void testProcessAllWindowState() {
        Configuration configuration = new Configuration();
        String serializerConfigStr = "{java.io.File: {type: kryo, kryo-type: registered, class: com.esotericsoftware.kryo.serializers.JavaSerializer}}";
        configuration.setString(PipelineOptions.SERIALIZATION_CONFIG.key(), serializerConfigStr);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)configuration);
        SingleOutputStreamOperator src = env.fromData((Object[])new File[]{new File("/")}).assignTimestampsAndWatermarks(WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(file, ts) -> System.currentTimeMillis()));
        SingleOutputStreamOperator result = src.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofMillis(1000L))).process((ProcessAllWindowFunction)new ProcessAllWindowFunction<File, String, TimeWindow>(){

            public void process(ProcessAllWindowFunction.Context ctx, Iterable<File> input, Collector<String> out) {
            }
        });
        this.validateListStateDescriptorConfigured(result);
    }

    @Test
    void testReduceWindowAllState() {
        Configuration configuration = new Configuration();
        String serializerConfigStr = "{java.io.File: {type: kryo, kryo-type: registered, class: com.esotericsoftware.kryo.serializers.JavaSerializer}}";
        configuration.setString(PipelineOptions.SERIALIZATION_CONFIG.key(), serializerConfigStr);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)configuration);
        SingleOutputStreamOperator src = env.fromData((Object[])new File[]{new File("/")}).assignTimestampsAndWatermarks(WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(file, ts) -> System.currentTimeMillis()));
        SingleOutputStreamOperator result = src.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofMillis(1000L))).reduce((ReduceFunction)new ReduceFunction<File>(){

            public File reduce(File value1, File value2) {
                return null;
            }
        });
        this.validateStateDescriptorConfigured(result);
    }

    @Test
    void testApplyWindowAllState() {
        Configuration configuration = new Configuration();
        String serializerConfigStr = "{java.io.File: {type: kryo, kryo-type: registered, class: com.esotericsoftware.kryo.serializers.JavaSerializer}}";
        configuration.setString(PipelineOptions.SERIALIZATION_CONFIG.key(), serializerConfigStr);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)configuration);
        SingleOutputStreamOperator src = env.fromData((Object[])new File[]{new File("/")}).assignTimestampsAndWatermarks(WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(file, ts) -> System.currentTimeMillis()));
        SingleOutputStreamOperator result = src.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Duration)Duration.ofMillis(1000L))).apply((AllWindowFunction)new AllWindowFunction<File, String, TimeWindow>(){

            public void apply(TimeWindow window, Iterable<File> input, Collector<String> out) {
            }
        });
        this.validateListStateDescriptorConfigured(result);
    }

    private void validateStateDescriptorConfigured(SingleOutputStreamOperator<?> result) {
        StateDescriptor descr;
        OneInputTransformation transform = (OneInputTransformation)result.getTransformation();
        StreamOperatorFactory factory = transform.getOperatorFactory();
        if (factory instanceof WindowOperatorFactory) {
            descr = ((WindowOperatorFactory)factory).getStateDescriptor();
        } else {
            WindowOperator op = (WindowOperator)transform.getOperator();
            descr = op.getStateDescriptor();
        }
        TypeSerializer serializer = descr.getSerializer();
        Assertions.assertThat((Object)serializer).isInstanceOf(KryoSerializer.class);
        Kryo kryo = ((KryoSerializer)serializer).getKryo();
        ((ObjectAssert)Assertions.assertThat((Object)kryo.getSerializer(File.class)).as("serializer registration was not properly passed on", new Object[0])).isInstanceOf(JavaSerializer.class);
    }

    private void validateListStateDescriptorConfigured(SingleOutputStreamOperator<?> result) {
        StateDescriptor descr;
        OneInputTransformation transform = (OneInputTransformation)result.getTransformation();
        StreamOperatorFactory factory = transform.getOperatorFactory();
        if (factory instanceof WindowOperatorFactory) {
            descr = ((WindowOperatorFactory)factory).getStateDescriptor();
        } else {
            WindowOperator op = (WindowOperator)transform.getOperator();
            descr = op.getStateDescriptor();
        }
        Assertions.assertThat((Object)descr).isInstanceOf(ListStateDescriptor.class);
        ListStateDescriptor listDescr = (ListStateDescriptor)descr;
        TypeSerializer serializer = listDescr.getSerializer();
        Assertions.assertThat((Object)serializer).isInstanceOf(ListSerializer.class);
        TypeSerializer elementSerializer = listDescr.getElementSerializer();
        Assertions.assertThat((Object)elementSerializer).isInstanceOf(KryoSerializer.class);
        Kryo kryo = ((KryoSerializer)elementSerializer).getKryo();
        ((ObjectAssert)Assertions.assertThat((Object)kryo.getSerializer(File.class)).as("serializer registration was not properly passed on", new Object[0])).isInstanceOf(JavaSerializer.class);
    }
}

