/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.zookeeper;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.persistence.IntegerResourceVersion;
import org.apache.flink.runtime.persistence.PossibleInconsistentStateException;
import org.apache.flink.runtime.persistence.RetrievableStateStorageHelper;
import org.apache.flink.runtime.persistence.StateHandleStore;
import org.apache.flink.runtime.persistence.TestingLongStateHandleHelper;
import org.apache.flink.runtime.rest.util.NoOpFatalErrorHandler;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.state.RetrievableStateHandle;
import org.apache.flink.runtime.util.TestingFatalErrorHandlerExtension;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.zookeeper.ZooKeeperExtension;
import org.apache.flink.runtime.zookeeper.ZooKeeperStateHandleStore;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.guava33.com.google.common.collect.Iterables;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.data.Stat;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowableTypeAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;

class ZooKeeperStateHandleStoreTest {
    private final ZooKeeperExtension zooKeeperExtension = new ZooKeeperExtension();
    @RegisterExtension
    final EachCallbackWrapper<ZooKeeperExtension> zooKeeperResource = new EachCallbackWrapper((CustomExtension)this.zooKeeperExtension);
    @RegisterExtension
    final TestingFatalErrorHandlerExtension testingFatalErrorHandlerResource = new TestingFatalErrorHandlerExtension();

    ZooKeeperStateHandleStoreTest() {
    }

    @BeforeEach
    void cleanUp() {
        TestingLongStateHandleHelper.clearGlobalState();
    }

    private CuratorFramework getZooKeeperClient() {
        return this.zooKeeperExtension.getZooKeeperClient(this.testingFatalErrorHandlerResource.getTestingFatalErrorHandler());
    }

    @Test
    void testAddAndLock() throws Exception {
        TestingLongStateHandleHelper longStateStorage = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)longStateStorage);
        String pathInZooKeeper = "/testAdd";
        long state = 1239712317L;
        store.addAndLock("/testAdd", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(1239712317L)));
        Assertions.assertThat((List)store.getAllAndLock()).hasSize(1);
        Assertions.assertThat((long)((TestingLongStateHandleHelper.LongStateHandle)((Object)store.getAndLock("/testAdd").retrieveState())).getValue()).isEqualTo(1239712317L);
        Stat stat = (Stat)this.getZooKeeperClient().checkExists().forPath("/testAdd");
        Assertions.assertThat((Object)stat).isNotNull();
        Assertions.assertThat((long)stat.getEphemeralOwner()).isZero();
        List children = (List)this.getZooKeeperClient().getChildren().forPath("/testAdd");
        String locksSubfolderChild = (String)Iterables.getOnlyElement((Iterable)children);
        stat = (Stat)this.getZooKeeperClient().checkExists().forPath(ZooKeeperUtils.generateZookeeperPath((String[])new String[]{"/testAdd", locksSubfolderChild}));
        Assertions.assertThat((Object)stat).isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)stat.getEphemeralOwner()).as("The lock subfolder shouldn't be ephemeral", new Object[0])).isZero();
        List lockChildren = (List)this.getZooKeeperClient().getChildren().forPath(ZooKeeperUtils.generateZookeeperPath((String[])new String[]{"/testAdd", locksSubfolderChild}));
        String lockChild = (String)Iterables.getOnlyElement((Iterable)lockChildren);
        stat = (Stat)this.getZooKeeperClient().checkExists().forPath(ZooKeeperUtils.generateZookeeperPath((String[])new String[]{"/testAdd", locksSubfolderChild, lockChild}));
        ((AbstractLongAssert)Assertions.assertThat((long)stat.getEphemeralOwner()).as("The lock node should be ephemeral", new Object[0])).isNotZero();
        long actual = ((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)InstantiationUtil.deserializeObject((byte[])((byte[])this.getZooKeeperClient().getData().forPath("/testAdd")), (ClassLoader)ClassLoader.getSystemClassLoader())).retrieveState())).getValue();
        Assertions.assertThat((long)actual).isEqualTo(1239712317L);
    }

    @Test
    void testAddAndLockOnMarkedForDeletionNode() throws Exception {
        CuratorFramework client = ZooKeeperUtils.useNamespaceAndEnsurePath((CuratorFramework)this.getZooKeeperClient(), (String)"/testAddAndLockOnMarkedForDeletionNode");
        ZooKeeperStateHandleStore zkStore = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)new TestingLongStateHandleHelper());
        long oldStateValue = 1L;
        TestingLongStateHandleHelper.LongStateHandle oldStateHandle = new TestingLongStateHandleHelper.LongStateHandle(1L);
        String markedForDeletionNode = "marked-for-deletion";
        String markedForDeletionNodePath = ZooKeeperUtils.generateZookeeperPath((String[])new String[]{"marked-for-deletion"});
        zkStore.addAndLock(markedForDeletionNodePath, (Serializable)((Object)oldStateHandle));
        ZooKeeperStateHandleStoreTest.markNodeForDeletion(client, "marked-for-deletion");
        long updatedStateValue = 3L;
        TestingLongStateHandleHelper.LongStateHandle updatedStateHandle = new TestingLongStateHandleHelper.LongStateHandle(3L);
        zkStore.addAndLock(markedForDeletionNodePath, (Serializable)((Object)updatedStateHandle));
        Assertions.assertThat((long)((TestingLongStateHandleHelper.LongStateHandle)((Object)zkStore.getAndLock(markedForDeletionNodePath).retrieveState())).getValue()).isEqualTo(3L);
        Assertions.assertThat((boolean)oldStateHandle.isDiscarded()).isTrue();
        Assertions.assertThat((boolean)updatedStateHandle.isDiscarded()).isFalse();
    }

    @Test
    void testRepeatableCleanup() throws Exception {
        ZooKeeperStateHandleStore testInstance = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)new TestingLongStateHandleHelper());
        String pathInZooKeeper = "/testRepeatableCleanup";
        RuntimeException expectedException = new RuntimeException("Expected RuntimeException");
        TestingLongStateHandleHelper.LongStateHandle stateHandle = new TestingLongStateHandleHelper.LongStateHandle(12354L, ZooKeeperStateHandleStoreTest.throwExceptionOnce(expectedException));
        testInstance.addAndLock("/testRepeatableCleanup", (Serializable)((Object)stateHandle));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.releaseAndTryRemove("/testRepeatableCleanup")).as("Exception should have been thrown.", new Object[0])).hasCause((Throwable)expectedException);
        Assertions.assertThatExceptionOfType(StateHandleStore.NotExistException.class).isThrownBy(() -> testInstance.getAndLock("/testRepeatableCleanup"));
        Assertions.assertThat((boolean)stateHandle.isDiscarded()).isFalse();
        Assertions.assertThat((boolean)testInstance.releaseAndTryRemove("/testRepeatableCleanup")).isTrue();
        Assertions.assertThat((boolean)testInstance.exists("/testRepeatableCleanup").isExisting()).isFalse();
        Assertions.assertThat((boolean)stateHandle.isDiscarded()).isTrue();
    }

    @Test
    void testCleanupOfNonExistingState() throws Exception {
        ZooKeeperStateHandleStore testInstance = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)new TestingLongStateHandleHelper());
        String pathInZooKeeper = "/testCleanupOfNonExistingState";
        Assertions.assertThat((boolean)testInstance.releaseAndTryRemove("/testCleanupOfNonExistingState")).isTrue();
        Assertions.assertThat((boolean)testInstance.exists("/testCleanupOfNonExistingState").isExisting()).isFalse();
    }

    @Test
    void testRepeatableCleanupWithLockOnNode() throws Exception {
        CuratorFramework client = ZooKeeperUtils.useNamespaceAndEnsurePath((CuratorFramework)this.getZooKeeperClient(), (String)"/testRepeatableCleanupWithLockOnNode");
        TestingLongStateHandleHelper storage = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore storeForCreation = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)storage);
        ZooKeeperStateHandleStore storeForDeletion = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)storage);
        String pathInZooKeeper = "/testRepeatableCleanupWithLock";
        long actualValue = 12345L;
        RuntimeException expectedException = new RuntimeException("RuntimeException for testing the failing discardState call.");
        TestingLongStateHandleHelper.LongStateHandle stateHandle = new TestingLongStateHandleHelper.LongStateHandle(12345L, ZooKeeperStateHandleStoreTest.throwExceptionOnce(expectedException));
        RetrievableStateHandle handleForCreation = storeForCreation.addAndLock("/testRepeatableCleanupWithLock", (Serializable)((Object)stateHandle));
        RetrievableStateHandle handleForDeletion = storeForDeletion.getAndLock("/testRepeatableCleanupWithLock");
        Assertions.assertThat((long)12345L).isEqualTo(((TestingLongStateHandleHelper.LongStateHandle)((Object)handleForCreation.retrieveState())).getValue());
        Assertions.assertThat((long)12345L).isEqualTo(((TestingLongStateHandleHelper.LongStateHandle)((Object)handleForDeletion.retrieveState())).getValue());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)storeForCreation.releaseAndTryRemove("/testRepeatableCleanupWithLock")).as("Deletion by the first StateHandleStore shouldn't be successful because there's still a lock from StateHandleStore #1.", new Object[0])).isFalse();
        ((ObjectAssert)Assertions.assertThat((Object)((Stat)client.checkExists().forPath(ZooKeeperStateHandleStore.getRootLockPath((String)"/testRepeatableCleanupWithLock")))).as("StateHandle should not be marked for deletion, yet.", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)((Stat)client.checkExists().forPath(storeForCreation.getInstanceLockPath("/testRepeatableCleanupWithLock")))).as("The lock for storeForCreation should have been removed", new Object[0])).isNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)stateHandle.getNumberOfDiscardCalls()).as("discardState shouldn't have been called, yet.", new Object[0])).isZero();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> storeForDeletion.releaseAndTryRemove("/testRepeatableCleanupWithLock")).as("Exception should have been thrown.", new Object[0])).hasCause((Throwable)expectedException);
        ((ObjectAssert)Assertions.assertThat((Object)((Stat)client.checkExists().forPath(ZooKeeperStateHandleStore.getRootLockPath((String)"/testRepeatableCleanupWithLock")))).as("StateHandle should be marked for deletion.", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)((Stat)client.checkExists().forPath("/testRepeatableCleanupWithLock"))).as("StateHandle should not be deleted, yet.", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)stateHandle.isDiscarded()).as("The StateHandle should not be discarded, yet.", new Object[0])).isFalse();
        Assertions.assertThat((boolean)storeForDeletion.releaseAndTryRemove("/testRepeatableCleanupWithLock")).isTrue();
        ((ObjectAssert)Assertions.assertThat((Object)((Stat)client.checkExists().forPath("/testRepeatableCleanupWithLock"))).as("The StateHandle node should have been removed", new Object[0])).isNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)stateHandle.isDiscarded()).as("The StateHandle should have been discarded.", new Object[0])).isTrue();
    }

    @Test
    void testFailingAddWithPossiblyInconsistentState() {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        CuratorFramework client = (CuratorFramework)Mockito.spy((Object)this.getZooKeeperClient());
        Mockito.when((Object)client.inTransaction()).thenThrow(new Throwable[]{new RuntimeException("Expected test Exception.")});
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeper = "/testAddDiscardStateHandleAfterFailure";
        long state = 81282227L;
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(PossibleInconsistentStateException.class).as("PossibleInconsistentStateException should have been thrown.", new Object[0])).isThrownBy(() -> store.addAndLock("/testAddDiscardStateHandleAfterFailure", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(81282227L))));
        Assertions.assertThat((int)TestingLongStateHandleHelper.getGlobalStorageSize()).isOne();
        Assertions.assertThat((long)TestingLongStateHandleHelper.getStateHandleValueByIndex(0)).isEqualTo(81282227L);
        Assertions.assertThat((int)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(0)).isZero();
    }

    @Test
    void testAddAndLockExistingNode() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        CuratorFramework client = this.getZooKeeperClient();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)stateHandleProvider);
        String path = "/test";
        long firstState = 1337L;
        long secondState = 7331L;
        store.addAndLock("/test", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(1337L)));
        Assertions.assertThatExceptionOfType(StateHandleStore.AlreadyExistException.class).isThrownBy(() -> store.addAndLock("/test", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(7331L))));
        Assertions.assertThat((int)TestingLongStateHandleHelper.getGlobalStorageSize()).isOne();
        Assertions.assertThat((long)TestingLongStateHandleHelper.getStateHandleValueByIndex(0)).isEqualTo(1337L);
        Assertions.assertThat((int)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(0)).isZero();
        Assertions.assertThat((long)((TestingLongStateHandleHelper.LongStateHandle)((Object)store.getAndLock("/test").retrieveState())).getValue()).isEqualTo(1337L);
    }

    @Test
    void testAddAndLockRetrySuccessfulTransaction() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        CuratorFramework client = this.getZooKeeperClient();
        ZooKeeperStateHandleStore<TestingLongStateHandleHelper.LongStateHandle> store = new ZooKeeperStateHandleStore<TestingLongStateHandleHelper.LongStateHandle>(client, (RetrievableStateStorageHelper)stateHandleProvider){

            protected void writeStoreHandleTransactionally(String path, byte[] serializedStoreHandle) throws Exception {
                super.writeStoreHandleTransactionally(path, serializedStoreHandle);
                throw new KeeperException.NodeExistsException("Committed transaction has been retried.");
            }
        };
        String path = "/test";
        long firstState = 1337L;
        store.addAndLock("/test", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(1337L)));
        Assertions.assertThat((int)TestingLongStateHandleHelper.getGlobalStorageSize()).isOne();
        Assertions.assertThat((long)TestingLongStateHandleHelper.getStateHandleValueByIndex(0)).isEqualTo(1337L);
        Assertions.assertThat((int)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(0)).isZero();
        Assertions.assertThat((long)((TestingLongStateHandleHelper.LongStateHandle)((Object)store.getAndLock("/test").retrieveState())).getValue()).isEqualTo(1337L);
    }

    @Test
    void testAddFailureHandlingForBadArgumentsException() {
        this.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.BadArgumentsException());
    }

    @Test
    void testAddFailureHandlingForNoNodeException() {
        this.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.NoNodeException());
    }

    @Test
    void testAddFailureHandlingForNoAuthException() {
        this.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.NoAuthException());
    }

    @Test
    void testAddFailureHandlingForBadVersionException() {
        this.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.BadVersionException());
    }

    @Test
    void testAddFailureHandlingForAuthFailedException() {
        this.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.AuthFailedException());
    }

    @Test
    void testAddFailureHandlingForInvalidACLException() {
        this.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.InvalidACLException());
    }

    @Test
    void testAddFailureHandlingForSessionMovedException() {
        this.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.SessionMovedException());
    }

    @Test
    void testAddFailureHandlingForNotReadOnlyException() {
        this.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.NotReadOnlyException());
    }

    private void testFailingAddWithStateDiscardTriggeredFor(Exception actualException) {
        this.testFailingAddWithStateDiscardTriggeredFor(actualException, actualException.getClass());
    }

    private void testFailingAddWithStateDiscardTriggeredFor(final Exception actualException, Class<? extends Throwable> expectedException) {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore<TestingLongStateHandleHelper.LongStateHandle> store = new ZooKeeperStateHandleStore<TestingLongStateHandleHelper.LongStateHandle>(this.getZooKeeperClient(), (RetrievableStateStorageHelper)stateHandleProvider){

            protected void writeStoreHandleTransactionally(String path, byte[] serializedStoreHandle) throws Exception {
                throw actualException;
            }
        };
        String pathInZooKeeper = "/testAddDiscardStateHandleAfterFailure-" + expectedException.getSimpleName();
        long state = 81282227L;
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(expectedException).as(expectedException.getSimpleName() + " should have been thrown.", new Object[0])).isThrownBy(() -> ZooKeeperStateHandleStoreTest.lambda$testFailingAddWithStateDiscardTriggeredFor$5((ZooKeeperStateHandleStore)store, pathInZooKeeper));
        Assertions.assertThat((int)TestingLongStateHandleHelper.getGlobalStorageSize()).isOne();
        Assertions.assertThat((long)TestingLongStateHandleHelper.getStateHandleValueByIndex(0)).isEqualTo(81282227L);
        Assertions.assertThat((int)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(0)).isOne();
    }

    @Test
    void testReplace() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeper = "/testReplace";
        long initialState = 30968470898L;
        long replaceState = 88383776661L;
        store.addAndLock("/testReplace", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(30968470898L)));
        store.replace("/testReplace", IntegerResourceVersion.valueOf((int)0), (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(88383776661L)));
        Assertions.assertThat((int)TestingLongStateHandleHelper.getGlobalStorageSize()).isEqualTo(2);
        Assertions.assertThat((long)TestingLongStateHandleHelper.getStateHandleValueByIndex(0)).isEqualTo(30968470898L);
        Assertions.assertThat((long)TestingLongStateHandleHelper.getStateHandleValueByIndex(1)).isEqualTo(88383776661L);
        Stat stat = (Stat)this.getZooKeeperClient().checkExists().forPath("/testReplace");
        Assertions.assertThat((Object)stat).isNotNull();
        Assertions.assertThat((long)stat.getEphemeralOwner()).isZero();
        long actual = ((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)InstantiationUtil.deserializeObject((byte[])((byte[])this.getZooKeeperClient().getData().forPath("/testReplace")), (ClassLoader)ClassLoader.getSystemClassLoader())).retrieveState())).getValue();
        Assertions.assertThat((long)actual).isEqualTo(88383776661L);
    }

    @Test
    void testReplaceRequiringALock() throws Exception {
        CuratorFramework client = ZooKeeperUtils.useNamespaceAndEnsurePath((CuratorFramework)this.getZooKeeperClient(), (String)"/testReplaceOnMarkedForDeletionNode");
        ZooKeeperStateHandleStore zkStore = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)new TestingLongStateHandleHelper());
        long oldState = 1L;
        TestingLongStateHandleHelper.LongStateHandle oldStateHandle = new TestingLongStateHandleHelper.LongStateHandle(1L);
        String nodeName = "node";
        String path = ZooKeeperUtils.generateZookeeperPath((String[])new String[]{"node"});
        zkStore.addAndLock(path, (Serializable)((Object)oldStateHandle));
        zkStore.release(path);
        IntegerResourceVersion versionBeforeDeletion = zkStore.exists(path);
        long updatedState = 3L;
        TestingLongStateHandleHelper.LongStateHandle updatedStateHandle = new TestingLongStateHandleHelper.LongStateHandle(3L);
        Assertions.assertThatThrownBy(() -> zkStore.replace(path, versionBeforeDeletion, (Serializable)((Object)updatedStateHandle))).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testReplaceNonExistingPath() {
        TestingLongStateHandleHelper stateStorage = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)stateStorage);
        Assertions.assertThatThrownBy(() -> store.replace("/testReplaceNonExistingPath", IntegerResourceVersion.valueOf((int)0), (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(1L)))).isInstanceOf(Exception.class);
    }

    @Test
    void testReplaceDiscardStateHandleAfterFailure() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        CuratorFramework client = (CuratorFramework)Mockito.spy((Object)this.getZooKeeperClient());
        Mockito.when((Object)client.setData()).thenThrow(new Throwable[]{new RuntimeException("Expected test Exception.")});
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeper = "/testReplaceDiscardStateHandleAfterFailure";
        long initialState = 30968470898L;
        long replaceState = 88383776661L;
        store.addAndLock("/testReplaceDiscardStateHandleAfterFailure", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(30968470898L)));
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(Exception.class).as("Did not throw expected exception", new Object[0])).isThrownBy(() -> store.replace("/testReplaceDiscardStateHandleAfterFailure", IntegerResourceVersion.valueOf((int)0), (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(88383776661L))));
        Assertions.assertThat((int)TestingLongStateHandleHelper.getGlobalStorageSize()).isEqualTo(2);
        Assertions.assertThat((long)TestingLongStateHandleHelper.getStateHandleValueByIndex(0)).isEqualTo(30968470898L);
        Assertions.assertThat((long)TestingLongStateHandleHelper.getStateHandleValueByIndex(1)).isEqualTo(88383776661L);
        Assertions.assertThat((int)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(0)).isZero();
        Assertions.assertThat((int)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(1)).isZero();
        long actual = ((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)InstantiationUtil.deserializeObject((byte[])((byte[])this.getZooKeeperClient().getData().forPath("/testReplaceDiscardStateHandleAfterFailure")), (ClassLoader)ClassLoader.getSystemClassLoader())).retrieveState())).getValue();
        Assertions.assertThat((long)actual).isEqualTo(30968470898L);
    }

    @Test
    void testDiscardAfterReplaceFailureWithNoNodeException() throws Exception {
        this.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.NoNodeException(), StateHandleStore.NotExistException.class);
    }

    @Test
    void testDiscardAfterReplaceFailureWithNodeExistsException() throws Exception {
        this.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.NodeExistsException());
    }

    @Test
    void testDiscardAfterReplaceFailureWithBadArgumentsException() throws Exception {
        this.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.BadArgumentsException());
    }

    @Test
    void testDiscardAfterReplaceFailureWithNoAuthException() throws Exception {
        this.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.NoAuthException());
    }

    @Test
    void testDiscardAfterReplaceFailureWithBadVersionException() throws Exception {
        this.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.BadVersionException());
    }

    @Test
    void testDiscardAfterReplaceFailureWithAuthFailedException() throws Exception {
        this.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.AuthFailedException());
    }

    @Test
    void testDiscardAfterReplaceFailureWithInvalidACLException() throws Exception {
        this.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.InvalidACLException());
    }

    @Test
    void testDiscardAfterReplaceFailureWithSessionMovedException() throws Exception {
        this.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.SessionMovedException());
    }

    @Test
    void testDiscardAfterReplaceFailureWithNotReadOnlyException() throws Exception {
        this.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.NotReadOnlyException());
    }

    private void testDiscardAfterReplaceFailureWith(Exception actualException) throws Exception {
        this.testDiscardAfterReplaceFailureWith(actualException, actualException.getClass());
    }

    private void testDiscardAfterReplaceFailureWith(final Exception actualException, Class<? extends Throwable> expectedExceptionClass) throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore<TestingLongStateHandleHelper.LongStateHandle> store = new ZooKeeperStateHandleStore<TestingLongStateHandleHelper.LongStateHandle>(this.getZooKeeperClient(), (RetrievableStateStorageHelper)stateHandleProvider){

            protected void setStateHandle(String path, byte[] serializedStateHandle, int expectedVersion) throws Exception {
                throw actualException;
            }
        };
        String pathInZooKeeper = "/testReplaceDiscardStateHandleAfterFailure-" + expectedExceptionClass.getSimpleName();
        long initialState = 30968470898L;
        long replaceState = 88383776661L;
        store.addAndLock(pathInZooKeeper, (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(30968470898L)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ZooKeeperStateHandleStoreTest.lambda$testDiscardAfterReplaceFailureWith$9((ZooKeeperStateHandleStore)store, pathInZooKeeper)).as("Did not throw expected exception", new Object[0])).isInstanceOf(expectedExceptionClass);
        Assertions.assertThat((int)TestingLongStateHandleHelper.getGlobalStorageSize()).isEqualTo(2);
        Assertions.assertThat((long)TestingLongStateHandleHelper.getStateHandleValueByIndex(0)).isEqualTo(30968470898L);
        Assertions.assertThat((long)TestingLongStateHandleHelper.getStateHandleValueByIndex(1)).isEqualTo(88383776661L);
        Assertions.assertThat((int)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(0)).isZero();
        Assertions.assertThat((int)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(1)).isOne();
        long actual = ((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)InstantiationUtil.deserializeObject((byte[])((byte[])this.getZooKeeperClient().getData().forPath(pathInZooKeeper)), (ClassLoader)ClassLoader.getSystemClassLoader())).retrieveState())).getValue();
        Assertions.assertThat((long)actual).isEqualTo(30968470898L);
    }

    @Test
    void testGetAndExists() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeper = "/testGetAndExists";
        long state = 311222268470898L;
        Assertions.assertThat((boolean)store.exists("/testGetAndExists").isExisting()).isFalse();
        store.addAndLock("/testGetAndExists", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(311222268470898L)));
        RetrievableStateHandle actual = store.getAndLock("/testGetAndExists");
        Assertions.assertThat((long)((TestingLongStateHandleHelper.LongStateHandle)((Object)actual.retrieveState())).getValue()).isEqualTo(311222268470898L);
        Assertions.assertThat((int)store.exists("/testGetAndExists").getValue()).isGreaterThanOrEqualTo(0);
    }

    @Test
    void testExistsOnMarkedForDeletionNode() throws Exception {
        CuratorFramework client = ZooKeeperUtils.useNamespaceAndEnsurePath((CuratorFramework)this.getZooKeeperClient(), (String)"/testExistsOnMarkedForDeletionEntry");
        ZooKeeperStateHandleStore zkStore = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)new TestingLongStateHandleHelper());
        String markedForDeletionPath = "marked-for-deletion";
        zkStore.addAndLock(ZooKeeperUtils.generateZookeeperPath((String[])new String[]{"marked-for-deletion"}), (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(1L)));
        ZooKeeperStateHandleStoreTest.markNodeForDeletion(client, "marked-for-deletion");
        Assertions.assertThat((boolean)zkStore.exists(ZooKeeperUtils.generateZookeeperPath((String[])new String[]{"marked-for-deletion"})).isExisting()).isFalse();
    }

    @Test
    void testGetNonExistingPath() {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)stateHandleProvider);
        Assertions.assertThatThrownBy(() -> store.getAndLock("/testGetNonExistingPath")).isInstanceOf(Exception.class);
    }

    @Test
    void testGetAll() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeper = "/testGetAll";
        HashSet<Long> expected = new HashSet<Long>();
        expected.add(311222268470898L);
        expected.add(132812888L);
        expected.add(27255442L);
        expected.add(11122233124L);
        Iterator iterator = expected.iterator();
        while (iterator.hasNext()) {
            long val = (Long)iterator.next();
            store.addAndLock("/testGetAll" + val, (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(val)));
        }
        for (Tuple2 val : store.getAllAndLock()) {
            Assertions.assertThat((boolean)expected.remove(((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)val.f0).retrieveState())).getValue())).isTrue();
        }
        Assertions.assertThat(expected).isEmpty();
    }

    @Test
    void testGetAllAndLockOnConcurrentDelete() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        CuratorFramework client = ZooKeeperUtils.useNamespaceAndEnsurePath((CuratorFramework)this.getZooKeeperClient(), (String)"/testGetAllAndLockOnConcurrentDelete");
        ZooKeeperStateHandleStore storeForCreationAndDeletion = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)stateHandleProvider);
        ZooKeeperStateHandleStore storeForRetrieval = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeperPrefix = "/node";
        long stateForDeletion = 42L;
        String handlePathForDeletion = "/node-for-deletion";
        storeForCreationAndDeletion.addAndLock("/node-for-deletion", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(42L)));
        long stateToKeep = 44L;
        storeForCreationAndDeletion.addAndLock("/node-keep", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(44L)));
        List actuallyLockedHandles = storeForRetrieval.getAllAndLock(parentPath -> {
            List childNodes = (List)client.getChildren().forPath(parentPath);
            if (storeForCreationAndDeletion.exists("/node-for-deletion").isExisting()) {
                storeForCreationAndDeletion.releaseAndTryRemove("/node-for-deletion");
            }
            return childNodes;
        });
        ((AbstractLongAssert)Assertions.assertThat((long)((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)((Tuple2)Iterables.getOnlyElement((Iterable)actuallyLockedHandles)).f0).retrieveState())).getValue()).as("Only the StateHandle that was expected to be kept should be returned.", new Object[0])).isEqualTo(44L);
    }

    @Test
    void testGetAllAndLockWhileEntryIsMarkedForDeletion() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        CuratorFramework client = ZooKeeperUtils.useNamespaceAndEnsurePath((CuratorFramework)this.getZooKeeperClient(), (String)"/testGetAllAndLockWhileEntryIsMarkedForDeletion");
        ZooKeeperStateHandleStore stateHandleStore = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeperPrefix = "/node";
        long stateForDeletion = 42L;
        String handlePathForDeletion = "/node-for-deletion";
        stateHandleStore.addAndLock("/node-for-deletion", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(42L)));
        client.delete().deletingChildrenIfNeeded().forPath(ZooKeeperStateHandleStore.getRootLockPath((String)"/node-for-deletion"));
        long stateToKeep = 44L;
        stateHandleStore.addAndLock("/node-keep", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(44L)));
        List actuallyLockedHandles = stateHandleStore.getAllAndLock();
        ((AbstractLongAssert)Assertions.assertThat((long)((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)((Tuple2)Iterables.getOnlyElement((Iterable)actuallyLockedHandles)).f0).retrieveState())).getValue()).as("Only the StateHandle that was expected to be kept should be returned.", new Object[0])).isEqualTo(44L);
    }

    @Test
    void testGetAllSortedByName() throws Exception {
        Object[] expected;
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)stateHandleProvider);
        String basePath = "/testGetAllSortedByName";
        Object[] objectArray = expected = new Long[]{311222268470898L, 132812888L, 27255442L, 11122233124L};
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            long val = objectArray[i];
            String pathInZooKeeper = String.format("%s%016d", "/testGetAllSortedByName", val);
            store.addAndLock(pathInZooKeeper, (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(val)));
        }
        List actual = store.getAllAndLock();
        Assertions.assertThat((List)actual).hasSize(expected.length);
        Arrays.sort(expected);
        actual.sort(Comparator.comparing(o -> (String)o.f1));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertThat((Long)((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)((Tuple2)actual.get((int)i)).f0).retrieveState())).getValue()).isEqualTo(expected[i]);
        }
    }

    @Test
    void testRemove() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeper = "/testRemove";
        store.addAndLock("/testRemove", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(27255442L)));
        int numberOfGlobalDiscardCalls = TestingLongStateHandleHelper.getGlobalDiscardCount();
        store.releaseAndTryRemove("/testRemove");
        Assertions.assertThat((List)((List)this.getZooKeeperClient().getChildren().forPath("/"))).isEmpty();
        Assertions.assertThat((int)TestingLongStateHandleHelper.getGlobalDiscardCount()).isEqualTo(numberOfGlobalDiscardCalls + 1);
    }

    @Test
    void testCorruptedData() throws Exception {
        TestingLongStateHandleHelper stateStorage = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)stateStorage);
        HashSet<Long> input = new HashSet<Long>();
        input.add(1L);
        input.add(2L);
        input.add(3L);
        for (Long aLong : input) {
            store.addAndLock("/" + aLong, (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(aLong)));
        }
        this.getZooKeeperClient().setData().forPath("/2", new byte[2]);
        List allEntries = store.getAllAndLock();
        HashSet expected = new HashSet(input);
        expected.remove(2L);
        HashSet<Long> actual = new HashSet<Long>(expected.size());
        for (Tuple2 entry : allEntries) {
            actual.add(((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)entry.f0).retrieveState())).getValue());
        }
        Assertions.assertThat(actual).isEqualTo(expected);
    }

    @Test
    void testConcurrentDeleteOperation() throws Exception {
        TestingLongStateHandleHelper longStateStorage = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore zkStore1 = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)longStateStorage);
        ZooKeeperStateHandleStore zkStore2 = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)longStateStorage);
        String statePath = "/state";
        zkStore1.addAndLock("/state", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(42L)));
        RetrievableStateHandle stateHandle = zkStore2.getAndLock("/state");
        zkStore1.releaseAndTryRemove("/state");
        Assertions.assertThat((long)((TestingLongStateHandleHelper.LongStateHandle)((Object)stateHandle.retrieveState())).getValue()).isEqualTo(42L);
        Stat nodeStat = (Stat)this.getZooKeeperClient().checkExists().forPath("/state");
        ((ObjectAssert)Assertions.assertThat((Object)nodeStat).as("NodeStat should not be null, otherwise the referenced node does not exist.", new Object[0])).isNotNull();
        zkStore2.releaseAndTryRemove("/state");
        nodeStat = (Stat)this.getZooKeeperClient().checkExists().forPath("/state");
        ((ObjectAssert)Assertions.assertThat((Object)nodeStat).as("NodeState should be null, because the referenced node should no longer exist.", new Object[0])).isNull();
    }

    @Test
    void testLockCleanupWhenGetAndLockFails() throws Exception {
        TestingLongStateHandleHelper longStateStorage = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore zkStore1 = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)longStateStorage);
        ZooKeeperStateHandleStore zkStore2 = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)longStateStorage);
        String path = "/state";
        zkStore1.addAndLock("/state", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(42L)));
        byte[] corruptedData = new byte[]{1, 2};
        this.getZooKeeperClient().setData().forPath("/state", corruptedData);
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IOException.class).as("Should fail because we cannot deserialize the node's data", new Object[0])).isThrownBy(() -> zkStore2.getAndLock("/state"));
        String lockNodePath = zkStore2.getInstanceLockPath("/state");
        Stat stat = (Stat)this.getZooKeeperClient().checkExists().forPath(lockNodePath);
        ((ObjectAssert)Assertions.assertThat((Object)stat).as("zkStore2 should not have created a lock node.", new Object[0])).isNull();
        Collection children = (Collection)this.getZooKeeperClient().getChildren().forPath("/state");
        Assertions.assertThat((Collection)children).hasSize(1);
        zkStore1.releaseAndTryRemove("/state");
        stat = (Stat)this.getZooKeeperClient().checkExists().forPath("/state");
        ((ObjectAssert)Assertions.assertThat((Object)stat).as("The state node should have been removed.", new Object[0])).isNull();
    }

    @Test
    void testLockCleanupWhenClientTimesOut() throws Exception {
        TestingLongStateHandleHelper longStateStorage = new TestingLongStateHandleHelper();
        Configuration configuration = new Configuration();
        configuration.set(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, (Object)this.zooKeeperExtension.getConnectString());
        configuration.set(HighAvailabilityOptions.ZOOKEEPER_SESSION_TIMEOUT, (Object)Duration.ofMillis(100L));
        configuration.set(HighAvailabilityOptions.HA_ZOOKEEPER_ROOT, (Object)"timeout");
        try (CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper = ZooKeeperUtils.startCuratorFramework((Configuration)configuration, (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);
             CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper2 = ZooKeeperUtils.startCuratorFramework((Configuration)configuration, (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);){
            CuratorFramework client = curatorFrameworkWrapper.asCuratorFramework();
            CuratorFramework client2 = curatorFrameworkWrapper2.asCuratorFramework();
            ZooKeeperStateHandleStore zkStore = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)longStateStorage);
            String path = "/state";
            zkStore.addAndLock("/state", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(42L)));
            client.close();
            Stat stat = (Stat)client2.checkExists().forPath("/state");
            Assertions.assertThat((Object)stat).isNotNull();
            Collection children = (Collection)client2.getChildren().forPath(ZooKeeperStateHandleStore.getRootLockPath((String)"/state"));
            Assertions.assertThat((Collection)children).isEmpty();
        }
    }

    @Test
    void testRelease() throws Exception {
        TestingLongStateHandleHelper longStateStorage = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore zkStore = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)longStateStorage);
        String path = "/state";
        zkStore.addAndLock("/state", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(42L)));
        String lockPath = zkStore.getInstanceLockPath("/state");
        Stat stat = (Stat)this.getZooKeeperClient().checkExists().forPath(lockPath);
        ((ObjectAssert)Assertions.assertThat((Object)stat).as("Expected an existing lock", new Object[0])).isNotNull();
        zkStore.release("/state");
        stat = (Stat)this.getZooKeeperClient().checkExists().forPath(ZooKeeperStateHandleStore.getRootLockPath((String)"/state"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)stat.getNumChildren()).as("Expected no lock nodes as children", new Object[0])).isZero();
        zkStore.releaseAndTryRemove("/state");
        stat = (Stat)this.getZooKeeperClient().checkExists().forPath("/state");
        ((ObjectAssert)Assertions.assertThat((Object)stat).as("State node should have been removed.", new Object[0])).isNull();
    }

    @Test
    void testReleaseAll() throws Exception {
        Stat stat;
        TestingLongStateHandleHelper longStateStorage = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore zkStore = new ZooKeeperStateHandleStore(this.getZooKeeperClient(), (RetrievableStateStorageHelper)longStateStorage);
        List<String> paths = Arrays.asList("/state1", "/state2", "/state3");
        for (String path : paths) {
            zkStore.addAndLock(path, (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(42L)));
        }
        for (String path : paths) {
            stat = (Stat)this.getZooKeeperClient().checkExists().forPath(zkStore.getInstanceLockPath(path));
            ((ObjectAssert)Assertions.assertThat((Object)stat).as("Expecte and existing lock.", new Object[0])).isNotNull();
        }
        zkStore.releaseAll();
        for (String path : paths) {
            stat = (Stat)this.getZooKeeperClient().checkExists().forPath(ZooKeeperStateHandleStore.getRootLockPath((String)path));
            Assertions.assertThat((int)stat.getNumChildren()).isZero();
        }
    }

    @Test
    void testRemoveAllHandlesShouldRemoveAllPaths() throws Exception {
        ZooKeeperStateHandleStore zkStore = new ZooKeeperStateHandleStore(ZooKeeperUtils.useNamespaceAndEnsurePath((CuratorFramework)this.getZooKeeperClient(), (String)"/path"), (RetrievableStateStorageHelper)new TestingLongStateHandleHelper());
        zkStore.addAndLock("/state", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(1L)));
        zkStore.clearEntries();
        Assertions.assertThat((Collection)zkStore.getAllHandles()).isEmpty();
    }

    @Test
    void testGetAllHandlesWithMarkedForDeletionEntries() throws Exception {
        CuratorFramework client = ZooKeeperUtils.useNamespaceAndEnsurePath((CuratorFramework)this.getZooKeeperClient(), (String)"/testGetAllHandlesWithMarkedForDeletionEntries");
        ZooKeeperStateHandleStore zkStore = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)new TestingLongStateHandleHelper());
        String notMarkedForDeletionNodeName = "not-marked-for-deletion";
        String markedForDeletionNodeName = "marked-for-deletion";
        zkStore.addAndLock(ZooKeeperUtils.generateZookeeperPath((String[])new String[]{"not-marked-for-deletion"}), (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(1L)));
        zkStore.addAndLock(ZooKeeperUtils.generateZookeeperPath((String[])new String[]{"marked-for-deletion"}), (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(2L)));
        ZooKeeperStateHandleStoreTest.markNodeForDeletion(client, "marked-for-deletion");
        Assertions.assertThat((Collection)zkStore.getAllHandles()).containsExactlyInAnyOrder((Object[])new String[]{"not-marked-for-deletion", "marked-for-deletion"});
    }

    private static void markNodeForDeletion(CuratorFramework client, String childNodeName) throws Exception {
        client.delete().deletingChildrenIfNeeded().forPath(ZooKeeperStateHandleStore.getRootLockPath((String)ZooKeeperUtils.generateZookeeperPath((String[])new String[]{childNodeName})));
    }

    private static TestingLongStateHandleHelper.PreDiscardCallback throwExceptionOnce(RuntimeException e) {
        return discardIdx -> {
            if (discardIdx == 0) {
                throw e;
            }
        };
    }

    private static /* synthetic */ void lambda$testDiscardAfterReplaceFailureWith$9(ZooKeeperStateHandleStore store, String pathInZooKeeper) throws Throwable {
        store.replace(pathInZooKeeper, IntegerResourceVersion.valueOf((int)0), (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(88383776661L)));
    }

    private static /* synthetic */ void lambda$testFailingAddWithStateDiscardTriggeredFor$5(ZooKeeperStateHandleStore store, String pathInZooKeeper) throws Throwable {
        store.addAndLock(pathInZooKeeper, (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(81282227L)));
    }
}

