/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.File;
import java.net.InetAddress;
import java.util.UUID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.util.Preconditions;

public class TestingTaskManagerRuntimeInfo
implements TaskManagerRuntimeInfo {
    private final Configuration configuration;
    private final String[] tmpDirectories;
    private final String taskManagerExternalAddress;
    private final File tmpWorkingDirectory;

    public TestingTaskManagerRuntimeInfo() {
        this(new Configuration(), EnvironmentInformation.getTemporaryFileDirectory().split(",|" + File.pathSeparator));
    }

    public TestingTaskManagerRuntimeInfo(Configuration configuration) {
        this(configuration, EnvironmentInformation.getTemporaryFileDirectory());
    }

    public TestingTaskManagerRuntimeInfo(Configuration configuration, File tmpWorkingDirectory) {
        this(configuration, new String[]{EnvironmentInformation.getTemporaryFileDirectory()}, InetAddress.getLoopbackAddress().getHostAddress(), tmpWorkingDirectory);
    }

    public TestingTaskManagerRuntimeInfo(Configuration configuration, String tmpDirectory) {
        this(configuration, new String[]{(String)Preconditions.checkNotNull((Object)tmpDirectory)});
    }

    public TestingTaskManagerRuntimeInfo(Configuration configuration, String[] tmpDirectories) {
        this(configuration, tmpDirectories, InetAddress.getLoopbackAddress().getHostAddress(), new File(EnvironmentInformation.getTemporaryFileDirectory(), "tmp_" + String.valueOf(UUID.randomUUID())));
    }

    public TestingTaskManagerRuntimeInfo(Configuration configuration, String[] tmpDirectories, String taskManagerExternalAddress, File tmpWorkingDirectory) {
        this.configuration = configuration;
        this.tmpDirectories = tmpDirectories;
        this.taskManagerExternalAddress = taskManagerExternalAddress;
        this.tmpWorkingDirectory = tmpWorkingDirectory;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String[] getTmpDirectories() {
        return this.tmpDirectories;
    }

    public boolean shouldExitJvmOnOutOfMemoryError() {
        return false;
    }

    public String getTaskManagerExternalAddress() {
        return this.taskManagerExternalAddress;
    }

    public File getTmpWorkingDirectory() {
        return this.tmpWorkingDirectory;
    }
}

