/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.ExecutionVertexVersion;
import org.apache.flink.runtime.scheduler.ExecutionVertexVersioner;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ExecutionVertexVersionerTest {
    private static final ExecutionVertexID TEST_EXECUTION_VERTEX_ID1 = new ExecutionVertexID(new JobVertexID(), 0);
    private static final ExecutionVertexID TEST_EXECUTION_VERTEX_ID2 = new ExecutionVertexID(new JobVertexID(), 0);
    private static final Collection<ExecutionVertexID> TEST_ALL_EXECUTION_VERTEX_IDS = Arrays.asList(TEST_EXECUTION_VERTEX_ID1, TEST_EXECUTION_VERTEX_ID2);
    private ExecutionVertexVersioner executionVertexVersioner;

    ExecutionVertexVersionerTest() {
    }

    @BeforeEach
    private void setUp() {
        this.executionVertexVersioner = new ExecutionVertexVersioner();
    }

    @Test
    void isModifiedReturnsFalseIfVertexUnmodified() {
        ExecutionVertexVersion executionVertexVersion = this.executionVertexVersioner.recordModification(TEST_EXECUTION_VERTEX_ID1);
        Assertions.assertThat((boolean)this.executionVertexVersioner.isModified(executionVertexVersion)).isFalse();
    }

    @Test
    void isModifiedReturnsTrueIfVertexIsModified() {
        ExecutionVertexVersion executionVertexVersion = this.executionVertexVersioner.recordModification(TEST_EXECUTION_VERTEX_ID1);
        this.executionVertexVersioner.recordModification(TEST_EXECUTION_VERTEX_ID1);
        Assertions.assertThat((boolean)this.executionVertexVersioner.isModified(executionVertexVersion)).isTrue();
    }

    @Test
    void throwsExceptionIfVertexWasNeverModified() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executionVertexVersioner.isModified(new ExecutionVertexVersion(TEST_EXECUTION_VERTEX_ID1, 0L))).withFailMessage("Expected exception not thrown", new Object[0])).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Execution vertex " + String.valueOf(TEST_EXECUTION_VERTEX_ID1) + " does not have a recorded version");
    }

    @Test
    void getUnmodifiedVerticesAllVerticesModified() {
        HashSet executionVertexVersions = new HashSet(this.executionVertexVersioner.recordVertexModifications(TEST_ALL_EXECUTION_VERTEX_IDS).values());
        this.executionVertexVersioner.recordVertexModifications(TEST_ALL_EXECUTION_VERTEX_IDS);
        Set unmodifiedExecutionVertices = this.executionVertexVersioner.getUnmodifiedExecutionVertices(executionVertexVersions);
        Assertions.assertThat((Collection)unmodifiedExecutionVertices).isEmpty();
    }

    @Test
    void getUnmodifiedVerticesNoVertexModified() {
        HashSet executionVertexVersions = new HashSet(this.executionVertexVersioner.recordVertexModifications(TEST_ALL_EXECUTION_VERTEX_IDS).values());
        Set unmodifiedExecutionVertices = this.executionVertexVersioner.getUnmodifiedExecutionVertices(executionVertexVersions);
        Assertions.assertThat((Collection)unmodifiedExecutionVertices).contains((Object[])new ExecutionVertexID[]{TEST_EXECUTION_VERTEX_ID1, TEST_EXECUTION_VERTEX_ID2});
    }

    @Test
    void getUnmodifiedVerticesPartOfVerticesModified() {
        HashSet executionVertexVersions = new HashSet(this.executionVertexVersioner.recordVertexModifications(TEST_ALL_EXECUTION_VERTEX_IDS).values());
        this.executionVertexVersioner.recordModification(TEST_EXECUTION_VERTEX_ID1);
        Set unmodifiedExecutionVertices = this.executionVertexVersioner.getUnmodifiedExecutionVertices(executionVertexVersions);
        Assertions.assertThat((Collection)unmodifiedExecutionVertices).contains((Object[])new ExecutionVertexID[]{TEST_EXECUTION_VERTEX_ID2});
    }
}

