/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.exceptions.UnknownTaskExecutorException;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerProfilingListHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.ProfilingInfo;
import org.apache.flink.runtime.rest.messages.ProfilingInfoList;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerProfilingListHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TaskManagerProfilingListHandlerTest {
    private static final ResourceID EXPECTED_TASK_MANAGER_ID = ResourceID.generate();
    private TestingResourceManagerGateway resourceManagerGateway;
    private TaskManagerProfilingListHandler taskManagerProfilingListHandler;
    private HandlerRequest<EmptyRequestBody> handlerRequest;

    TaskManagerProfilingListHandlerTest() {
    }

    @BeforeEach
    void setUp() throws HandlerRequestException {
        this.resourceManagerGateway = new TestingResourceManagerGateway();
        this.taskManagerProfilingListHandler = new TaskManagerProfilingListHandler(() -> CompletableFuture.completedFuture(null), TestingUtils.TIMEOUT, Collections.emptyMap(), (MessageHeaders)TaskManagerProfilingListHeaders.getInstance(), () -> CompletableFuture.completedFuture(this.resourceManagerGateway));
        this.handlerRequest = TaskManagerProfilingListHandlerTest.createRequest(EXPECTED_TASK_MANAGER_ID);
    }

    @Test
    void testGetTaskManagerProfilingList() throws Exception {
        ProfilingInfoList profilingInfoList = new ProfilingInfoList(Arrays.asList(ProfilingInfo.create((long)30L, (ProfilingInfo.ProfilingMode)ProfilingInfo.ProfilingMode.ITIMER), ProfilingInfo.create((long)10L, (ProfilingInfo.ProfilingMode)ProfilingInfo.ProfilingMode.CPU), ProfilingInfo.create((long)15L, (ProfilingInfo.ProfilingMode)ProfilingInfo.ProfilingMode.ALLOC)));
        this.resourceManagerGateway.setRequestProfilingListFunction(EXPECTED_TASK_MANAGER_ID -> CompletableFuture.completedFuture(profilingInfoList.getProfilingInfos()));
        ProfilingInfoList profilingInfoListResp = (ProfilingInfoList)this.taskManagerProfilingListHandler.handleRequest(this.handlerRequest, (ResourceManagerGateway)this.resourceManagerGateway).get();
        Assertions.assertThat((Collection)profilingInfoListResp.getProfilingInfos()).containsExactlyInAnyOrderElementsOf((Iterable)profilingInfoList.getProfilingInfos());
    }

    @Test
    void testGetTaskManagerProfilingListForUnknownTaskExecutorException() throws Exception {
        this.resourceManagerGateway.setRequestProfilingListFunction(EXPECTED_TASK_MANAGER_ID -> FutureUtils.completedExceptionally((Throwable)new UnknownTaskExecutorException(EXPECTED_TASK_MANAGER_ID)));
        try {
            this.taskManagerProfilingListHandler.handleRequest(this.handlerRequest, (ResourceManagerGateway)this.resourceManagerGateway).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Assertions.assertThat((Throwable)cause).isInstanceOf(RestHandlerException.class);
            RestHandlerException restHandlerException = (RestHandlerException)cause;
            Assertions.assertThat((Comparable)restHandlerException.getHttpResponseStatus()).isEqualTo((Object)HttpResponseStatus.NOT_FOUND);
            Assertions.assertThat((String)restHandlerException.getMessage()).contains(new CharSequence[]{"Could not find TaskExecutor " + String.valueOf(TaskManagerProfilingListHandlerTest.EXPECTED_TASK_MANAGER_ID)});
        }
    }

    private static HandlerRequest<EmptyRequestBody> createRequest(ResourceID taskManagerId) throws HandlerRequestException {
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        pathParameters.put("taskmanagerid", taskManagerId.toString());
        Map queryParameters = Collections.emptyMap();
        return HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TaskManagerMessageParameters(), pathParameters, queryParameters, Collections.emptyList());
    }
}

