/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.NoOpBufferAvailablityListener;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;

abstract class SubpartitionTestBase {
    SubpartitionTestBase() {
    }

    abstract ResultSubpartition createSubpartition() throws Exception;

    abstract ResultSubpartition createFailingWritesSubpartition() throws Exception;

    @TestTemplate
    void createReaderAfterDispose() throws Exception {
        ResultSubpartition subpartition = this.createSubpartition();
        subpartition.release();
        Assertions.assertThatThrownBy(() -> subpartition.createReadView(view -> {})).isInstanceOf(IllegalStateException.class);
    }

    @TestTemplate
    void testAddAfterFinish() throws Exception {
        ResultSubpartition subpartition = this.createSubpartition();
        try {
            subpartition.finish();
            Assertions.assertThat((long)subpartition.getTotalNumberOfBuffersUnsafe()).isOne();
            Assertions.assertThat((int)subpartition.getBuffersInBacklogUnsafe()).isZero();
            BufferConsumer bufferConsumer = BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4096);
            Assertions.assertThat((int)subpartition.add(bufferConsumer)).isEqualTo(-1);
            Assertions.assertThat((boolean)bufferConsumer.isRecycled()).isTrue();
            Assertions.assertThat((long)subpartition.getTotalNumberOfBuffersUnsafe()).isOne();
            Assertions.assertThat((int)subpartition.getBuffersInBacklogUnsafe()).isZero();
        }
        finally {
            if (subpartition != null) {
                subpartition.release();
            }
        }
    }

    @TestTemplate
    void testAddAfterRelease() throws Exception {
        ResultSubpartition subpartition = this.createSubpartition();
        try {
            subpartition.release();
            BufferConsumer bufferConsumer = BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4096);
            Assertions.assertThat((int)subpartition.add(bufferConsumer)).isEqualTo(-1);
            Assertions.assertThat((boolean)bufferConsumer.isRecycled()).isTrue();
        }
        finally {
            if (subpartition != null) {
                subpartition.release();
            }
        }
    }

    @TestTemplate
    void testReleasingReaderDoesNotReleasePartition() throws Exception {
        ResultSubpartition partition = this.createSubpartition();
        partition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(32768));
        partition.finish();
        ResultSubpartitionView reader = partition.createReadView((BufferAvailabilityListener)new NoOpBufferAvailablityListener());
        Assertions.assertThat((boolean)partition.isReleased()).isFalse();
        Assertions.assertThat((boolean)reader.isReleased()).isFalse();
        reader.releaseAllResources();
        Assertions.assertThat((boolean)reader.isReleased()).isTrue();
        Assertions.assertThat((boolean)partition.isReleased()).isFalse();
        partition.release();
    }

    @TestTemplate
    void testReleaseIsIdempotent() throws Exception {
        ResultSubpartition partition = this.createSubpartition();
        partition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(32768));
        partition.finish();
        partition.release();
        partition.release();
        partition.release();
    }

    @TestTemplate
    void testReadAfterDispose() throws Exception {
        ResultSubpartition partition = this.createSubpartition();
        partition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(32768));
        partition.finish();
        ResultSubpartitionView reader = partition.createReadView((BufferAvailabilityListener)new NoOpBufferAvailablityListener());
        reader.releaseAllResources();
        reader.getNextBuffer();
    }

    @TestTemplate
    void testRecycleBufferAndConsumerOnFailure() throws Exception {
        ResultSubpartition subpartition = this.createFailingWritesSubpartition();
        try {
            BufferConsumer consumer = BufferBuilderTestUtils.createFilledFinishedBufferConsumer(100);
            subpartition.add(consumer);
            Assertions.assertThatThrownBy(() -> ((ResultSubpartition)subpartition).flush());
            Assertions.assertThat((boolean)consumer.isRecycled()).isTrue();
        }
        finally {
            subpartition.release();
        }
    }
}

