/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.dispatcher.JobManagerRunnerRegistry;
import org.apache.flink.runtime.jobmaster.JobManagerRunner;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

public class TestingJobManagerRunnerRegistry
implements JobManagerRunnerRegistry {
    private final Function<JobID, Boolean> isRegisteredFunction;
    private final Consumer<JobManagerRunner> registerConsumer;
    private final Function<JobID, JobManagerRunner> getFunction;
    private final Supplier<Integer> sizeSupplier;
    private final Supplier<Set<JobID>> getRunningJobIdsSupplier;
    private final Supplier<Collection<JobManagerRunner>> getJobManagerRunnersSupplier;
    private final Function<JobID, JobManagerRunner> unregisterFunction;
    private final BiFunction<JobID, Executor, CompletableFuture<Void>> localCleanupAsyncFunction;

    private TestingJobManagerRunnerRegistry(Function<JobID, Boolean> isRegisteredFunction, Consumer<JobManagerRunner> registerConsumer, Function<JobID, JobManagerRunner> getFunction, Supplier<Integer> sizeSupplier, Supplier<Set<JobID>> getRunningJobIdsSupplier, Supplier<Collection<JobManagerRunner>> getJobManagerRunnersSupplier, Function<JobID, JobManagerRunner> unregisterFunction, BiFunction<JobID, Executor, CompletableFuture<Void>> localCleanupAsyncFunction) {
        this.isRegisteredFunction = isRegisteredFunction;
        this.registerConsumer = registerConsumer;
        this.getFunction = getFunction;
        this.sizeSupplier = sizeSupplier;
        this.getRunningJobIdsSupplier = getRunningJobIdsSupplier;
        this.getJobManagerRunnersSupplier = getJobManagerRunnersSupplier;
        this.unregisterFunction = unregisterFunction;
        this.localCleanupAsyncFunction = localCleanupAsyncFunction;
    }

    public boolean isRegistered(JobID jobId) {
        return this.isRegisteredFunction.apply(jobId);
    }

    public void register(JobManagerRunner jobManagerRunner) {
        this.registerConsumer.accept(jobManagerRunner);
    }

    public JobManagerRunner get(JobID jobId) {
        return this.getFunction.apply(jobId);
    }

    public int size() {
        return this.sizeSupplier.get();
    }

    public Set<JobID> getRunningJobIds() {
        return this.getRunningJobIdsSupplier.get();
    }

    public Collection<JobManagerRunner> getJobManagerRunners() {
        return this.getJobManagerRunnersSupplier.get();
    }

    public JobManagerRunner unregister(JobID jobId) {
        return this.unregisterFunction.apply(jobId);
    }

    public CompletableFuture<Void> localCleanupAsync(JobID jobId, Executor executor) {
        return this.localCleanupAsyncFunction.apply(jobId, executor);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder newSingleJobBuilder(AtomicReference<JobManagerRunner> singleRunnerReference) {
        return TestingJobManagerRunnerRegistry.builder().withRegisterConsumer(jobManagerRunner -> {
            Preconditions.checkState((singleRunnerReference.get() == null ? 1 : 0) != 0);
            singleRunnerReference.set((JobManagerRunner)jobManagerRunner);
        }).withIsRegisteredFunction(actualJobId -> Optional.ofNullable((JobManagerRunner)singleRunnerReference.get()).map(JobManagerRunner::getJobID).map(arg_0 -> ((JobID)actualJobId).equals(arg_0)).orElse(false)).withGetFunction(actualJobId -> Optional.ofNullable((JobManagerRunner)singleRunnerReference.get()).orElseThrow(TestingJobManagerRunnerRegistry.throwNoSuchElementException(actualJobId))).withGetJobManagerRunnersSupplier(() -> CollectionUtil.ofNullable((Object)((JobManagerRunner)singleRunnerReference.get()))).withSizeSupplier(() -> Optional.ofNullable((JobManagerRunner)singleRunnerReference.get()).map(ignored -> 1).orElse(0)).withGetRunningJobIdsSupplier(() -> Optional.ofNullable((JobManagerRunner)singleRunnerReference.get()).map(JobManagerRunner::getJobID).map(Collections::singleton).orElse(Collections.emptySet())).withUnregisterFunction(actualJobId -> TestingJobManagerRunnerRegistry.unregisterFromReference(singleRunnerReference, actualJobId).orElseThrow(TestingJobManagerRunnerRegistry.throwNoSuchElementException(actualJobId))).withLocalCleanupAsyncFunction((actualJobId, executor) -> TestingJobManagerRunnerRegistry.unregisterFromReference(singleRunnerReference, actualJobId).map(AutoCloseableAsync::closeAsync).orElse(FutureUtils.completedVoidFuture()));
    }

    private static Optional<JobManagerRunner> unregisterFromReference(AtomicReference<JobManagerRunner> singleRunnerReference, JobID actualJobId) {
        return Optional.ofNullable(singleRunnerReference.get()).map(JobManagerRunner::getJobID).filter(arg_0 -> ((JobID)actualJobId).equals(arg_0)).map(ignored -> singleRunnerReference.getAndSet(null));
    }

    private static Supplier<NoSuchElementException> throwNoSuchElementException(JobID jobId) {
        return () -> new NoSuchElementException("JobManagerRunner with job ID " + String.valueOf(jobId) + " is not registered.");
    }

    public static class Builder {
        private Function<JobID, Boolean> isRegisteredFunction = ignoredJobId -> true;
        private Consumer<JobManagerRunner> registerConsumer = ignoredRunner -> {};
        private Function<JobID, JobManagerRunner> getFunction = ignoredJobId -> null;
        private Supplier<Integer> sizeSupplier = () -> 0;
        private Supplier<Set<JobID>> getRunningJobIdsSupplier = Collections::emptySet;
        private Supplier<Collection<JobManagerRunner>> getJobManagerRunnersSupplier = Collections::emptyList;
        private Function<JobID, JobManagerRunner> unregisterFunction = ignoredJobId -> null;
        private BiFunction<JobID, Executor, CompletableFuture<Void>> localCleanupAsyncFunction = (ignoredJobId, ignoredExecutor) -> FutureUtils.completedVoidFuture();
        private BiFunction<JobID, Executor, CompletableFuture<Void>> globalCleanupAsyncFunction = (ignoredJobId, ignoredExecutor) -> FutureUtils.completedVoidFuture();

        public Builder withIsRegisteredFunction(Function<JobID, Boolean> isRegisteredFunction) {
            this.isRegisteredFunction = isRegisteredFunction;
            return this;
        }

        public Builder withRegisterConsumer(Consumer<JobManagerRunner> registerConsumer) {
            this.registerConsumer = registerConsumer;
            return this;
        }

        public Builder withGetFunction(Function<JobID, JobManagerRunner> getFunction) {
            this.getFunction = getFunction;
            return this;
        }

        public Builder withSizeSupplier(Supplier<Integer> sizeSupplier) {
            this.sizeSupplier = sizeSupplier;
            return this;
        }

        public Builder withGetRunningJobIdsSupplier(Supplier<Set<JobID>> getRunningJobIdsSupplier) {
            this.getRunningJobIdsSupplier = getRunningJobIdsSupplier;
            return this;
        }

        public Builder withGetJobManagerRunnersSupplier(Supplier<Collection<JobManagerRunner>> getJobManagerRunnersSupplier) {
            this.getJobManagerRunnersSupplier = getJobManagerRunnersSupplier;
            return this;
        }

        public Builder withUnregisterFunction(Function<JobID, JobManagerRunner> unregisterFunction) {
            this.unregisterFunction = unregisterFunction;
            return this;
        }

        public Builder withLocalCleanupAsyncFunction(BiFunction<JobID, Executor, CompletableFuture<Void>> localCleanupAsyncFunction) {
            this.localCleanupAsyncFunction = localCleanupAsyncFunction;
            return this;
        }

        public TestingJobManagerRunnerRegistry build() {
            return new TestingJobManagerRunnerRegistry(this.isRegisteredFunction, this.registerConsumer, this.getFunction, this.sizeSupplier, this.getRunningJobIdsSupplier, this.getJobManagerRunnersSupplier, this.unregisterFunction, this.localCleanupAsyncFunction);
        }
    }
}

